/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.batch.input;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import org.scijava.batch.input.BatchInput;
import org.scijava.batch.input.BatchInputProvider;
import org.scijava.module.Module;
import org.scijava.module.ModuleItem;
import org.scijava.plugin.AbstractHandlerPlugin;
import org.scijava.plugin.Plugin;

@Plugin(type=BatchInputProvider.class)
public class FileBatchInputProvider
extends AbstractHandlerPlugin<BatchInput>
implements BatchInputProvider<File> {
    public boolean supports(BatchInput input) {
        return this.canProvide(input.moduleItem());
    }

    @Override
    public boolean canProvide(ModuleItem<?> item) {
        return item.getType() == File.class && !this.hasStyle(item, "save");
    }

    @Override
    public void populateInput(Module module, ModuleItem<?> moduleItem, File inputObject) {
        moduleItem.setValue(module, (Object)inputObject);
    }

    @Override
    public String getTargetWidgetStyle(ModuleItem<?> item) {
        ArrayList<String> targetStyles = new ArrayList<String>();
        if (this.hasStyle(item, "directory")) {
            targetStyles.add("directories");
        } else {
            targetStyles.add("files");
        }
        String widgetStyle = item.getWidgetStyle();
        if (widgetStyle != null) {
            String[] styles;
            for (String s : styles = widgetStyle.trim().split("\\s*,\\s*")) {
                if (!s.startsWith("extensions")) continue;
                targetStyles.add(s);
            }
        }
        return String.join((CharSequence)",", targetStyles);
    }

    private boolean hasStyle(ModuleItem<?> item, String style) {
        String widgetStyle = item.getWidgetStyle();
        if (widgetStyle == null) {
            return false;
        }
        return Arrays.asList(widgetStyle.trim().split("\\s*,\\s*")).contains(style);
    }
}

