/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.realtransform;

import net.imglib2.FinalRealInterval;
import net.imglib2.RealInterval;
import net.imglib2.RealLocalizable;
import net.imglib2.RealPoint;
import net.imglib2.RealPositionable;
import net.imglib2.concatenate.Concatenable;
import net.imglib2.concatenate.PreConcatenable;
import net.imglib2.realtransform.RealViewsSimplifyUtils;
import net.imglib2.realtransform.ScaleAndTranslationGet;
import net.imglib2.realtransform.interval.IntervalSamplingMethod;

public class ScaleAndTranslation
implements ScaleAndTranslationGet,
Concatenable<ScaleAndTranslationGet>,
PreConcatenable<ScaleAndTranslationGet> {
    private final ScaleAndTranslation inverse;
    private final double[] scales;
    private final double[] translations;
    private final int n;
    private final RealPoint[] ds;

    public ScaleAndTranslation(double[] scales, double[] translations) {
        assert (translations.length == scales.length);
        this.scales = (double[])scales.clone();
        this.translations = (double[])translations.clone();
        this.n = translations.length;
        this.inverse = this.createInverse();
        this.ds = ScaleAndTranslation.createDs(scales);
    }

    private ScaleAndTranslation(ScaleAndTranslation inverse, double[] scales, double[] translations) {
        assert (translations.length == scales.length);
        this.inverse = inverse;
        this.scales = (double[])scales.clone();
        this.translations = (double[])translations.clone();
        this.n = inverse.n;
        this.ds = ScaleAndTranslation.createDs(scales);
    }

    private static RealPoint[] createDs(double[] scales) {
        int n = scales.length;
        RealPoint[] ds = new RealPoint[n];
        for (int d = 0; d < n; ++d) {
            RealPoint rp = new RealPoint(n);
            rp.setPosition(scales[d], d);
            ds[d] = rp;
        }
        return ds;
    }

    @Override
    public int numSourceDimensions() {
        return this.numDimensions();
    }

    @Override
    public int numTargetDimensions() {
        return this.numDimensions();
    }

    @Override
    public void apply(double[] source, double[] target) {
        assert (source.length >= this.n && target.length >= this.n);
        for (int i = 0; i < this.n; ++i) {
            target[i] = this.scales[i] * source[i] + this.translations[i];
        }
    }

    @Override
    public void apply(float[] source, float[] target) {
        assert (source.length >= this.n && target.length >= this.n);
        for (int i = 0; i < this.n; ++i) {
            target[i] = (float)(this.scales[i] * (double)source[i] + this.translations[i]);
        }
    }

    @Override
    public void apply(RealLocalizable source, RealPositionable target) {
        assert (source.numDimensions() >= this.n && target.numDimensions() >= this.n);
        for (int d = 0; d < this.n; ++d) {
            target.setPosition(this.scales[d] * source.getDoublePosition(d) + this.translations[d], d);
        }
    }

    @Override
    public void applyInverse(double[] source, double[] target) {
        this.inverse.apply(target, source);
    }

    @Override
    public void applyInverse(float[] source, float[] target) {
        this.inverse.apply(target, source);
    }

    @Override
    public void applyInverse(RealPositionable source, RealLocalizable target) {
        this.inverse.apply(target, source);
    }

    @Override
    public ScaleAndTranslation inverse() {
        return this.inverse;
    }

    public ScaleAndTranslation createInverse() {
        double[] invertedShifts = new double[this.n];
        double[] invertedScales = new double[this.n];
        for (int i = 0; i < this.n; ++i) {
            invertedScales[i] = 1.0 / this.scales[i];
            invertedShifts[i] = -this.translations[i] * invertedScales[i];
        }
        return new ScaleAndTranslation(this, invertedScales, invertedShifts);
    }

    @Override
    public ScaleAndTranslation copy() {
        return new ScaleAndTranslation(this.inverse, this.scales, this.translations);
    }

    @Override
    public double getScale(int d) {
        return this.scales[d];
    }

    @Override
    public double[] getScaleCopy() {
        return (double[])this.scales.clone();
    }

    @Override
    public double get(int row, int column) {
        if (column == row) {
            return this.scales[row];
        }
        if (column == this.scales.length) {
            return this.translations[row];
        }
        return 0.0;
    }

    @Override
    public double[] getRowPackedCopy() {
        int m = this.n + 1;
        double[] result = new double[this.n * m];
        for (int i = 0; i < this.n; ++i) {
            int firstElementInRowIndex = i * m;
            int lastElementInRowIndex = firstElementInRowIndex + this.n;
            int diagonalIndex = firstElementInRowIndex + i;
            result[diagonalIndex] = this.scales[i];
            result[lastElementInRowIndex] = this.translations[i];
        }
        return result;
    }

    public RealPoint d(int d) {
        return this.ds[d];
    }

    public int numDimensions() {
        return this.n;
    }

    @Override
    public double getTranslation(int d) {
        return this.translations[d];
    }

    @Override
    public double[] getTranslationCopy() {
        return (double[])this.translations.clone();
    }

    public ScaleAndTranslation preConcatenate(ScaleAndTranslationGet a) {
        assert (a.numDimensions() == this.n) : "Dimensions do not match.";
        for (int d = 0; d < this.n; ++d) {
            double scale = a.getScale(d);
            double translation = this.translations[d];
            int n = d;
            this.scales[n] = this.scales[n] * scale;
            this.translations[d] = a.getTranslation(d) + scale * translation;
        }
        return this;
    }

    public Class<ScaleAndTranslationGet> getPreConcatenableClass() {
        return ScaleAndTranslationGet.class;
    }

    public ScaleAndTranslation concatenate(ScaleAndTranslationGet a) {
        assert (a.numDimensions() == this.n) : "Dimensions do not match.";
        for (int d = 0; d < this.n; ++d) {
            double scale = this.scales[d];
            int n = d;
            this.scales[n] = this.scales[n] * a.getScale(d);
            int n2 = d;
            this.translations[n2] = this.translations[n2] + a.getTranslation(d) * scale;
        }
        return this;
    }

    public Class<ScaleAndTranslationGet> getConcatenableClass() {
        return ScaleAndTranslationGet.class;
    }

    @Override
    public boolean isIdentity() {
        return RealViewsSimplifyUtils.isIdentity(this);
    }

    @Override
    public RealInterval boundingInterval(RealInterval interval, IntervalSamplingMethod samplingMethdod) {
        assert (interval.numDimensions() >= this.n) : "Interval does not have enough dimensions.";
        double[] min = interval.minAsDoubleArray();
        double[] max = interval.maxAsDoubleArray();
        for (int d = 0; d < this.n; ++d) {
            min[d] = min[d] * this.scales[d] + this.translations[d];
            max[d] = max[d] * this.scales[d] + this.translations[d];
        }
        return new FinalRealInterval(min, max, false);
    }
}

