/*
 * Decompiled with CFR 0.152.
 */
package sc.fiji.balloonSegmentation.structure;

import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.process.ImageProcessor;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import sc.fiji.balloonSegmentation.structure.Balloon;
import sc.fiji.balloonSegmentation.structure.BalloonPopulation;

public class BalloonSequence {
    public BalloonPopulation[] PopList;
    ImagePlus imp;
    public int N = 0;
    int[][][] IMB;
    int channel = 1;

    public BalloonSequence(ImagePlus imp_in) {
        this.imp = imp_in;
        this.N = this.imp.getStackSize();
        ImageStack stack = this.imp.getStack();
        this.PopList = new BalloonPopulation[this.N];
        int w = stack.getProcessor(1).getWidth();
        int h = stack.getProcessor(1).getHeight();
        this.IMB = new int[w][h][3];
        for (int i = 0; i < w; ++i) {
            for (int j = 0; j < h; ++j) {
                this.IMB[i][j][0] = 0;
                this.IMB[i][j][1] = 0;
                this.IMB[i][j][2] = 0;
            }
        }
    }

    private void reinitPopulation(int currentSlice) {
        ImageProcessor impross = this.PopList[currentSlice].ipb;
        this.PopList[currentSlice] = new BalloonPopulation(impross, currentSlice, this.channel);
        this.PopList[currentSlice].set_boundaries(this.IMB);
    }

    public void setSequence(int currentSlice, ImageProcessor ipWallSegment, int rgbchannel) {
        this.PopList[currentSlice] = new BalloonPopulation(ipWallSegment, currentSlice, this.channel);
        this.PopList[currentSlice].id = currentSlice;
        this.channel = rgbchannel;
    }

    public void setSequence(int currentSlice, ImageProcessor ipWallSegment, ArrayList X0, ArrayList Y0, int rgbchannel) {
        this.channel = rgbchannel;
        this.PopList[currentSlice] = new BalloonPopulation(ipWallSegment, currentSlice, this.channel);
        this.PopList[currentSlice].id = currentSlice;
        for (int i = 0; i < X0.size(); ++i) {
            double x = (Double)X0.get(i);
            double y = (Double)Y0.get(i);
            this.PopList[currentSlice].AddNewBalloon((int)x, (int)y);
        }
    }

    public ArrayList<double[]> importSeeds(String directory, String file_name, int currentSlice) {
        StringBuffer contents = new StringBuffer();
        BufferedReader input = null;
        try {
            input = new BufferedReader(new FileReader(directory + file_name));
            String line = null;
            boolean i = false;
            ArrayList<double[]> SeedList = new ArrayList<double[]>();
            while ((line = input.readLine()) != null) {
                String[] parts = line.split("\t");
                if (!(Character.isDigit(parts[0].toCharArray()[0]) & Character.isDigit(parts[1].toCharArray()[0]))) continue;
                double x = Double.parseDouble(parts[0].trim());
                double y = Double.parseDouble(parts[1].trim());
                double z = -1.0;
                if (parts.length > 2 && Double.parseDouble(parts[2].trim()) >= 0.0 & z < Double.parseDouble(parts[2].trim())) {
                    z = Double.parseDouble(parts[2].trim());
                }
                double[] row = new double[]{x, y, z};
                SeedList.add(row);
            }
            return SeedList;
        }
        catch (IOException e) {
            IJ.error((String)"Could not load the data from file: setStructureFromFile");
            return null;
        }
    }

    public StringBuffer getStructureInfo() {
        int k;
        Balloon bal;
        int j;
        BalloonPopulation pop;
        int i;
        StringBuffer info = new StringBuffer("%Balloon data \n");
        int ini_pop = 0;
        while (this.PopList[ini_pop].N <= 0) {
            ++ini_pop;
        }
        Balloon bal0 = this.PopList[ini_pop].BallList.get(0);
        info.append("N:" + bal0.n0 + " \n");
        info.append(" \n");
        info.append(" \n");
        info.append(" \n");
        for (i = 0; i < this.N; ++i) {
            info.append("%Frame: " + i + " \n");
            pop = this.PopList[i];
            for (j = 0; j < pop.N; ++j) {
                bal = pop.BallList.get(j);
                info.append("%%\tCenter:");
                info.append("\t" + j + "\t" + bal.x0 + "\t" + bal.y0 + "\n");
                info.append("%%%\t\tVertex Positions: \n");
                for (k = 0; k < bal.n0; ++k) {
                    info.append("\t\t" + k + "\t" + Math.round(bal.XX[k]) + "\t" + Math.round(bal.YY[k]));
                    info.append("\n");
                }
            }
            info.append("\n");
        }
        info.append("*Topology \n");
        for (i = 0; i < this.N; ++i) {
            info.append("**TFrame:\t" + i + " \n");
            pop = this.PopList[i];
            for (j = 0; j < pop.N; ++j) {
                bal = pop.BallList.get(j);
                info.append("***\tBalloon:");
                info.append("\t" + bal.id + "\n");
                for (k = 0; k < bal.n0; ++k) {
                    info.append("\t\t" + k + "\t" + pop.contacts[j][k]);
                    info.append("\n");
                }
            }
        }
        return info;
    }

    public void setStructureFromFile(String directory, String file_name) {
        StringBuffer contents = new StringBuffer();
        BufferedReader input = null;
        try {
            int i;
            input = new BufferedReader(new FileReader(directory + file_name));
            String line = null;
            int index_pop = 0;
            int index_bal = 0;
            int index_vert = 0;
            int N_vert = 0;
            for (i = 0; i < 6; ++i) {
                line = input.readLine();
                String[] parts = line.split(":");
                if (i != 1) continue;
                N_vert = Integer.parseInt(parts[1].trim());
            }
            int[] XX = new int[N_vert];
            int[] YY = new int[N_vert];
            this.reinitPopulation(0);
            while ((line = input.readLine()) != null && index_pop < this.N) {
                String[] parts = line.split("\t");
                if (!line.startsWith("%%%")) {
                    if (line.startsWith("%%")) {
                        int id = Integer.parseInt(parts[2].trim());
                        int x = Integer.parseInt(parts[3].trim());
                        int y = Integer.parseInt(parts[4].trim());
                        ++index_bal;
                    } else if (line.startsWith("%")) {
                        this.PopList[index_pop].ConnectExistingBalloons();
                        index_bal = 0;
                        this.reinitPopulation(++index_pop);
                    } else if (parts.length > 2) {
                        if (index_vert < N_vert - 1) {
                            YY[index_vert] = Integer.parseInt(parts[4].trim());
                            XX[index_vert] = Integer.parseInt(parts[3].trim());
                            ++index_vert;
                        } else if (index_vert == N_vert - 1) {
                            YY[index_vert] = Integer.parseInt(parts[4].trim());
                            XX[index_vert] = Integer.parseInt(parts[3].trim());
                            this.PopList[index_pop].AddNewBalloon(XX, YY);
                            index_vert = 0;
                        }
                    }
                }
                ++i;
                if (!line.startsWith("*")) continue;
                break;
            }
            this.PopList[index_pop].ConnectExistingBalloons();
            index_pop = 0;
            index_bal = 0;
            index_vert = 0;
            int nbh_id = 0;
            BalloonPopulation pop = this.PopList[0];
            while ((line = input.readLine()) != null) {
                String[] parts = line.split("\t");
                if (line.startsWith("**") & !line.startsWith("***")) {
                    index_pop = Integer.parseInt(parts[1].trim());
                    pop = this.PopList[index_pop];
                    continue;
                }
                if (line.startsWith("***")) {
                    index_bal = Integer.parseInt(parts[2].trim());
                    continue;
                }
                if (parts.length < 4) continue;
                index_vert = Integer.parseInt(parts[2].trim());
                nbh_id = Integer.parseInt(parts[3].trim());
                Balloon bal = pop.BallList.get(index_bal);
                pop.contacts[index_bal][index_vert] = nbh_id;
                if (nbh_id < 0) continue;
                pop.topo[nbh_id][index_bal] = true;
                pop.topo[index_bal][nbh_id] = true;
            }
        }
        catch (IOException e) {
            IJ.error((String)"Could not load the data from file: setStructureFromFile");
            return;
        }
    }
}

