/*
 * Decompiled with CFR 0.152.
 */
package VolumeJ;

import VolumeJ.VJAlphaColor;
import VolumeJ.VJClassifier;
import VolumeJ.VJCutout;
import VolumeJ.VJGradient;
import VolumeJ.VJInterpolator;
import VolumeJ.VJMatrix;
import VolumeJ.VJRenderer;
import VolumeJ.VJShade;
import VolumeJ.VJShader;
import VolumeJ.VJUserInterface;
import VolumeJ.VJValue;
import VolumeJ.VJValueHSB;
import VolumeJ.VJVoxelLoc;
import volume.VolumeRGB;

public class VJRender
extends VJRenderer {
    public VJRender(VJInterpolator interpolator, VJShader shader, VJClassifier classifier) throws Exception {
        super(interpolator, shader, classifier);
    }

    @Override
    public synchronized void run() {
        VJUserInterface.status("starting VJRender");
        this.running = true;
        if (this.classifier.does() == 4) {
            this.setOutputColor();
        }
        this.newViewportBuffer();
        float[] osstep = this.mi.getStepperColumn();
        if (this.cutout instanceof VJCutout) {
            this.cutout.setup(this.m, this.mi);
        }
        long start = System.currentTimeMillis();
        VJValue value = null;
        value = this.outputType == 4 && this.v instanceof VolumeRGB ? new VJValueHSB() : new VJValue();
        for (int j = 0; j < this.height && this.running; ++j) {
            VJUserInterface.status("Render " + this.message + "(" + 100 * j / this.height + "%)...");
            VJUserInterface.progress((float)j / (float)this.height);
            for (int i = 0; i < this.width; ++i) {
                float[] vsv = VJMatrix.newVector(i + this.ioffset, j + this.joffset, this.koffset);
                VJVoxelLoc vl = new VJVoxelLoc(vsv, this.mi);
                boolean involume = false;
                VJAlphaColor pixel = this.classifier.does() == 4 ? new VJAlphaColor(0.0, 0, 0, 0) : new VJAlphaColor(0.0, 0);
                for (int k = 0; k < this.depth; ++k) {
                    if (this.onTrace(i, j)) {
                        this.trace("" + i + "," + j + " k: " + k + "(" + pixel + ") inspect: " + vl.ix + "," + vl.iy + "," + vl.iz);
                    }
                    if (pixel.notOpaque() && this.interpolator.isValid(vl, this.v)) {
                        this.interpolator.value(value, this.v, vl);
                        if (value instanceof VJValueHSB) {
                            this.interpolator.valueHS((VJValueHSB)value, (VolumeRGB)this.v, this.classifier.getThreshold(), vl);
                        }
                        value.k = k;
                        if (this.onTrace(i, j)) {
                            this.trace(" value " + value);
                        }
                        if (this.interpolator.isValidGradient(vl, this.v) && (!this.classifier.doesIndex() || this.classifier.visible(value))) {
                            VJGradient g = this.interpolator.gradient(this.v, vl);
                            VJAlphaColor color = this.classifier.alphacolor(value, g);
                            if (this.onTrace(i, j)) {
                                this.trace(this.classifier.trace(value, g) + " pixel: " + pixel.toString() + " color: " + color.toString());
                            }
                            if (color.visible()) {
                                g.normalize();
                                VJShade shade = this.shader.shade(g);
                                this.blendCompose(pixel, value, g, color, shade);
                                if (pixel.almostOpaque()) {
                                    pixel.setOpaque();
                                }
                                if (this.cutout instanceof VJCutout) {
                                    this.cutout.cutout(pixel, i + this.ioffset, j + this.joffset, k + this.koffset);
                                }
                                if (this.onTrace(i, j)) {
                                    this.trace(" " + shade.toString() + " pixel: " + pixel.toString() + "\n");
                                }
                            }
                            involume = true;
                        }
                    } else if (involume) {
                        if (!this.onTrace(i, j)) break;
                        this.trace("break?");
                        this.traceWrite();
                        break;
                    }
                    if (this.onTrace(i, j)) {
                        this.traceWrite();
                    }
                    vl.move(osstep);
                }
                this.setPixel(pixel, i, j);
            }
            VJRender.yield();
        }
        VJUserInterface.progress(1.0f);
        this.pixelms = (float)(System.currentTimeMillis() - start) / (float)(this.width * this.height);
        this.running = false;
    }

    protected void blendCompose(VJAlphaColor pixel, VJValue value, VJGradient g, VJAlphaColor color, VJShade shade) {
        pixel.blendComposeScalar(color, shade);
    }

    public static String desc() {
        return "Raytrace";
    }
}

