/*
 * Decompiled with CFR 0.152.
 */
package VolumeJ;

import VolumeJ.VJRenderViewCine;
import VolumeJ.VJRenderer;
import VolumeJ.VJUserInterface;
import volume.Gaussian;
import volume.Volume;
import volume.VolumeShort;

public class VJSurfacePlotShell
extends VJRenderViewCine {
    private int k;
    private Volume vimages;
    private float min;
    private float max;
    private float aspectz;
    private float sigma;

    public VJSurfacePlotShell(VJRenderer renderer, float scale, float xrot, float yrot, float zrot, Volume vimages, float min, float max, float aspectz, float sigma, String message) {
        super(renderer, scale, xrot, yrot, zrot, message, 0, false);
        this.vimages = vimages;
        this.n = vimages.getDepth();
        this.k = 0;
        this.max = max;
        this.min = min;
        this.aspectz = aspectz;
        this.sigma = sigma;
        VolumeShort v = VJSurfacePlotShell.imagesVolumeToSurfaceVolume((VolumeShort)vimages, 0, max, min, aspectz, sigma);
        renderer.setVolume(v);
    }

    @Override
    protected void nextView(int k) {
        if (k + 1 < this.n) {
            VolumeShort v = VJSurfacePlotShell.imagesVolumeToSurfaceVolume((VolumeShort)this.vimages, k + 1, this.max, this.min, this.aspectz, this.sigma);
            this.renderer.setVolume(v);
            this.renderer.setMessage("" + (k + 1) + "/" + this.n);
        }
    }

    protected static VolumeShort imagesVolumeToSurfaceVolume(VolumeShort vimages, int k, float max, float min, float aspectz, float sigma) {
        int z;
        int range = (int)(max - min);
        VolumeShort v = new VolumeShort(vimages.getWidth(), vimages.getHeight(), range + 2, 1.0, 1.0, (double)aspectz);
        v.setIndexed(true);
        for (z = 0; z < v.getDepth(); ++z) {
            int zinv = v.getDepth() - z - 1;
            float threshold = (float)zinv + min;
            for (int y = 0; y < v.getHeight(); ++y) {
                for (int x = 0; x < v.getWidth(); ++x) {
                    float intensity = vimages.v[k][y][x];
                    v.v[z][y][x] = intensity > threshold ? 255 : 0;
                }
            }
        }
        if ((double)sigma > 0.0) {
            VJUserInterface.status("Smoothing (" + sigma + ")...");
            v.convolvexyz(new Gaussian(sigma));
        }
        for (z = 0; z < v.getDepth(); ++z) {
            VJSurfacePlotShell.setSliceIndex(v, z, v.getDepth() - z - 1);
        }
        return v;
    }

    private static void setSliceIndex(VolumeShort v, int z, int index) {
        index = Math.min(index, 255);
        for (int y = 0; y < v.getHeight(); ++y) {
            for (int x = 0; x < v.getWidth(); ++x) {
                v.v[z][y][x] = (short)(index << 8 & 0xFF00 | v.v[z][y][x] & 0xFF);
            }
        }
    }
}

