/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.algorithm.blocks;

import net.imglib2.Interval;
import net.imglib2.algorithm.blocks.BlockProcessor;
import net.imglib2.blocks.BlockInterval;
import net.imglib2.blocks.TempArray;
import net.imglib2.type.PrimitiveType;
import net.imglib2.util.Intervals;
import net.imglib2.util.Util;

public abstract class AbstractDimensionlessBlockProcessor<I, O>
implements BlockProcessor<I, O> {
    private final TempArray<I> tempArray;
    protected BlockInterval sourceInterval;

    protected AbstractDimensionlessBlockProcessor(PrimitiveType sourcePrimitiveType) {
        this.tempArray = TempArray.forPrimitiveType(sourcePrimitiveType);
    }

    protected AbstractDimensionlessBlockProcessor(AbstractDimensionlessBlockProcessor<I, O> proc) {
        this.tempArray = proc.tempArray.newInstance();
    }

    @Override
    public void setTargetInterval(Interval interval) {
        this.updateNumSourceDimensions(interval.numDimensions());
        this.sourceInterval.setFrom(interval);
    }

    protected boolean updateNumSourceDimensions(int n) {
        if (this.sourceInterval == null || this.sourceInterval.numDimensions() != n) {
            this.sourceInterval = new BlockInterval(n);
            return true;
        }
        return false;
    }

    protected int sourceLength() {
        return Util.safeInt(Intervals.numElements(this.sourceInterval));
    }

    @Override
    public BlockInterval getSourceInterval() {
        return this.sourceInterval;
    }

    @Override
    public I getSourceBuffer() {
        return this.tempArray.get(this.sourceLength());
    }
}

