/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.algorithm.convolution.kernel;

import net.imglib2.RandomAccess;
import net.imglib2.algorithm.convolution.kernel.Kernel1D;
import net.imglib2.img.NativeImg;
import net.imglib2.img.array.ArrayImg;
import net.imglib2.img.array.ArrayImgFactory;
import net.imglib2.img.array.ArrayRandomAccess;
import net.imglib2.type.NativeType;
import net.imglib2.type.numeric.NumericType;

public final class ConvolverNativeType<T extends NumericType<T> & NativeType<T>>
implements Runnable {
    private final double[] kernel;
    private final RandomAccess<? extends T> in;
    private final RandomAccess<? extends T> out;
    private final int d;
    private final int k1k;
    private final int k1k1;
    private final long linelen;
    private final T b1;
    private final T b2;

    public ConvolverNativeType(Kernel1D kernel, RandomAccess<? extends T> in, RandomAccess<? extends T> out, int d, long lineLength) {
        this.in = in;
        this.out = out;
        this.d = d;
        this.kernel = (double[])kernel.fullKernel().clone();
        this.k1k = this.kernel.length;
        this.k1k1 = this.k1k - 1;
        this.linelen = lineLength;
        NumericType type = (NumericType)out.get();
        NativeImg buf = new ArrayImgFactory<NativeType>((NativeType)((Object)type)).create(new long[]{this.k1k + 1});
        this.b1 = (NumericType)((ArrayRandomAccess)((ArrayImg)buf).randomAccess()).get();
        this.b2 = (NumericType)((ArrayRandomAccess)((ArrayImg)buf).randomAccess()).get();
        ((NativeType)this.b1).updateIndex(this.k1k);
        this.b1.setZero();
    }

    private void prefill() {
        NumericType w = (NumericType)this.in.get();
        this.process(w);
        this.in.fwd(this.d);
    }

    private void next() {
        NumericType w = (NumericType)this.in.get();
        this.process(w);
        this.in.fwd(this.d);
        ((NativeType)this.b1).updateIndex(0);
        ((NumericType)this.out.get()).set(this.b1);
        this.out.fwd(this.d);
    }

    private void process(T w) {
        for (int i = 0; i < this.k1k; ++i) {
            ((NativeType)this.b1).updateIndex(i);
            ((NativeType)this.b2).updateIndex(i + 1);
            this.b1.set(w);
            this.b1.mul(this.kernel[i]);
            this.b1.add(this.b2);
        }
    }

    @Override
    public void run() {
        for (int i = 0; i < this.k1k1; ++i) {
            this.prefill();
        }
        for (long i = 0L; i < this.linelen; ++i) {
            this.next();
        }
    }
}

