/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.algorithm.math.execution;

import java.util.Arrays;
import java.util.List;
import net.imglib2.Localizable;
import net.imglib2.algorithm.math.abstractions.OFunction;
import net.imglib2.type.numeric.RealType;

public class Logarithm<O extends RealType<O>>
implements OFunction<O> {
    private final OFunction<O> a;
    private final O scrap;

    public Logarithm(O scrap, OFunction<O> a) {
        this.scrap = scrap;
        this.a = a;
    }

    @Override
    public final O eval() {
        this.scrap.setReal(Math.log(this.a.eval().getRealDouble()));
        return this.scrap;
    }

    @Override
    public final O eval(Localizable loc) {
        this.scrap.setReal(Math.log(this.a.eval(loc).getRealDouble()));
        return this.scrap;
    }

    @Override
    public List<OFunction<O>> children() {
        return Arrays.asList(this.a);
    }

    @Override
    public final double evalDouble() {
        return Math.log(this.a.evalDouble());
    }

    @Override
    public final double evalDouble(Localizable loc) {
        return Math.log(this.a.evalDouble(loc));
    }
}

