/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.algorithm.math.execution;

import net.imglib2.Localizable;
import net.imglib2.algorithm.math.abstractions.IBooleanFunction;
import net.imglib2.algorithm.math.abstractions.OFunction;
import net.imglib2.algorithm.math.execution.LogicalAnd;
import net.imglib2.type.numeric.RealType;

public class LogicalOrBoolean<O extends RealType<O>>
extends LogicalAnd<O> {
    private final IBooleanFunction abool;
    private final IBooleanFunction bbool;

    public LogicalOrBoolean(O scrap, OFunction<O> a, OFunction<O> b) {
        super(scrap, a, b);
        this.abool = (IBooleanFunction)((Object)a);
        this.bbool = (IBooleanFunction)((Object)b);
    }

    @Override
    public final boolean evalBoolean() {
        boolean first = this.abool.evalBoolean();
        boolean second = this.bbool.evalBoolean();
        return first || second;
    }

    @Override
    public final boolean evalBoolean(Localizable loc) {
        boolean first = this.abool.evalBoolean(loc);
        boolean second = this.bbool.evalBoolean(loc);
        return first || second;
    }
}

