/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.app.action.edit;

import edu.umd.cs.findbugs.annotations.Nullable;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractAction;
import javax.swing.JComponent;
import org.jhotdraw.beans.WeakPropertyChangeListener;
import org.jhotdraw.gui.EditableComponent;

public abstract class AbstractSelectionAction
extends AbstractAction {
    @Nullable
    protected JComponent target;
    private PropertyChangeListener propertyHandler;

    public AbstractSelectionAction(@Nullable JComponent target) {
        this.target = target;
        if (target != null) {
            this.propertyHandler = new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    String n = evt.getPropertyName();
                    if (n.equals("enabled")) {
                        AbstractSelectionAction.this.updateEnabled();
                    } else if (n.equals("selectionEmpty")) {
                        AbstractSelectionAction.this.updateEnabled();
                    }
                }
            };
            target.addPropertyChangeListener(new WeakPropertyChangeListener(this.propertyHandler));
        }
    }

    protected void updateEnabled() {
        if (this.target instanceof EditableComponent) {
            this.setEnabled(this.target.isEnabled() && !((EditableComponent)((Object)this.target)).isSelectionEmpty());
        } else if (this.target != null) {
            this.setEnabled(this.target.isEnabled());
        }
    }
}

