/*
 * Decompiled with CFR 0.152.
 */
package bunwarpj;

import bunwarpj.MainDialog;
import bunwarpj.MiscTools;
import bunwarpj.PointHandler;
import ij.IJ;
import ij.ImagePlus;
import ij.io.OpenDialog;
import ij.io.SaveDialog;
import ij.plugin.frame.Recorder;
import java.awt.Button;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Stack;
import java.util.Vector;
import javax.swing.JOptionPane;

public class IODialog
extends Dialog
implements ActionListener {
    public static final String EVALUATE_SIMILARITY = "evaluateImageSimilarity";
    public static final String LOAD_LANDMARKS = "loadLandmarks";
    public static final String SAVE_LANDMARKS = "saveLandmarks";
    public static final String SHOW_LANDMARKS = "showLandmarks";
    public static final String LOAD_ELASTIC_TRANSF = "loadElasticTransform";
    public static final String LOAD_RAW_TRANSF = "loadRawTransform";
    public static final String COMPARE_OPPOSITE_ELASTIC = "compareOppositeElasticTransforms";
    public static final String COMPARE_ELASTIC_RAW = "compareElasticRawTransforms";
    public static final String COMPARE_RAW = "compareRawTransforms";
    public static final String CONVERT_TO_RAW = "convertToRaw";
    public static final String CONVERT_TO_ELASTIC = "convertToElastic";
    public static final String COMPOSE_ELASTIC = "composeElasticTransforms";
    public static final String COMPOSE_RAW = "composeRawTransforms";
    public static final String COMPOSE_RAW_ELASTIC = "composeRawElasticTransforms";
    public static final String INVERT_RAW = "invertRawTransform";
    public static final String ADAPT_COEFFICIENTS = "adaptCoefficients";
    public static final String LOAD_SOURCE_MASK = "loadSourceMask";
    public static final String LOAD_SOURCE_AFFINE = "loadSourceAffineMatrix";
    private static final long serialVersionUID = 2016840469406208859L;
    private ImagePlus sourceImp;
    private ImagePlus targetImp;
    private PointHandler sourcePh;
    private PointHandler targetPh;
    private MainDialog dialog;

    public IODialog(Frame parentWindow, ImagePlus sourceImp, ImagePlus targetImp, PointHandler sourcePh, PointHandler targetPh, MainDialog dialog) {
        super(parentWindow, "I/O Menu", true);
        this.sourceImp = sourceImp;
        this.targetImp = targetImp;
        this.sourcePh = sourcePh;
        this.targetPh = targetPh;
        this.dialog = dialog;
        this.setLayout(new GridLayout(0, 1));
        Button saveAsButton = new Button("Save Landmarks As...");
        Button loadButton = new Button("Load Landmarks...");
        Button show_PointsButton = new Button("Show Landmarks");
        Button loadTransfButton = new Button("Load Elastic Transformation");
        Button loadRawTransfButton = new Button("Load Raw Transformation");
        Button compareOppositeTransfButton = new Button("Compare Opposite Elastic Transformations");
        Button compareElasticRawTransfButton = new Button("Compare Elastic/Raw Transformations");
        Button compareRawButton = new Button("Compare Raw Transformations");
        Button convertToRawButton = new Button("Convert Transformation To Raw");
        Button convertToElasticButton = new Button("Convert Transformation To Elastic");
        Button composeElasticButton = new Button("Compose Elastic Transformations");
        Button composeRawButton = new Button("Compose Raw Transformations");
        Button composeRawElasticButton = new Button("Compose Raw and Elastic Transformations");
        Button invertRawButton = new Button("Invert Raw Transformation");
        Button evaluateSimilarityButton = new Button("Evaluate Image Similarity");
        Button adaptCoeffsButton = new Button("Adapt Coefficients");
        Button loadSourceMaskButton = new Button("Load Source Mask");
        Button loadSourceInitialAffineMatrixButton = new Button("Load Source Initial Affine Matrix");
        Button cancelButton = new Button("Cancel");
        saveAsButton.addActionListener(this);
        loadButton.addActionListener(this);
        show_PointsButton.addActionListener(this);
        loadTransfButton.addActionListener(this);
        loadRawTransfButton.addActionListener(this);
        cancelButton.addActionListener(this);
        compareOppositeTransfButton.addActionListener(this);
        compareElasticRawTransfButton.addActionListener(this);
        compareRawButton.addActionListener(this);
        convertToRawButton.addActionListener(this);
        convertToElasticButton.addActionListener(this);
        composeElasticButton.addActionListener(this);
        composeRawButton.addActionListener(this);
        composeRawElasticButton.addActionListener(this);
        invertRawButton.addActionListener(this);
        evaluateSimilarityButton.addActionListener(this);
        adaptCoeffsButton.addActionListener(this);
        loadSourceMaskButton.addActionListener(this);
        loadSourceInitialAffineMatrixButton.addActionListener(this);
        Label separation1 = new Label("");
        Label separation2 = new Label("");
        this.add(separation1);
        this.add(loadButton);
        this.add(saveAsButton);
        this.add(show_PointsButton);
        this.add(loadTransfButton);
        this.add(loadRawTransfButton);
        this.add(compareOppositeTransfButton);
        this.add(compareElasticRawTransfButton);
        this.add(compareRawButton);
        this.add(convertToRawButton);
        this.add(convertToElasticButton);
        this.add(composeElasticButton);
        this.add(composeRawButton);
        this.add(composeRawElasticButton);
        this.add(invertRawButton);
        this.add(evaluateSimilarityButton);
        this.add(adaptCoeffsButton);
        this.add(loadSourceMaskButton);
        this.add(loadSourceInitialAffineMatrixButton);
        this.add(separation2);
        this.add(cancelButton);
        this.pack();
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        this.setVisible(false);
        if (ae.getActionCommand().equals("Save Landmarks As...")) {
            this.savePoints();
        } else if (ae.getActionCommand().equals("Load Landmarks...")) {
            this.loadPoints();
        } else if (ae.getActionCommand().equals("Show Landmarks")) {
            this.showPoints();
        } else if (ae.getActionCommand().equals("Load Elastic Transformation")) {
            this.loadTransformation();
        } else if (ae.getActionCommand().equals("Load Raw Transformation")) {
            this.loadRawTransformation();
        } else if (ae.getActionCommand().equals("Compare Opposite Elastic Transformations")) {
            this.compareOppositeElasticTransformations();
        } else if (ae.getActionCommand().equals("Compare Elastic/Raw Transformations")) {
            this.compareElasticWithRaw();
        } else if (ae.getActionCommand().equals("Compare Raw Transformations")) {
            this.compareRawTransformations();
        } else if (ae.getActionCommand().equals("Convert Transformation To Raw")) {
            this.saveTransformationInRaw();
        } else if (ae.getActionCommand().equals("Convert Transformation To Elastic")) {
            this.saveTransformationInElastic();
        } else if (ae.getActionCommand().equals("Compose Elastic Transformations")) {
            this.composeElasticTransformations();
        } else if (ae.getActionCommand().equals("Compose Raw Transformations")) {
            this.composeRawTransformations();
        } else if (ae.getActionCommand().equals("Compose Raw and Elastic Transformations")) {
            this.composeRawElasticTransformations();
        } else if (ae.getActionCommand().equals("Invert Raw Transformation")) {
            this.invertRawTransformation();
        } else if (ae.getActionCommand().equals("Evaluate Image Similarity")) {
            this.evaluateSimilarity();
        } else if (ae.getActionCommand().equals("Adapt Coefficients")) {
            this.adaptCoefficients();
        } else if (ae.getActionCommand().equals("Load Source Mask")) {
            this.loadSourceMask();
        } else if (ae.getActionCommand().equals("Load Source Initial Affine Matrix")) {
            this.loadSourceInitialAffineMatrix();
        } else if (ae.getActionCommand().equals("Cancel")) {
            // empty if block
        }
    }

    @Override
    public Insets getInsets() {
        return new Insets(0, 20, 20, 20);
    }

    private void loadPoints() {
        OpenDialog od = new OpenDialog("Load Points", "");
        String path = od.getDirectory();
        String filename = od.getFileName();
        if (path == null || filename == null) {
            return;
        }
        Stack<Point> sourceStack = new Stack<Point>();
        Stack<Point> targetStack = new Stack<Point>();
        MiscTools.loadPoints(path + filename, sourceStack, targetStack);
        this.sourcePh.removePoints();
        this.targetPh.removePoints();
        while (!sourceStack.empty() && !targetStack.empty()) {
            Point sourcePoint = sourceStack.pop();
            Point targetPoint = targetStack.pop();
            this.sourcePh.addPoint(sourcePoint.x, sourcePoint.y);
            this.targetPh.addPoint(targetPoint.x, targetPoint.y);
        }
        IODialog.record(LOAD_LANDMARKS, path + filename);
    }

    private void loadTransformation() {
        String fn_tnf = MiscTools.getUserSelectedFilePath("Load Elastic Transformation", false);
        if (null == fn_tnf) {
            return;
        }
        int intervals = MiscTools.numberOfIntervalsOfTransformation(fn_tnf);
        double[][] cx = new double[intervals + 3][intervals + 3];
        double[][] cy = new double[intervals + 3][intervals + 3];
        MiscTools.loadTransformation(fn_tnf, cx, cy);
        this.dialog.applyTransformationToSource(intervals, cx, cy);
        IODialog.record(LOAD_ELASTIC_TRANSF, fn_tnf, this.targetImp.getTitle(), this.sourceImp.getTitle());
    }

    private void loadSourceMask() {
        OpenDialog od = new OpenDialog("Load Source Mask", "");
        String path = od.getDirectory();
        String filename = od.getFileName();
        if (path == null || filename == null) {
            return;
        }
        String fnSourceMask = path + filename;
        this.dialog.setSourceMask(fnSourceMask);
        this.dialog.grayImage(this.sourcePh);
        IODialog.record(LOAD_SOURCE_MASK, fnSourceMask);
    }

    private void loadSourceInitialAffineMatrix() {
        OpenDialog od = new OpenDialog("Load Source Initial Affine Matrix", "");
        String path = od.getDirectory();
        String filename = od.getFileName();
        if (path == null || filename == null) {
            return;
        }
        double[][] affineMatrix = new double[2][3];
        MiscTools.loadAffineMatrix(path + filename, affineMatrix);
        this.dialog.setSourceAffineMatrix(affineMatrix);
        IODialog.record(LOAD_SOURCE_AFFINE, path + filename);
    }

    private void loadRawTransformation() {
        String fn_tnf = MiscTools.getUserSelectedFilePath("Load Raw Transformation", false);
        if (fn_tnf == null) {
            return;
        }
        double[][] transformation_x = new double[this.targetImp.getHeight()][this.targetImp.getWidth()];
        double[][] transformation_y = new double[this.targetImp.getHeight()][this.targetImp.getWidth()];
        MiscTools.loadRawTransformation(fn_tnf, transformation_x, transformation_y);
        this.dialog.applyRawTransformationToSource(transformation_x, transformation_y);
        IODialog.record(LOAD_RAW_TRANSF, fn_tnf, this.targetImp.getTitle(), this.sourceImp.getTitle());
    }

    private void adaptCoefficients() {
        String fn_tnf = MiscTools.getUserSelectedFilePath("Adapt Coefficients - Select input elastic transformation file", false);
        if (fn_tnf == null) {
            return;
        }
        String sInput = JOptionPane.showInputDialog(null, "Image Factor?", "Adapt Coefficients", 3);
        double dImageSizeFactor = Double.parseDouble(sInput);
        String sNewFileName = MiscTools.getUserSelectedFilePath("Adapt Coefficients - Select output elastic transformation file", true);
        if (sNewFileName == null) {
            return;
        }
        MiscTools.adaptCoefficients(fn_tnf, dImageSizeFactor, sNewFileName);
        IODialog.record(ADAPT_COEFFICIENTS, fn_tnf, sInput, sNewFileName);
    }

    private void saveTransformationInRaw() {
        String fn_tnf = MiscTools.getUserSelectedFilePath("Load elastic transformation file", false);
        if (null == fn_tnf) {
            return;
        }
        String fn_tnf_raw = MiscTools.getUserSelectedFilePath("Saving in raw - select raw transformation file", true);
        if (null == fn_tnf_raw) {
            return;
        }
        MiscTools.saveElasticAsRaw(fn_tnf, fn_tnf_raw, this.targetImp);
        IODialog.record(CONVERT_TO_RAW, fn_tnf, fn_tnf_raw, this.targetImp.getTitle());
    }

    private void saveTransformationInElastic() {
        String fn_tnf = MiscTools.getUserSelectedFilePath("Load raw transformation file", false);
        if (null == fn_tnf) {
            return;
        }
        String fn_tnf_elastic = MiscTools.getUserSelectedFilePath("Saving in elastic - select elastic transformation file", true);
        if (null == fn_tnf_elastic) {
            return;
        }
        String sInput = JOptionPane.showInputDialog(null, "Number of intervals for B-spline grid?", "Save as B-spline coefficients", 3);
        int intervals = Integer.parseInt(sInput);
        MiscTools.saveRawAsElastic(fn_tnf, fn_tnf_elastic, intervals, this.targetImp);
        IODialog.record(CONVERT_TO_ELASTIC, fn_tnf, fn_tnf_elastic, String.valueOf(intervals), this.targetImp.getTitle());
    }

    private void invertRawTransformation() {
        String fn_tnf = MiscTools.getUserSelectedFilePath("Load raw transformation file", false);
        if (null == fn_tnf) {
            return;
        }
        String fn_tnf_inverse = MiscTools.getUserSelectedFilePath("Saving in raw - select raw transformation file", true);
        if (null == fn_tnf_inverse) {
            return;
        }
        MiscTools.invertRawTransformation(fn_tnf, fn_tnf_inverse, this.targetImp);
        IODialog.record(INVERT_RAW, fn_tnf, fn_tnf_inverse, this.targetImp.getTitle());
    }

    private void compareOppositeElasticTransformations() {
        OpenDialog od = new OpenDialog("Comparing - Load Direct Elastic Transformation", "");
        String path = od.getDirectory();
        String filename = od.getFileName();
        if (path == null || filename == null) {
            return;
        }
        String directTransfFilename = path + filename;
        int intervals = MiscTools.numberOfIntervalsOfTransformation(directTransfFilename);
        double[][] cx_direct = new double[intervals + 3][intervals + 3];
        double[][] cy_direct = new double[intervals + 3][intervals + 3];
        MiscTools.loadTransformation(directTransfFilename, cx_direct, cy_direct);
        od = new OpenDialog("Comparing - Load Inverse Elastic Transformation", "");
        path = od.getDirectory();
        filename = od.getFileName();
        if (path == null || filename == null) {
            return;
        }
        String inverseTransfFilename = path + filename;
        intervals = MiscTools.numberOfIntervalsOfTransformation(inverseTransfFilename);
        double[][] cx_inverse = new double[intervals + 3][intervals + 3];
        double[][] cy_inverse = new double[intervals + 3][intervals + 3];
        MiscTools.loadTransformation(inverseTransfFilename, cx_inverse, cy_inverse);
        double warpingIndex = MiscTools.warpingIndex(this.sourceImp, this.targetImp, intervals, cx_direct, cy_direct, cx_inverse, cy_inverse);
        if (warpingIndex != -1.0) {
            IJ.log((String)(" Warping index = " + warpingIndex));
        } else {
            IJ.log((String)" Warping index could not be evaluated because not a single pixel matched after the deformation!");
        }
        IODialog.record(COMPARE_OPPOSITE_ELASTIC, directTransfFilename, inverseTransfFilename, this.targetImp.getTitle(), this.sourceImp.getTitle());
    }

    private void composeElasticTransformations() {
        String elasticTransfPath1 = MiscTools.getUserSelectedFilePath("Composing - Load First Elastic Transformation", false);
        if (null == elasticTransfPath1) {
            return;
        }
        String elasticTransfPath2 = MiscTools.getUserSelectedFilePath("Composing - Load Second Elastic Transformation", false);
        if (null == elasticTransfPath2) {
            return;
        }
        String fn_tnf_raw = MiscTools.getUserSelectedFilePath("Composing - Save Raw Transformation", true);
        if (null == fn_tnf_raw) {
            return;
        }
        MiscTools.composeElasticTransforms(elasticTransfPath1, elasticTransfPath2, fn_tnf_raw, this.targetImp);
        IODialog.record(COMPOSE_ELASTIC, elasticTransfPath1, elasticTransfPath2, fn_tnf_raw, this.targetImp.getTitle());
    }

    private void composeRawElasticTransformations() {
        String rawTransfPath = MiscTools.getUserSelectedFilePath("Composing - Load First (Raw) Transformation", false);
        if (null == rawTransfPath) {
            return;
        }
        String elasticTransfPath = MiscTools.getUserSelectedFilePath("Composing - Load Second (Elastic) Transformation", false);
        if (null == elasticTransfPath) {
            return;
        }
        String outputPath = MiscTools.getUserSelectedFilePath("Composing - Save Raw Transformation", true);
        if (null == outputPath) {
            return;
        }
        MiscTools.composeRawElasticTransforms(rawTransfPath, elasticTransfPath, outputPath, this.targetImp, this.sourceImp);
        IODialog.record(COMPOSE_RAW_ELASTIC, rawTransfPath, elasticTransfPath, outputPath, this.targetImp.getTitle(), this.sourceImp.getTitle());
    }

    private void composeRawTransformations() {
        String fn_tnf_raw = MiscTools.getUserSelectedFilePath("Composing - Load First Raw Transformation", false);
        if (null == fn_tnf_raw) {
            return;
        }
        String fn_tnf_raw_2 = MiscTools.getUserSelectedFilePath("Composing - Load Second Raw Transformation", false);
        if (null == fn_tnf_raw_2) {
            return;
        }
        String fn_tnf_raw_out = MiscTools.getUserSelectedFilePath("Composing - Save Raw Transformation", true);
        if (null == fn_tnf_raw_out) {
            return;
        }
        MiscTools.composeRawTransforms(fn_tnf_raw, fn_tnf_raw_2, fn_tnf_raw_out, this.targetImp);
        IODialog.record(COMPOSE_RAW, fn_tnf_raw, fn_tnf_raw_2, fn_tnf_raw_out, this.targetImp.getTitle());
    }

    private void compareElasticWithRaw() {
        String fn_tnf = MiscTools.getUserSelectedFilePath("Comparing - Load Elastic Transformation", false);
        if (null == fn_tnf) {
            return;
        }
        String fn_tnf_raw = MiscTools.getUserSelectedFilePath("Comparing - Load Raw Transformation", false);
        double warpingIndex = MiscTools.elasticRawWarpingIndex(fn_tnf, fn_tnf_raw, this.targetImp, this.sourceImp);
        if (warpingIndex != -1.0) {
            IJ.log((String)(" Warping index = " + warpingIndex));
        } else {
            IJ.log((String)" Warping index could not be evaluated because not a single pixel matched after the deformation!");
        }
        IODialog.record(COMPARE_ELASTIC_RAW, fn_tnf, fn_tnf_raw, this.targetImp.getTitle(), this.sourceImp.getTitle());
    }

    private void compareRawTransformations() {
        String fn_tnf_raw = MiscTools.getUserSelectedFilePath("Comparing - Load First Raw Transformation", false);
        if (null == fn_tnf_raw) {
            return;
        }
        String fn_tnf_raw_2 = MiscTools.getUserSelectedFilePath("Comparing - Load Second Raw Transformation", false);
        if (null == fn_tnf_raw_2) {
            return;
        }
        double warpingIndex = MiscTools.rawWarpingIndex(fn_tnf_raw, fn_tnf_raw_2, this.targetImp, this.sourceImp);
        if (warpingIndex != -1.0) {
            IJ.log((String)(" Warping index = " + warpingIndex));
        } else {
            IJ.log((String)" Warping index could not be evaluated because not a single pixel matched after the deformation!");
        }
        IODialog.record(COMPARE_RAW, fn_tnf_raw, fn_tnf_raw_2, this.targetImp.getTitle(), this.sourceImp.getTitle());
    }

    private void evaluateSimilarity() {
        if (MiscTools.imageSimilarity(this.targetImp, this.sourceImp, this.dialog.getTargetMask(), true) != -1.0) {
            IODialog.record(EVALUATE_SIMILARITY, this.targetImp.getTitle(), this.sourceImp.getTitle());
        }
    }

    private void savePoints() {
        String filename = this.targetImp.getTitle();
        SaveDialog sd = new SaveDialog("Save Points", filename, ".txt");
        String path = sd.getDirectory();
        filename = sd.getFileName();
        MiscTools.saveLandmarks(path + filename, this.sourcePh.getPoints(), this.targetPh.getPoints());
        IODialog.record(SAVE_LANDMARKS, path + filename);
    }

    private void showPoints() {
        Vector<Point> sourceList = this.sourcePh.getPoints();
        Vector<Point> targetList = this.targetPh.getPoints();
        MiscTools.showPoints(sourceList, targetList);
        IODialog.record(SHOW_LANDMARKS, new String[0]);
    }

    public static void record(String command, String ... args) {
        command = "call(\"bunwarpj.bUnwarpJ_." + command;
        for (int i = 0; i < args.length; ++i) {
            command = command + "\", \"" + args[i];
        }
        command = command + "\");\n";
        if (IJ.isWindows()) {
            command = command.replaceAll("\\\\", "\\\\\\\\");
        }
        if (Recorder.record) {
            Recorder.recordString((String)command);
        }
    }
}

