/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.time;

import com.google.re2j.Matcher;
import com.google.re2j.Pattern;
import java.util.Date;
import java.util.StringTokenizer;
import javax.annotation.concurrent.ThreadSafe;
import org.joda.time.Chronology;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import ucar.nc2.time.Calendar;
import ucar.nc2.time.CalendarDate;
import ucar.nc2.time.CalendarPeriod;
import ucar.nc2.time.CalendarTimeZone;
import ucar.nc2.units.DateFormatter;

@ThreadSafe
public class CalendarDateFormatter {
    private static DateTimeFormatter isof = DateTimeFormat.forPattern((String)"yyyy-MM-dd'T'HH:mm:ss'Z'").withZoneUTC();
    private static DateTimeFormatter isof_with_millis_of_second = DateTimeFormat.forPattern((String)"yyyy-MM-dd'T'HH:mm:ss.SSS'Z'").withZoneUTC();
    private static DateTimeFormatter dtf = DateTimeFormat.forPattern((String)"yyyy-MM-dd HH:mm:ss'Z'").withZoneUTC();
    private static DateTimeFormatter dtf_with_millis_of_second = DateTimeFormat.forPattern((String)"yyyy-MM-dd HH:mm:ss.SSS'Z'").withZoneUTC();
    private static DateTimeFormatter df = DateTimeFormat.forPattern((String)"yyyy-MM-dd").withZoneUTC();
    private static DateTimeFormatter df_units = DateTimeFormat.forPattern((String)"yyyy-MM-dd HH:mm:ss.SSS 'UTC'").withZoneUTC();
    public static final String isodatePatternString = "([\\+\\-?\\d]+)([ t]([\\.\\:?\\d]*)([ \\+\\-]\\S*)?z?)?$";
    private static final Pattern isodatePattern = Pattern.compile((String)"([\\+\\-?\\d]+)([ t]([\\.\\:?\\d]*)([ \\+\\-]\\S*)?z?)?$");
    private final DateTimeFormatter dflocal;

    public static String toDateTimeStringISO(CalendarDate cd) {
        if (cd.getDateTime().getMillisOfSecond() == 0) {
            return isof.print((ReadableInstant)cd.getDateTime());
        }
        return isof_with_millis_of_second.print((ReadableInstant)cd.getDateTime());
    }

    public static String toDateTimeStringISO(Date d) {
        return CalendarDateFormatter.toDateTimeStringISO(CalendarDate.of(d));
    }

    public static String toDateTimeStringISO(long millisecs) {
        return CalendarDateFormatter.toDateTimeStringISO(CalendarDate.of(millisecs));
    }

    public static String toDateTimeString(CalendarDate cd) {
        if (cd.getDateTime().getMillisOfSecond() == 0) {
            return dtf.print((ReadableInstant)cd.getDateTime());
        }
        return dtf_with_millis_of_second.print((ReadableInstant)cd.getDateTime());
    }

    public static String toDateString(Date date) {
        return CalendarDateFormatter.toDateString(CalendarDate.of(date));
    }

    public static String toDateTimeString(Date date) {
        return CalendarDateFormatter.toDateTimeString(CalendarDate.of(date));
    }

    public static String toDateTimeStringPresent() {
        return dtf.print((ReadableInstant)new DateTime());
    }

    public static String toDateString(CalendarDate cd) {
        return df.print((ReadableInstant)cd.getDateTime());
    }

    public static String toDateStringPresent() {
        return df.print((ReadableInstant)new DateTime());
    }

    public static String toTimeUnits(CalendarDate cd) {
        return df_units.print((ReadableInstant)cd.getDateTime());
    }

    public static String toTimeUnits(Date date) {
        return df_units.print(date.getTime());
    }

    public static CalendarDateFormatter factory(CalendarPeriod period) {
        switch (period.getField()) {
            case Year: {
                return new CalendarDateFormatter("yyyy");
            }
            case Month: {
                return new CalendarDateFormatter("yyyy-MM");
            }
            case Day: {
                return new CalendarDateFormatter("yyyy-MM-dd");
            }
            case Hour: {
                return new CalendarDateFormatter("yyyy-MM-ddTHH");
            }
        }
        return new CalendarDateFormatter("yyyy-MM-ddTHH:mm:ss");
    }

    @Deprecated
    public static Date parseISODate(String iso) {
        DateFormatter df = new DateFormatter();
        return df.getISODate(iso);
    }

    public static CalendarDate isoStringToCalendarDate(Calendar calt, String iso) throws IllegalArgumentException {
        DateTime dt = CalendarDateFormatter.parseIsoTimeString(calt, iso);
        Calendar useCal = Calendar.of(dt.getChronology());
        return new CalendarDate(useCal, dt);
    }

    public static Date isoStringToDate(String iso) throws IllegalArgumentException {
        CalendarDate dt = CalendarDateFormatter.isoStringToCalendarDate(null, iso);
        return dt.toDate();
    }

    private static DateTime parseIsoTimeString(Calendar calt, String iso) {
        iso = iso.trim();
        Matcher m = isodatePattern.matcher((CharSequence)(iso = iso.toLowerCase()));
        if (!m.matches()) {
            throw new IllegalArgumentException(iso + " does not match regexp " + isodatePatternString);
        }
        String dateString = m.group(1);
        String timeString = m.group(3);
        String zoneString = m.group(4);
        int year = 0;
        int month = 1;
        int day = 1;
        int hour = 0;
        int minute = 0;
        double second = 0.0;
        try {
            boolean isMinus = false;
            if (dateString.startsWith("-")) {
                isMinus = true;
                dateString = dateString.substring(1);
            } else if (dateString.startsWith("+")) {
                dateString = dateString.substring(1);
            }
            if (dateString.contains("-")) {
                StringTokenizer dateTokenizer = new StringTokenizer(dateString, "-");
                if (dateTokenizer.hasMoreTokens()) {
                    year = Integer.parseInt(dateTokenizer.nextToken());
                }
                if (dateTokenizer.hasMoreTokens()) {
                    month = Integer.parseInt(dateTokenizer.nextToken());
                }
                if (dateTokenizer.hasMoreTokens()) {
                    day = Integer.parseInt(dateTokenizer.nextToken());
                }
            } else {
                int dateLength = dateString.length();
                if (dateLength % 2 != 0) {
                    throw new IllegalArgumentException(dateString + " is ambiguous. Cannot parse uneven length date strings when no date delimiter is used.");
                }
                if (dateLength > 3) {
                    year = Integer.parseInt(dateString.substring(0, 4));
                }
                if (dateLength > 5) {
                    month = Integer.parseInt(dateString.substring(4, 6));
                }
                if (dateLength > 7) {
                    day = Integer.parseInt(dateString.substring(6, 8));
                }
            }
            if (timeString != null && !timeString.isEmpty()) {
                if (timeString.contains(":")) {
                    StringTokenizer timeTokenizer = new StringTokenizer(timeString, ":");
                    if (timeTokenizer.hasMoreTokens()) {
                        hour = Integer.parseInt(timeTokenizer.nextToken());
                    }
                    if (timeTokenizer.hasMoreTokens()) {
                        minute = Integer.parseInt(timeTokenizer.nextToken());
                    }
                    if (timeTokenizer.hasMoreTokens()) {
                        second = Double.parseDouble(timeTokenizer.nextToken());
                    }
                } else {
                    int timeLengthNoSubseconds = timeString.length();
                    if (timeString.contains(".")) {
                        timeLengthNoSubseconds = timeString.split("\\.")[0].length();
                    }
                    if (timeLengthNoSubseconds == 1) {
                        hour = Integer.parseInt(timeString);
                    } else {
                        if (timeLengthNoSubseconds % 2 != 0) {
                            throw new IllegalArgumentException(timeString + " is ambiguous. Cannot parse uneven length time strings (ignoring subseconds) when no time delimiter is used.");
                        }
                        if (timeString.length() > 1) {
                            hour = Integer.parseInt(timeString.substring(0, 2));
                        }
                        if (timeString.length() > 3) {
                            minute = Integer.parseInt(timeString.substring(2, 4));
                        }
                        if (timeString.length() > 5) {
                            second = Double.parseDouble(timeString.substring(4));
                        }
                    }
                }
            }
            if (isMinus) {
                year = -year;
            }
            if (year == 0 && calt == Calendar.gregorian) {
                calt = Calendar.proleptic_gregorian;
            }
            Chronology cron = Calendar.getChronology(calt);
            cron = cron.withUTC();
            DateTime dt = new DateTime(year, month, day, hour, minute, 0, 0, cron);
            dt = dt.plus((long)(1000.0 * second));
            if (!(zoneString == null || (zoneString = zoneString.trim()).isEmpty() || zoneString.equalsIgnoreCase("Z") || zoneString.equalsIgnoreCase("UTC") || zoneString.equalsIgnoreCase("GMT"))) {
                int hourOffset;
                String hourS;
                isMinus = false;
                if (zoneString.startsWith("-")) {
                    isMinus = true;
                    zoneString = zoneString.substring(1);
                } else if (zoneString.startsWith("+")) {
                    zoneString = zoneString.substring(1);
                }
                int minuteOffset = 0;
                int posColon = zoneString.indexOf(58);
                if (posColon > 0) {
                    hourS = zoneString.substring(0, posColon);
                    String minS = zoneString.substring(posColon + 1);
                    hourOffset = Integer.parseInt(hourS);
                    minuteOffset = Integer.parseInt(minS);
                } else if (zoneString.length() > 2) {
                    hourS = zoneString.substring(0, 2);
                    String minS = zoneString.substring(2);
                    hourOffset = Integer.parseInt(hourS);
                    minuteOffset = Integer.parseInt(minS);
                } else {
                    hourOffset = Integer.parseInt(zoneString);
                }
                if (isMinus) {
                    hourOffset = -hourOffset;
                }
                DateTimeZone dtz = DateTimeZone.forOffsetHoursMinutes((int)hourOffset, (int)minuteOffset);
                dt = dt.withZoneRetainFields(dtz);
                dt = dt.withZone(DateTimeZone.UTC);
            }
            return dt;
        }
        catch (Throwable e) {
            throw new IllegalArgumentException("Illegal base time specification: '" + dateString + "' " + e.getMessage());
        }
    }

    public CalendarDateFormatter(String pattern) {
        this.dflocal = DateTimeFormat.forPattern((String)pattern).withZoneUTC();
    }

    public CalendarDateFormatter(String pattern, CalendarTimeZone tz, Calendar cal) {
        Chronology chron = Calendar.getChronology(cal);
        this.dflocal = DateTimeFormat.forPattern((String)pattern).withChronology(chron).withZone(tz.getJodaTimeZone());
    }

    public CalendarDateFormatter(String pattern, CalendarTimeZone tz) {
        this.dflocal = DateTimeFormat.forPattern((String)pattern).withZone(tz.getJodaTimeZone());
    }

    public String toString(CalendarDate cd) {
        return this.dflocal.print((ReadableInstant)cd.getDateTime());
    }

    public CalendarDate parse(String timeString) {
        DateTime dt = this.dflocal.parseDateTime(timeString);
        Calendar cal = Calendar.get(dt.getChronology().toString());
        return new CalendarDate(cal, dt);
    }
}

