/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.mesh.naive;

import net.imagej.mesh.Mesh;
import org.scijava.util.DoubleArray;
import org.scijava.util.IntArray;

public class NaiveDoubleMesh
implements Mesh {
    private final Vertices vertices = new Vertices();
    private final Triangles triangles = new Triangles();

    @Override
    public Vertices vertices() {
        return this.vertices;
    }

    @Override
    public Triangles triangles() {
        return this.triangles;
    }

    public class Triangles
    implements net.imagej.mesh.Triangles {
        private final IntArray v0s = new IntArray();
        private final IntArray v1s = new IntArray();
        private final IntArray v2s = new IntArray();
        private final DoubleArray nxs = new DoubleArray();
        private final DoubleArray nys = new DoubleArray();
        private final DoubleArray nzs = new DoubleArray();

        @Override
        public Mesh mesh() {
            return NaiveDoubleMesh.this;
        }

        @Override
        public long size() {
            return this.v1s.size();
        }

        @Override
        public long vertex0(long tIndex) {
            return this.v0s.get(this.safeIndex(tIndex)).intValue();
        }

        @Override
        public long vertex1(long tIndex) {
            return this.v1s.get(this.safeIndex(tIndex)).intValue();
        }

        @Override
        public long vertex2(long tIndex) {
            return this.v2s.get(this.safeIndex(tIndex)).intValue();
        }

        @Override
        public double nx(long tIndex) {
            return this.nxs.get(this.safeIndex(tIndex));
        }

        @Override
        public double ny(long tIndex) {
            return this.nys.get(this.safeIndex(tIndex));
        }

        @Override
        public double nz(long tIndex) {
            return this.nzs.get(this.safeIndex(tIndex));
        }

        @Override
        public long add(long v0, long v1, long v2, double nx, double ny, double nz) {
            int index = this.v0s.size();
            this.v0s.add((Object)this.safeIndex(v0));
            this.v1s.add((Object)this.safeIndex(v1));
            this.v2s.add((Object)this.safeIndex(v2));
            this.nxs.add((Object)nx);
            this.nys.add((Object)ny);
            this.nzs.add((Object)nz);
            return index;
        }

        private int safeIndex(long index) {
            if (index > Integer.MAX_VALUE) {
                throw new IndexOutOfBoundsException("Index too large: " + index);
            }
            return (int)index;
        }

        @Override
        public float nxf(long tIndex) {
            return (float)this.nx(tIndex);
        }

        @Override
        public float nyf(long tIndex) {
            return (float)this.ny(tIndex);
        }

        @Override
        public float nzf(long tIndex) {
            return (float)this.nz(tIndex);
        }

        @Override
        public long addf(long v0, long v1, long v2, float nx, float ny, float nz) {
            return this.add(v0, v1, v2, nx, ny, nz);
        }
    }

    public class Vertices
    implements net.imagej.mesh.Vertices {
        private final DoubleArray xs = new DoubleArray();
        private final DoubleArray ys = new DoubleArray();
        private final DoubleArray zs = new DoubleArray();
        private final DoubleArray nxs = new DoubleArray();
        private final DoubleArray nys = new DoubleArray();
        private final DoubleArray nzs = new DoubleArray();
        private final DoubleArray us = new DoubleArray();
        private final DoubleArray vs = new DoubleArray();

        @Override
        public Mesh mesh() {
            return NaiveDoubleMesh.this;
        }

        @Override
        public long size() {
            return this.xs.size();
        }

        @Override
        public double x(long vIndex) {
            return this.xs.get(this.safeIndex(vIndex));
        }

        @Override
        public double y(long vIndex) {
            return this.ys.get(this.safeIndex(vIndex));
        }

        @Override
        public double z(long vIndex) {
            return this.zs.get(this.safeIndex(vIndex));
        }

        @Override
        public double nx(long vIndex) {
            return this.nxs.get(this.safeIndex(vIndex));
        }

        @Override
        public double ny(long vIndex) {
            return this.nys.get(this.safeIndex(vIndex));
        }

        @Override
        public double nz(long vIndex) {
            return this.nzs.get(this.safeIndex(vIndex));
        }

        @Override
        public double u(long vIndex) {
            return this.us.get(this.safeIndex(vIndex));
        }

        @Override
        public double v(long vIndex) {
            return this.vs.get(this.safeIndex(vIndex));
        }

        @Override
        public long add(double x, double y, double z, double nx, double ny, double nz, double u, double v) {
            int index = this.xs.size();
            this.xs.add((Object)x);
            this.ys.add((Object)y);
            this.zs.add((Object)z);
            this.nxs.add((Object)nx);
            this.nys.add((Object)ny);
            this.nzs.add((Object)nz);
            this.us.add((Object)u);
            this.vs.add((Object)v);
            return index;
        }

        @Override
        public void set(long vIndex, double x, double y, double z, double nx, double ny, double nz, double u, double v) {
            int index = this.safeIndex(vIndex);
            this.xs.set(index, Double.valueOf(x));
            this.ys.set(index, Double.valueOf(y));
            this.zs.set(index, Double.valueOf(z));
            this.nxs.set(index, Double.valueOf(nx));
            this.nys.set(index, Double.valueOf(ny));
            this.nzs.set(index, Double.valueOf(nz));
            this.us.set(index, Double.valueOf(u));
            this.vs.set(index, Double.valueOf(v));
        }

        @Override
        public void setPosition(long vIndex, double x, double y, double z) {
            int index = this.safeIndex(vIndex);
            this.xs.set(index, Double.valueOf(x));
            this.ys.set(index, Double.valueOf(y));
            this.zs.set(index, Double.valueOf(z));
        }

        @Override
        public void setNormal(long vIndex, double nx, double ny, double nz) {
            int index = this.safeIndex(vIndex);
            this.nxs.set(index, Double.valueOf(nx));
            this.nys.set(index, Double.valueOf(ny));
            this.nzs.set(index, Double.valueOf(nz));
        }

        @Override
        public void setTexture(long vIndex, double u, double v) {
            int index = this.safeIndex(vIndex);
            this.us.set(index, Double.valueOf(u));
            this.vs.set(index, Double.valueOf(v));
        }

        private int safeIndex(long index) {
            if (index > Integer.MAX_VALUE) {
                throw new IndexOutOfBoundsException("Index too large: " + index);
            }
            return (int)index;
        }

        @Override
        public float xf(long vIndex) {
            return (float)this.x(vIndex);
        }

        @Override
        public float yf(long vIndex) {
            return (float)this.y(vIndex);
        }

        @Override
        public float zf(long vIndex) {
            return (float)this.z(vIndex);
        }

        @Override
        public float nxf(long vIndex) {
            return (float)this.nx(vIndex);
        }

        @Override
        public float nyf(long vIndex) {
            return (float)this.ny(vIndex);
        }

        @Override
        public float nzf(long vIndex) {
            return (float)this.nz(vIndex);
        }

        @Override
        public float uf(long vIndex) {
            return (float)this.u(vIndex);
        }

        @Override
        public float vf(long vIndex) {
            return (float)this.v(vIndex);
        }

        @Override
        public long addf(float x, float y, float z, float nx, float ny, float nz, float u, float v) {
            return this.add(x, y, z, nx, ny, nz, u, v);
        }

        @Override
        public void setf(long vIndex, float x, float y, float z, float nx, float ny, float nz, float u, float v) {
            this.set(vIndex, x, y, z, nx, ny, nz, u, v);
        }

        @Override
        public void setPositionf(long vIndex, float x, float y, float z) {
            this.setPosition(vIndex, x, y, z);
        }

        @Override
        public void setNormalf(long vIndex, float nx, float ny, float nz) {
            this.setNormal(vIndex, nx, ny, nz);
        }

        @Override
        public void setTexturef(long vIndex, float u, float v) {
            this.setTexture(vIndex, u, v);
        }
    }
}

