/*
 * Decompiled with CFR 0.152.
 */
package org.jogamp.java3d;

import org.jogamp.java3d.BoundingBox;
import org.jogamp.java3d.BoundingPolytope;
import org.jogamp.java3d.BoundingSphere;
import org.jogamp.java3d.Bounds;
import org.jogamp.java3d.GeometryRetained;
import org.jogamp.java3d.GeometryStripArrayRetained;
import org.jogamp.java3d.J3dI18N;
import org.jogamp.java3d.PickBounds;
import org.jogamp.java3d.PickCone;
import org.jogamp.java3d.PickCylinder;
import org.jogamp.java3d.PickInfo;
import org.jogamp.java3d.PickRay;
import org.jogamp.java3d.PickSegment;
import org.jogamp.java3d.PickShape;
import org.jogamp.java3d.Transform3D;
import org.jogamp.vecmath.Point3d;
import org.jogamp.vecmath.Vector3d;

class TriangleFanArrayRetained
extends GeometryStripArrayRetained {
    TriangleFanArrayRetained() {
        this.geoType = 6;
    }

    @Override
    boolean intersect(PickShape pickShape, PickInfo pickInfo, int flags, Point3d iPnt, GeometryRetained geom, int geomIndex) {
        Point3d[] pnts = new Point3d[3];
        double[] sdist = new double[1];
        double minDist = Double.MAX_VALUE;
        double x = 0.0;
        double y = 0.0;
        double z = 0.0;
        int i = 0;
        pnts[0] = new Point3d();
        pnts[1] = new Point3d();
        pnts[2] = new Point3d();
        int[] vtxIndexArr = new int[3];
        switch (pickShape.getPickType()) {
            case 1: {
                PickRay pickRay = (PickRay)pickShape;
                while (i < this.stripVertexCounts.length) {
                    int j = this.stripStartVertexIndices[i];
                    int end = j + this.stripVertexCounts[i++];
                    for (int k = 0; k < 2; ++k) {
                        vtxIndexArr[k] = j;
                        this.getVertexData(j++, pnts[k]);
                    }
                    while (j < end) {
                        vtxIndexArr[2] = j;
                        this.getVertexData(j++, pnts[2]);
                        if (this.intersectRay(pnts, pickRay, sdist, iPnt)) {
                            if (flags == 0) {
                                return true;
                            }
                            if (sdist[0] < minDist) {
                                minDist = sdist[0];
                                x = iPnt.x;
                                y = iPnt.y;
                                z = iPnt.z;
                                if ((flags & 0x20) != 0) {
                                    this.storeInterestData(pickInfo, flags, geom, geomIndex, vtxIndexArr, iPnt, sdist[0]);
                                }
                            }
                            if ((flags & 0x40) != 0) {
                                this.storeInterestData(pickInfo, flags, geom, geomIndex, vtxIndexArr, iPnt, sdist[0]);
                            }
                        }
                        pnts[1].set(pnts[2]);
                        vtxIndexArr[1] = vtxIndexArr[2];
                    }
                }
                break;
            }
            case 2: {
                PickSegment pickSegment = (PickSegment)pickShape;
                while (i < this.stripVertexCounts.length) {
                    int j = this.stripStartVertexIndices[i];
                    int end = j + this.stripVertexCounts[i++];
                    for (int k = 0; k < 2; ++k) {
                        vtxIndexArr[k] = j;
                        this.getVertexData(j++, pnts[k]);
                    }
                    while (j < end) {
                        vtxIndexArr[2] = j;
                        this.getVertexData(j++, pnts[2]);
                        if (this.intersectSegment(pnts, pickSegment.start, pickSegment.end, sdist, iPnt)) {
                            if (flags == 0) {
                                return true;
                            }
                            if (sdist[0] < minDist) {
                                minDist = sdist[0];
                                x = iPnt.x;
                                y = iPnt.y;
                                z = iPnt.z;
                                if ((flags & 0x20) != 0) {
                                    this.storeInterestData(pickInfo, flags, geom, geomIndex, vtxIndexArr, iPnt, sdist[0]);
                                }
                            }
                            if ((flags & 0x40) != 0) {
                                this.storeInterestData(pickInfo, flags, geom, geomIndex, vtxIndexArr, iPnt, sdist[0]);
                            }
                        }
                        pnts[1].set(pnts[2]);
                        vtxIndexArr[1] = vtxIndexArr[2];
                    }
                }
                break;
            }
            case 6: {
                BoundingBox bbox = (BoundingBox)((PickBounds)pickShape).bounds;
                while (i < this.stripVertexCounts.length) {
                    int j = this.stripStartVertexIndices[i];
                    int end = j + this.stripVertexCounts[i++];
                    for (int k = 0; k < 2; ++k) {
                        vtxIndexArr[k] = j;
                        this.getVertexData(j++, pnts[k]);
                    }
                    while (j < end) {
                        vtxIndexArr[2] = j;
                        this.getVertexData(j++, pnts[2]);
                        if (this.intersectBoundingBox(pnts, bbox, sdist, iPnt)) {
                            if (flags == 0) {
                                return true;
                            }
                            if (sdist[0] < minDist) {
                                minDist = sdist[0];
                                x = iPnt.x;
                                y = iPnt.y;
                                z = iPnt.z;
                                if ((flags & 0x20) != 0) {
                                    this.storeInterestData(pickInfo, flags, geom, geomIndex, vtxIndexArr, iPnt, sdist[0]);
                                }
                            }
                            if ((flags & 0x40) != 0) {
                                this.storeInterestData(pickInfo, flags, geom, geomIndex, vtxIndexArr, iPnt, sdist[0]);
                            }
                        }
                        pnts[1].set(pnts[2]);
                        vtxIndexArr[1] = vtxIndexArr[2];
                    }
                }
                break;
            }
            case 7: {
                BoundingSphere bsphere = (BoundingSphere)((PickBounds)pickShape).bounds;
                while (i < this.stripVertexCounts.length) {
                    int j = this.stripStartVertexIndices[i];
                    int end = j + this.stripVertexCounts[i++];
                    for (int k = 0; k < 2; ++k) {
                        vtxIndexArr[k] = j;
                        this.getVertexData(j++, pnts[k]);
                    }
                    while (j < end) {
                        vtxIndexArr[2] = j;
                        this.getVertexData(j++, pnts[2]);
                        if (this.intersectBoundingSphere(pnts, bsphere, sdist, iPnt)) {
                            if (flags == 0) {
                                return true;
                            }
                            if (sdist[0] < minDist) {
                                minDist = sdist[0];
                                x = iPnt.x;
                                y = iPnt.y;
                                z = iPnt.z;
                                if ((flags & 0x20) != 0) {
                                    this.storeInterestData(pickInfo, flags, geom, geomIndex, vtxIndexArr, iPnt, sdist[0]);
                                }
                            }
                            if ((flags & 0x40) != 0) {
                                this.storeInterestData(pickInfo, flags, geom, geomIndex, vtxIndexArr, iPnt, sdist[0]);
                            }
                        }
                        pnts[1].set(pnts[2]);
                        vtxIndexArr[1] = vtxIndexArr[2];
                    }
                }
                break;
            }
            case 8: {
                BoundingPolytope bpolytope = (BoundingPolytope)((PickBounds)pickShape).bounds;
                while (i < this.stripVertexCounts.length) {
                    int j = this.stripStartVertexIndices[i];
                    int end = j + this.stripVertexCounts[i++];
                    for (int k = 0; k < 2; ++k) {
                        vtxIndexArr[k] = j;
                        this.getVertexData(j++, pnts[k]);
                    }
                    while (j < end) {
                        vtxIndexArr[2] = j;
                        this.getVertexData(j++, pnts[2]);
                        if (this.intersectBoundingPolytope(pnts, bpolytope, sdist, iPnt)) {
                            if (flags == 0) {
                                return true;
                            }
                            if (sdist[0] < minDist) {
                                minDist = sdist[0];
                                x = iPnt.x;
                                y = iPnt.y;
                                z = iPnt.z;
                                if ((flags & 0x20) != 0) {
                                    this.storeInterestData(pickInfo, flags, geom, geomIndex, vtxIndexArr, iPnt, sdist[0]);
                                }
                            }
                            if ((flags & 0x40) != 0) {
                                this.storeInterestData(pickInfo, flags, geom, geomIndex, vtxIndexArr, iPnt, sdist[0]);
                            }
                        }
                        pnts[1].set(pnts[2]);
                        vtxIndexArr[1] = vtxIndexArr[2];
                    }
                }
                break;
            }
            case 4: {
                PickCylinder pickCylinder = (PickCylinder)pickShape;
                while (i < this.stripVertexCounts.length) {
                    int j = this.stripStartVertexIndices[i];
                    int end = j + this.stripVertexCounts[i++];
                    for (int k = 0; k < 2; ++k) {
                        vtxIndexArr[k] = j;
                        this.getVertexData(j++, pnts[k]);
                    }
                    while (j < end) {
                        vtxIndexArr[2] = j;
                        this.getVertexData(j++, pnts[2]);
                        if (this.intersectCylinder(pnts, pickCylinder, sdist, iPnt)) {
                            if (flags == 0) {
                                return true;
                            }
                            if (sdist[0] < minDist) {
                                minDist = sdist[0];
                                x = iPnt.x;
                                y = iPnt.y;
                                z = iPnt.z;
                                if ((flags & 0x20) != 0) {
                                    this.storeInterestData(pickInfo, flags, geom, geomIndex, vtxIndexArr, iPnt, sdist[0]);
                                }
                            }
                            if ((flags & 0x40) != 0) {
                                this.storeInterestData(pickInfo, flags, geom, geomIndex, vtxIndexArr, iPnt, sdist[0]);
                            }
                        }
                        pnts[1].set(pnts[2]);
                        vtxIndexArr[1] = vtxIndexArr[2];
                    }
                }
                break;
            }
            case 5: {
                PickCone pickCone = (PickCone)pickShape;
                while (i < this.stripVertexCounts.length) {
                    int j = this.stripStartVertexIndices[i];
                    int end = j + this.stripVertexCounts[i++];
                    for (int k = 0; k < 2; ++k) {
                        vtxIndexArr[k] = j;
                        this.getVertexData(j++, pnts[k]);
                    }
                    while (j < end) {
                        vtxIndexArr[2] = j;
                        this.getVertexData(j++, pnts[2]);
                        if (this.intersectCone(pnts, pickCone, sdist, iPnt)) {
                            if (flags == 0) {
                                return true;
                            }
                            if (sdist[0] < minDist) {
                                minDist = sdist[0];
                                x = iPnt.x;
                                y = iPnt.y;
                                z = iPnt.z;
                                if ((flags & 0x20) != 0) {
                                    this.storeInterestData(pickInfo, flags, geom, geomIndex, vtxIndexArr, iPnt, sdist[0]);
                                }
                            }
                            if ((flags & 0x40) != 0) {
                                this.storeInterestData(pickInfo, flags, geom, geomIndex, vtxIndexArr, iPnt, sdist[0]);
                            }
                        }
                        pnts[1].set(pnts[2]);
                        vtxIndexArr[1] = vtxIndexArr[2];
                    }
                }
                break;
            }
            case 3: {
                throw new IllegalArgumentException(J3dI18N.getString("TriangleFanArrayRetained0"));
            }
            default: {
                throw new RuntimeException("PickShape not supported for intersection");
            }
        }
        if (minDist < Double.MAX_VALUE) {
            iPnt.x = x;
            iPnt.y = y;
            iPnt.z = z;
            return true;
        }
        return false;
    }

    @Override
    boolean intersect(Point3d[] pnts) {
        Point3d[] points = new Point3d[3];
        double[] dist = new double[1];
        int i = 0;
        points[0] = new Point3d();
        points[1] = new Point3d();
        points[2] = new Point3d();
        switch (pnts.length) {
            case 3: {
                while (i < this.stripVertexCounts.length) {
                    int j = this.stripStartVertexIndices[i];
                    int end = j + this.stripVertexCounts[i++];
                    this.getVertexData(j++, points[0]);
                    this.getVertexData(j++, points[1]);
                    while (j < end) {
                        this.getVertexData(j++, points[2]);
                        if (this.intersectTriTri(points[0], points[1], points[2], pnts[0], pnts[1], pnts[2])) {
                            return true;
                        }
                        points[1].set(points[2]);
                    }
                }
                break;
            }
            case 4: {
                while (i < this.stripVertexCounts.length) {
                    int j = this.stripStartVertexIndices[i];
                    int end = j + this.stripVertexCounts[i++];
                    this.getVertexData(j++, points[0]);
                    this.getVertexData(j++, points[1]);
                    while (j < end) {
                        this.getVertexData(j++, points[2]);
                        if (this.intersectTriTri(points[0], points[1], points[2], pnts[0], pnts[1], pnts[2]) || this.intersectTriTri(points[0], points[1], points[2], pnts[0], pnts[2], pnts[3])) {
                            return true;
                        }
                        points[1].set(points[2]);
                    }
                }
                break;
            }
            case 2: {
                while (i < this.stripVertexCounts.length) {
                    int j = this.stripStartVertexIndices[i];
                    int end = j + this.stripVertexCounts[i++];
                    this.getVertexData(j++, points[0]);
                    this.getVertexData(j++, points[1]);
                    while (j < end) {
                        this.getVertexData(j++, points[2]);
                        if (this.intersectSegment(points, pnts[0], pnts[1], dist, null)) {
                            return true;
                        }
                        points[1].set(points[2]);
                    }
                }
                break;
            }
            case 1: {
                while (i < this.stripVertexCounts.length) {
                    int j = this.stripStartVertexIndices[i];
                    int end = j + this.stripVertexCounts[i++];
                    this.getVertexData(j++, points[0]);
                    this.getVertexData(j++, points[1]);
                    while (j < end) {
                        this.getVertexData(j++, points[2]);
                        if (this.intersectTriPnt(points[0], points[1], points[2], pnts[0])) {
                            return true;
                        }
                        points[1].set(points[2]);
                    }
                }
                break;
            }
        }
        return false;
    }

    @Override
    boolean intersect(Transform3D thisToOtherVworld, GeometryRetained geom) {
        int i = 0;
        Point3d[] pnts = new Point3d[]{new Point3d(), new Point3d(), new Point3d()};
        while (i < this.stripVertexCounts.length) {
            int j = this.stripStartVertexIndices[i];
            int end = j + this.stripVertexCounts[i++];
            this.getVertexData(j++, pnts[0]);
            this.getVertexData(j++, pnts[1]);
            thisToOtherVworld.transform(pnts[0]);
            thisToOtherVworld.transform(pnts[1]);
            while (j < end) {
                this.getVertexData(j++, pnts[2]);
                thisToOtherVworld.transform(pnts[2]);
                if (geom.intersect(pnts)) {
                    return true;
                }
                pnts[1].set(pnts[2]);
            }
        }
        return false;
    }

    @Override
    boolean intersect(Bounds targetBound) {
        int i = 0;
        Point3d[] pnts = new Point3d[]{new Point3d(), new Point3d(), new Point3d()};
        switch (targetBound.getPickType()) {
            case 6: {
                BoundingBox box = (BoundingBox)targetBound;
                while (i < this.stripVertexCounts.length) {
                    int j = this.stripStartVertexIndices[i];
                    this.getVertexData(j++, pnts[0]);
                    this.getVertexData(j++, pnts[1]);
                    int end = j + this.stripVertexCounts[i++];
                    while (j < end) {
                        this.getVertexData(j++, pnts[2]);
                        if (this.intersectBoundingBox(pnts, box, null, null)) {
                            return true;
                        }
                        pnts[1].set(pnts[2]);
                    }
                }
                break;
            }
            case 7: {
                BoundingSphere bsphere = (BoundingSphere)targetBound;
                while (i < this.stripVertexCounts.length) {
                    int j = this.stripStartVertexIndices[i];
                    int end = j + this.stripVertexCounts[i++];
                    this.getVertexData(j++, pnts[0]);
                    this.getVertexData(j++, pnts[1]);
                    while (j < end) {
                        this.getVertexData(j++, pnts[2]);
                        if (this.intersectBoundingSphere(pnts, bsphere, null, null)) {
                            return true;
                        }
                        pnts[1].set(pnts[2]);
                    }
                }
                break;
            }
            case 8: {
                BoundingPolytope bpolytope = (BoundingPolytope)targetBound;
                while (i < this.stripVertexCounts.length) {
                    int j = this.stripStartVertexIndices[i];
                    int end = j + this.stripVertexCounts[i++];
                    this.getVertexData(j++, pnts[0]);
                    this.getVertexData(j++, pnts[1]);
                    while (j < end) {
                        this.getVertexData(j++, pnts[2]);
                        if (this.intersectBoundingPolytope(pnts, bpolytope, null, null)) {
                            return true;
                        }
                        pnts[1].set(pnts[2]);
                    }
                }
                break;
            }
            default: {
                throw new RuntimeException("Bounds not supported for intersection " + targetBound);
            }
        }
        return false;
    }

    @Override
    void computeCentroid() {
        double area;
        Vector3d vec = new Vector3d();
        Vector3d normal = new Vector3d();
        Vector3d tmpvec = new Vector3d();
        Point3d pnt0 = new Point3d();
        Point3d pnt1 = new Point3d();
        Point3d pnt2 = new Point3d();
        double totalarea = 0.0;
        int i = 0;
        this.centroid.x = 0.0;
        this.centroid.y = 0.0;
        this.centroid.z = 0.0;
        while (i < this.stripVertexCounts.length) {
            int j = this.stripStartVertexIndices[i];
            int end = j + this.stripVertexCounts[i++];
            this.getVertexData(j++, pnt0);
            this.getVertexData(j++, pnt1);
            int replaceIndex = 2;
            while (j < end) {
                area = 0.0;
                if (replaceIndex == 2) {
                    this.getVertexData(j++, pnt2);
                    replaceIndex = 1;
                } else {
                    this.getVertexData(j++, pnt1);
                    replaceIndex = 2;
                }
                vec.sub(pnt0, pnt1);
                tmpvec.sub(pnt1, pnt2);
                normal.cross(vec, tmpvec);
                normal.normalize();
                if (Double.isNaN(normal.x + normal.y + normal.z)) continue;
                tmpvec.set(0.0, 0.0, 0.0);
                this.getCrossValue(pnt0, pnt1, tmpvec);
                this.getCrossValue(pnt1, pnt2, tmpvec);
                this.getCrossValue(pnt2, pnt0, tmpvec);
                area = normal.dot(tmpvec);
                totalarea += area;
                this.centroid.x += (pnt0.x + pnt1.x + pnt2.x) * area;
                this.centroid.y += (pnt0.y + pnt1.y + pnt2.y) * area;
                this.centroid.z += (pnt0.z + pnt1.z + pnt2.z) * area;
            }
        }
        if (totalarea != 0.0) {
            area = 1.0 / (3.0 * totalarea);
            this.centroid.x *= area;
            this.centroid.y *= area;
            this.centroid.z *= area;
        }
    }

    @Override
    int getClassType() {
        return 3;
    }
}

