/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.outofbounds;

import java.util.Random;
import net.imglib2.Interval;
import net.imglib2.RandomAccessible;
import net.imglib2.outofbounds.AbstractOutOfBoundsValue;
import net.imglib2.type.numeric.RealType;

public class OutOfBoundsRandomValue<T extends RealType<T>>
extends AbstractOutOfBoundsValue<T> {
    final T value;
    protected final double minValue;
    protected final double maxValue;
    protected final double range;
    protected final Random rnd;

    protected OutOfBoundsRandomValue(OutOfBoundsRandomValue<T> outOfBounds) {
        super(outOfBounds);
        this.value = (RealType)outOfBounds.value.createVariable();
        this.minValue = outOfBounds.minValue;
        this.maxValue = outOfBounds.maxValue;
        this.range = outOfBounds.range;
        this.rnd = new Random();
    }

    public <F extends Interval & RandomAccessible<T>> OutOfBoundsRandomValue(F f, T value, Random rnd, double min, double max) {
        super(f);
        this.value = value;
        this.rnd = rnd;
        this.minValue = min;
        this.maxValue = max;
        this.range = max - min;
    }

    @Override
    public final T get() {
        if (this.isOutOfBounds) {
            this.value.setReal(this.rnd.nextDouble() * this.range + this.minValue);
            return this.value;
        }
        return (T)((RealType)this.sampler.get());
    }

    @Override
    public final OutOfBoundsRandomValue<T> copy() {
        return new OutOfBoundsRandomValue<T>(this);
    }
}

