/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.type.numeric.complex;

import net.imglib2.img.NativeImg;
import net.imglib2.img.basictypeaccess.FloatAccess;
import net.imglib2.img.basictypeaccess.array.FloatArray;
import net.imglib2.type.Index;
import net.imglib2.type.NativeType;
import net.imglib2.type.NativeTypeFactory;
import net.imglib2.type.numeric.complex.AbstractComplexType;
import net.imglib2.type.numeric.real.FloatType;
import net.imglib2.util.Fraction;
import net.imglib2.util.Util;

public class ComplexFloatType
extends AbstractComplexType<ComplexFloatType>
implements NativeType<ComplexFloatType> {
    private final Index i = new Index();
    protected final NativeImg<?, ? extends FloatAccess> img;
    protected FloatAccess dataAccess;
    private static final NativeTypeFactory<ComplexFloatType, FloatAccess> typeFactory = NativeTypeFactory.FLOAT(ComplexFloatType::new);

    public ComplexFloatType(NativeImg<?, ? extends FloatAccess> complexfloatStorage) {
        this.img = complexfloatStorage;
    }

    public ComplexFloatType(float r, float i) {
        this.img = null;
        this.dataAccess = new FloatArray(2);
        this.set(r, i);
    }

    public ComplexFloatType(FloatAccess access) {
        this.img = null;
        this.dataAccess = access;
    }

    public ComplexFloatType() {
        this(0.0f, 0.0f);
    }

    @Override
    public void updateContainer(Object c) {
        this.dataAccess = this.img.update(c);
    }

    @Override
    public Index index() {
        return this.i;
    }

    @Override
    public ComplexFloatType duplicateTypeOnSameNativeImg() {
        return new ComplexFloatType(this.img);
    }

    @Override
    public NativeTypeFactory<ComplexFloatType, FloatAccess> getNativeTypeFactory() {
        return typeFactory;
    }

    @Override
    public float getRealFloat() {
        return this.dataAccess.getValue(this.i.get() << 1);
    }

    @Override
    public double getRealDouble() {
        return this.dataAccess.getValue(this.i.get() << 1);
    }

    @Override
    public float getImaginaryFloat() {
        return this.dataAccess.getValue((this.i.get() << 1) + 1);
    }

    @Override
    public double getImaginaryDouble() {
        return this.dataAccess.getValue((this.i.get() << 1) + 1);
    }

    @Override
    public void setReal(float r) {
        this.dataAccess.setValue(this.i.get() << 1, r);
    }

    @Override
    public void setReal(double r) {
        this.dataAccess.setValue(this.i.get() << 1, (float)r);
    }

    @Override
    public void setImaginary(float i) {
        this.dataAccess.setValue((this.i.get() << 1) + 1, i);
    }

    @Override
    public void setImaginary(double i) {
        this.dataAccess.setValue((this.i.get() << 1) + 1, (float)i);
    }

    public void set(float r, float i) {
        int j = this.i.get() << 1;
        this.dataAccess.setValue(j, r);
        this.dataAccess.setValue(j + 1, i);
    }

    @Override
    public void add(ComplexFloatType c) {
        this.setReal(this.getRealFloat() + c.getRealFloat());
        this.setImaginary(this.getImaginaryFloat() + c.getImaginaryFloat());
    }

    @Override
    public void div(ComplexFloatType c) {
        float a1 = this.getRealFloat();
        float b1 = this.getImaginaryFloat();
        float c1 = c.getRealFloat();
        float d1 = c.getImaginaryFloat();
        this.setReal((a1 * c1 + b1 * d1) / (c1 * c1 + d1 * d1));
        this.setImaginary((b1 * c1 - a1 * d1) / (c1 * c1 + d1 * d1));
    }

    @Override
    public void mul(ComplexFloatType t) {
        float a = this.getRealFloat();
        float b = this.getImaginaryFloat();
        float c = t.getRealFloat();
        float d = t.getImaginaryFloat();
        this.setReal(a * c - b * d);
        this.setImaginary(a * d + b * c);
    }

    @Override
    public void sub(ComplexFloatType c) {
        this.setReal(this.getRealFloat() - c.getRealFloat());
        this.setImaginary(this.getImaginaryFloat() - c.getImaginaryFloat());
    }

    @Override
    public void complexConjugate() {
        this.setImaginary(-this.getImaginaryFloat());
    }

    public void switchRealComplex() {
        float a = this.getRealFloat();
        this.setReal(this.getImaginaryFloat());
        this.setImaginary(a);
    }

    @Override
    public void set(ComplexFloatType c) {
        this.setReal(c.getRealFloat());
        this.setImaginary(c.getImaginaryFloat());
    }

    @Override
    public ComplexFloatType createVariable() {
        return new ComplexFloatType(0.0f, 0.0f);
    }

    @Override
    public ComplexFloatType copy() {
        if (this.dataAccess != null) {
            return new ComplexFloatType(this.getRealFloat(), this.getImaginaryFloat());
        }
        return this.createVariable();
    }

    @Override
    public Fraction getEntitiesPerPixel() {
        return new Fraction(2L, 1L);
    }

    @Override
    public boolean valueEquals(ComplexFloatType t) {
        return FloatType.equals(this.getRealFloat(), t.getRealFloat()) && FloatType.equals(this.getImaginaryFloat(), t.getImaginaryFloat());
    }

    @Override
    public boolean equals(Object obj) {
        return Util.valueEqualsObject(this, obj);
    }

    @Override
    public int hashCode() {
        int rHash = Float.hashCode(this.getRealFloat());
        int iHash = Float.hashCode(this.getImaginaryFloat());
        return Util.combineHash(rHash, iHash);
    }
}

