/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.module.process;

import java.util.Objects;
import org.scijava.module.Module;
import org.scijava.module.ModuleItem;
import org.scijava.module.ModuleService;
import org.scijava.module.process.AbstractPreprocessorPlugin;
import org.scijava.module.process.PreprocessorPlugin;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;
import org.scijava.util.Types;

@Plugin(type=PreprocessorPlugin.class, priority=10000.0)
public class DefaultValuePreprocessor
extends AbstractPreprocessorPlugin {
    @Parameter
    private ModuleService moduleService;

    @Override
    public void process(Module module) {
        for (ModuleItem<?> input : module.getInfo().inputs()) {
            this.assignDefaultValue(module, input);
        }
        for (ModuleItem<?> output : module.getInfo().outputs()) {
            this.assignDefaultValue(module, output);
        }
    }

    private <T> void assignDefaultValue(Module module, ModuleItem<T> item) {
        if (module.isInputResolved(item.getName())) {
            return;
        }
        T nullValue = Types.nullValue(item.getType());
        if (!Objects.equals(item.getValue(module), nullValue)) {
            return;
        }
        T defaultValue = this.moduleService.getDefaultValue(item);
        if (defaultValue == null) {
            return;
        }
        item.setValue(module, defaultValue);
    }
}

