/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.run;

import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import org.scijava.plugin.HandlerService;
import org.scijava.run.CodeRunner;
import org.scijava.service.SciJavaService;

public interface RunService
extends HandlerService<Object, CodeRunner>,
SciJavaService {
    default public void run(Object code, Object ... args) throws InvocationTargetException {
        for (CodeRunner runner : this.getInstances()) {
            if (!runner.supports(code)) continue;
            runner.run(code, args);
            return;
        }
        throw new IllegalArgumentException("Unknown code type: " + code);
    }

    default public void run(Object code, Map<String, Object> inputMap) throws InvocationTargetException {
        for (CodeRunner runner : this.getInstances()) {
            if (!runner.supports(code)) continue;
            runner.run(code, inputMap);
            return;
        }
        throw new IllegalArgumentException("Unknown code type: " + code);
    }

    @Override
    default public Class<CodeRunner> getPluginType() {
        return CodeRunner.class;
    }

    @Override
    default public Class<Object> getType() {
        return Object.class;
    }
}

