/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.sampler;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.imagej.axis.AxisType;
import net.imagej.display.ImageDisplay;

public class AxisSubrange {
    private String err = null;
    private final List<Long> indices = new ArrayList<Long>();

    private AxisSubrange() {
    }

    public String getError() {
        return this.err;
    }

    public List<Long> getIndices() {
        return Collections.unmodifiableList(this.indices);
    }

    public AxisSubrange(long pos) {
        this();
        this.indices.add(pos);
    }

    public AxisSubrange(long pos1, long pos2) {
        this();
        long numElements = Math.max(pos1, pos2) - Math.min(pos1, pos2) + 1L;
        if (numElements > Integer.MAX_VALUE) {
            this.err = "AxisSubrange: the number of axis elements cannot exceed 2147483647";
            return;
        }
        int by = pos1 <= pos2 ? 1 : -1;
        long l = pos1;
        while (by > 0 ? l <= pos2 : l >= pos2) {
            this.indices.add(l);
            l += (long)by;
        }
    }

    public AxisSubrange(long pos1, long pos2, long by) {
        this();
        if (by == 0L) {
            this.err = "AxisSubrange: increment by must not be 0";
            return;
        }
        long numElements = (Math.max(pos1, pos2) - Math.min(pos1, pos2) + 1L) / Math.abs(by);
        if (numElements > Integer.MAX_VALUE) {
            this.err = "AxisSubrange: the number of axis elements cannot exceed 2147483647";
            return;
        }
        long l = pos1;
        while (by > 0L ? l <= pos2 : l >= pos2) {
            this.indices.add(l);
            l += by;
        }
    }

    public AxisSubrange(ImageDisplay display, AxisType axis, String definition, boolean originOne) {
        this();
        long max;
        long min;
        int axisIndex = display.dimensionIndex(axis);
        if (originOne) {
            min = 1L;
            max = display.dimension(axisIndex);
        } else {
            min = 0L;
            max = display.dimension(axisIndex) - 1L;
        }
        this.parseAxisDefinition(min, max, definition);
    }

    private void parseAxisDefinition(long min, long max, String description) {
        String[] terms = description.split(",");
        if (terms.length == 0) {
            this.err = "AxisSubrange: description string is empty";
            return;
        }
        for (int i = 0; i < terms.length; ++i) {
            terms[i] = terms[i].trim();
        }
        for (String term : terms) {
            long end;
            Long num = this.number(term);
            Range numDashNum = this.numberDashNumber(term);
            Range numDashNumDashNum = this.numberDashNumberDashNumber(term);
            AxisSubrange subrange = null;
            if (num != null) {
                if (num < min || num > max) {
                    this.err = "AxisSubrange: dimension out of bounds (" + min + "," + max + ") : " + num + " in " + description;
                } else {
                    subrange = new AxisSubrange(num - min);
                }
            } else if (numDashNum != null) {
                long start = numDashNum.start;
                end = numDashNum.end;
                if (end < start) {
                    long tmp = end;
                    end = start;
                    start = tmp;
                }
                if (start < min || start > max) {
                    this.err = "AxisSubrange: dimension out of bounds (" + min + "," + max + ") : " + start + " in " + description;
                } else if (end < min || end > max) {
                    this.err = "AxisSubrange: dimension out of bounds (" + min + "," + max + ") : " + end + " in " + description;
                } else {
                    subrange = new AxisSubrange(start - min, end - min);
                }
            } else if (numDashNumDashNum != null) {
                long start = numDashNumDashNum.start;
                end = numDashNumDashNum.end;
                long by = numDashNumDashNum.by;
                if (start < min || start > max) {
                    this.err = "AxisSubrange: dimension out of bounds (" + min + "," + max + ") : " + start + " in " + description;
                } else if (end < min || end > max) {
                    this.err = "AxisSubrange: dimension out of bounds (" + min + "," + max + ") : " + end + " in " + description;
                } else if (by == 0L) {
                    this.err = "AxisSubrange: step by value cannot be 0 in " + description;
                } else if (by < 0L && start < end || by > 0L && end < start) {
                    this.err = "AxisSubrange: empty interval specified in " + description;
                } else {
                    subrange = new AxisSubrange(start - min, end - min, by);
                }
            } else {
                this.err = "AxisSubrange: could not parse definition: " + description;
            }
            if (this.err != null) {
                return;
            }
            for (long l : subrange.getIndices()) {
                if (this.indices.contains(l)) continue;
                this.indices.add(l);
            }
        }
        Collections.sort(this.indices);
    }

    private Long number(String term) {
        Matcher matcher = Pattern.compile("\\d+").matcher(term);
        if (!matcher.matches()) {
            return null;
        }
        return Long.parseLong(term);
    }

    private Range numberDashNumber(String term) {
        Matcher matcher = Pattern.compile("\\d+-\\d+").matcher(term);
        if (!matcher.matches()) {
            return null;
        }
        String[] values = term.split("-");
        long start = Long.parseLong(values[0]);
        long end = Long.parseLong(values[1]);
        return new Range(start, end, 1L);
    }

    private Range numberDashNumberDashNumber(String term) {
        Matcher matcher = Pattern.compile("\\d+-\\d+-\\d+").matcher(term);
        if (!matcher.matches()) {
            return null;
        }
        String[] values = term.split("-");
        long start = Long.parseLong(values[0]);
        long end = Long.parseLong(values[1]);
        long by = Long.parseLong(values[2]);
        return new Range(start, end, by);
    }

    private class Range {
        private final long start;
        private final long end;
        private final long by;

        private Range(long start, long end, long by) {
            this.start = start;
            this.end = end;
            this.by = by;
        }
    }
}

