/*
 * Decompiled with CFR 0.152.
 */
package view4d;

import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.image.ImageProducer;
import java.net.URL;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JTextField;
import view4d.Timeline;

public class TimelineGUI
implements ActionListener,
KeyListener {
    private final JPanel p;
    private final boolean visible = false;
    final String nbbFile = "icons/nobounceback.png";
    final String bbFile = "icons/bounceback.png";
    final int bbIndex = 2;
    final Image bbImage;
    final Image nbbImage;
    final String playFile = "icons/play.png";
    final String pauseFile = "icons/pause.png";
    final int playIndex = 3;
    final Image playImage;
    final Image pauseImage;
    private static final String[] FILES = new String[]{"icons/first.png", "icons/last.png", "icons/nobounceback.png", "icons/play.png", "icons/record.png", "icons/faster.png", "icons/slower.png"};
    private static final String[] COMMANDS = new String[]{"FIRST", "LAST", "NOBOUNCEBACK", "PLAY", "RECORD", "FASTER", "SLOWER"};
    private final JButton[] buttons = new JButton[FILES.length];
    private final Timeline timeline;
    private final JScrollBar scroll;
    private final JTextField tf;

    public TimelineGUI(Timeline tl) {
        this.timeline = tl;
        this.bbImage = this.loadIcon("icons/bounceback.png");
        this.nbbImage = this.loadIcon("icons/nobounceback.png");
        this.playImage = this.loadIcon("icons/play.png");
        this.pauseImage = this.loadIcon("icons/pause.png");
        GridBagLayout gridbag = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        this.p = new JPanel(gridbag);
        c.gridy = 0;
        c.gridx = 0;
        c.fill = 2;
        c.anchor = 13;
        c.weighty = 0.0;
        c.weightx = 0.0;
        for (int i = 0; i < FILES.length; ++i) {
            this.buttons[i] = new JButton(new ImageIcon(this.loadIcon(FILES[i])));
            this.buttons[i].setBorder(null);
            this.buttons[i].addActionListener(this);
            this.buttons[i].setActionCommand(COMMANDS[i]);
            gridbag.setConstraints(this.buttons[i], c);
            this.p.add(this.buttons[i]);
            ++c.gridx;
        }
        int min = this.timeline.getUniverse().getStartTime();
        int max = this.timeline.getUniverse().getEndTime() + 1;
        int cur = this.timeline.getUniverse().getCurrentTimepoint();
        c.fill = 2;
        c.weightx = 1.0;
        this.scroll = new JScrollBar(0, cur, 1, min, max);
        this.scroll.addAdjustmentListener(new AdjustmentListener(){

            @Override
            public void adjustmentValueChanged(AdjustmentEvent e) {
                TimelineGUI.this.showTimepoint(TimelineGUI.this.scroll.getValue());
            }
        });
        gridbag.setConstraints(this.scroll, c);
        this.p.add(this.scroll);
        this.tf = new JTextField(2);
        this.tf.setText(Integer.toString(cur));
        this.tf.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    int v = 0;
                    try {
                        v = Integer.parseInt(TimelineGUI.this.tf.getText());
                        TimelineGUI.this.showTimepoint(v);
                        TimelineGUI.this.tf.selectAll();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        });
        c.fill = 2;
        c.anchor = 13;
        c.weighty = 0.0;
        c.weightx = 0.0;
        ++c.gridx;
        gridbag.setConstraints(this.tf, c);
        this.p.add(this.tf);
    }

    private void showTimepoint(int v) {
        this.timeline.getUniverse().showTimepoint(v);
    }

    public JPanel getPanel() {
        return this.p;
    }

    public void updateTimepoint(int val) {
        this.scroll.setValue(val);
        this.tf.setText(Integer.toString(val));
    }

    public void updateStartAndEnd(int start, int end) {
        this.scroll.setMinimum(start);
        this.scroll.setMaximum(end + 1);
    }

    private Image loadIcon(String name) {
        Image img = null;
        try {
            URL url = this.getClass().getResource(name);
            img = Toolkit.getDefaultToolkit().createImage((ImageProducer)url.getContent());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (img == null) {
            throw new RuntimeException("Image not found: " + name);
        }
        return img;
    }

    public synchronized void togglePlay() {
        if (!this.p.isVisible()) {
            return;
        }
        if (this.buttons[3].getActionCommand().equals("PLAY")) {
            this.buttons[3].setActionCommand("PAUSE");
            this.buttons[3].setIcon(new ImageIcon(this.pauseImage));
            this.buttons[3].setBorder(null);
            this.buttons[3].repaint();
            this.timeline.play();
        } else {
            this.buttons[3].setActionCommand("PLAY");
            this.buttons[3].setIcon(new ImageIcon(this.playImage));
            this.buttons[3].setBorder(null);
            this.buttons[3].repaint();
            this.timeline.pause();
        }
    }

    @Override
    public void keyPressed(KeyEvent e) {
        if (e.getKeyCode() == 92 || e.getKeyCode() == 32) {
            this.togglePlay();
        }
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        for (int i = 0; i < this.buttons.length; ++i) {
            this.buttons[i].repaint();
        }
        String command = e.getActionCommand();
        if (command.equals("BOUNCEBACK")) {
            this.buttons[2].setActionCommand("NOBOUNCEBACK");
            this.buttons[2].setIcon(new ImageIcon(this.nbbImage));
            this.buttons[2].setBorder(null);
            this.buttons[2].repaint();
            this.timeline.setBounceBack(true);
        } else if (command.equals("NOBOUNCEBACK")) {
            this.buttons[2].setActionCommand("BOUNCEBACK");
            this.buttons[2].setIcon(new ImageIcon(this.bbImage));
            this.buttons[2].setBorder(null);
            this.buttons[2].repaint();
            this.timeline.setBounceBack(false);
        } else if (command.equals("PLAY")) {
            this.buttons[3].setActionCommand("PAUSE");
            this.buttons[3].setIcon(new ImageIcon(this.pauseImage));
            this.buttons[3].setBorder(null);
            this.buttons[3].repaint();
            this.timeline.play();
        } else if (command.equals("PAUSE")) {
            this.buttons[3].setActionCommand("PLAY");
            this.buttons[3].setIcon(new ImageIcon(this.playImage));
            this.buttons[3].setBorder(null);
            this.buttons[3].repaint();
            this.timeline.pause();
        } else if (command.equals("RECORD")) {
            this.timeline.record().show();
        } else if (command.equals("FIRST")) {
            this.timeline.first();
        } else if (command.equals("LAST")) {
            this.timeline.last();
        } else if (command.equals("FASTER")) {
            this.timeline.faster();
        } else if (command.equals("SLOWER")) {
            this.timeline.slower();
        }
    }
}

