/*
 * Decompiled with CFR 0.152.
 */
package org.janelia.saalfeldlab.n5;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.OutputStream;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.InflaterInputStream;
import org.apache.commons.compress.compressors.gzip.GzipCompressorInputStream;
import org.apache.commons.compress.compressors.gzip.GzipCompressorOutputStream;
import org.apache.commons.compress.compressors.gzip.GzipParameters;
import org.janelia.saalfeldlab.n5.Compression;
import org.janelia.saalfeldlab.n5.DefaultBlockReader;
import org.janelia.saalfeldlab.n5.DefaultBlockWriter;
import org.janelia.saalfeldlab.n5.ReflectionUtils;

@Compression.CompressionType(value="gzip")
public class GzipCompression
implements DefaultBlockReader,
DefaultBlockWriter,
Compression {
    private static final long serialVersionUID = 8630847239813334263L;
    @Compression.CompressionParameter
    private final int level;
    @Compression.CompressionParameter
    private final boolean useZlib;
    private final transient GzipParameters parameters = new GzipParameters();

    public GzipCompression() {
        this(-1);
    }

    public GzipCompression(int level) {
        this(level, false);
    }

    public GzipCompression(int level, boolean useZlib) {
        this.level = level;
        this.useZlib = useZlib;
    }

    @Override
    public InputStream getInputStream(InputStream in) throws IOException {
        if (this.useZlib) {
            return new InflaterInputStream(in);
        }
        return new GzipCompressorInputStream(in, true);
    }

    @Override
    public OutputStream getOutputStream(OutputStream out) throws IOException {
        if (this.useZlib) {
            return new DeflaterOutputStream(out, new Deflater(this.level));
        }
        this.parameters.setCompressionLevel(this.level);
        return new GzipCompressorOutputStream(out, this.parameters);
    }

    @Override
    public GzipCompression getReader() {
        return this;
    }

    @Override
    public GzipCompression getWriter() {
        return this;
    }

    private void readObject(ObjectInputStream in) throws Exception {
        in.defaultReadObject();
        ReflectionUtils.setFieldValue(this, "parameters", new GzipParameters());
    }

    public boolean equals(Object other) {
        if (other == null || other.getClass() != GzipCompression.class) {
            return false;
        }
        GzipCompression gz = (GzipCompression)other;
        return this.useZlib == gz.useZlib && this.level == gz.level;
    }
}

