/*
 * Decompiled with CFR 0.152.
 */
package org.apposed.appose.builder;

import java.io.File;
import java.util.List;
import org.apposed.appose.BuilderFactory;
import org.apposed.appose.util.Plugins;

public final class Builders {
    private static final List<BuilderFactory> ALL = Plugins.discover(BuilderFactory.class, (a, b) -> Double.compare(b.priority(), a.priority()));

    private Builders() {
    }

    public static BuilderFactory findFactoryByName(String name) {
        return Plugins.find(ALL, factory -> factory.name().equalsIgnoreCase(name));
    }

    public static BuilderFactory findFactoryByScheme(String scheme) {
        return Plugins.find(ALL, factory -> factory.supportsScheme(scheme));
    }

    public static BuilderFactory findFactoryForWrapping(File envDir) {
        return Plugins.find(ALL, factory -> factory.canWrap(envDir));
    }

    public static BuilderFactory findFactoryBySource(String source) {
        if (source == null) {
            throw new IllegalStateException("Cannot auto-detect builder: no source specified");
        }
        return Plugins.find(ALL, factory -> factory.supportsSource(source));
    }

    public static boolean canWrap(File envDir) {
        return Builders.findFactoryForWrapping(envDir) != null;
    }

    public static String envType(File envDir) {
        BuilderFactory factory = Builders.findFactoryForWrapping(envDir);
        return factory == null ? null : factory.name();
    }
}

