/*
 * Decompiled with CFR 0.152.
 */
package org.apposed.appose.shm;

import com.sun.jna.Native;
import com.sun.jna.Pointer;
import org.apposed.appose.SharedMemory;
import org.apposed.appose.ShmFactory;
import org.apposed.appose.shm.CLibrary;
import org.apposed.appose.shm.MacosHelpers;
import org.apposed.appose.shm.ShmBase;
import org.apposed.appose.shm.Shms;
import org.apposed.appose.util.Platforms;

public class ShmMacOS
implements ShmFactory {
    @Override
    public SharedMemory create(String name, boolean create, long rsize) {
        if (!Platforms.isMacOS()) {
            return null;
        }
        return new SharedMemoryMacOS(name, create, rsize);
    }

    private static class SharedMemoryMacOS
    extends ShmBase<Integer> {
        private SharedMemoryMacOS(String name, boolean create, long rsize) {
            super(SharedMemoryMacOS.prepareShm(name, create, rsize));
        }

        @Override
        protected void doUnlink() {
            CLibrary.INSTANCE.shm_unlink(this.name());
        }

        @Override
        protected void doClose() {
            if (this.info.pointer != Pointer.NULL && CLibrary.INSTANCE.munmap(this.info.pointer, this.size()) == -1) {
                throw new RuntimeException("munmap failed. Errno: " + Native.getLastError());
            }
            if (CLibrary.INSTANCE.close((Integer)this.info.handle) == -1) {
                throw new RuntimeException("close failed. Errno: " + Native.getLastError());
            }
        }

        private static ShmBase.ShmInfo<Integer> prepareShm(String name, boolean create, long rsize) {
            String shmName;
            long prevSize;
            if (name == null) {
                while ((prevSize = SharedMemoryMacOS.getSHMSize(shmName = Shms.makeFilename(14, "/psm_"))) >= 0L) {
                }
            } else {
                shmName = Shms.withLeadingSlash(name);
                prevSize = SharedMemoryMacOS.getSHMSize(shmName);
            }
            Shms.checkSize(shmName, prevSize, rsize);
            int shmFd = MacosHelpers.INSTANCE.create_shared_memory(shmName, rsize);
            if (shmFd < 0) {
                throw new RuntimeException("shm_open failed, errno: " + Native.getLastError());
            }
            long shm_size = SharedMemoryMacOS.getSHMSize(shmFd);
            Pointer pointer = CLibrary.INSTANCE.mmap(Pointer.NULL, shm_size, Shms.PROT_READ | Shms.PROT_WRITE, Shms.MAP_SHARED, shmFd, 0L);
            if (pointer == Pointer.NULL) {
                CLibrary.INSTANCE.close(shmFd);
                CLibrary.INSTANCE.shm_unlink(shmName);
                throw new RuntimeException("mmap failed, errno: " + Native.getLastError());
            }
            ShmBase.ShmInfo<Integer> info = new ShmBase.ShmInfo<Integer>();
            info.name = Shms.withoutLeadingSlash(shmName);
            info.rsize = rsize;
            info.size = shm_size;
            info.pointer = pointer;
            info.handle = shmFd;
            info.unlinkOnClose = create;
            return info;
        }

        private static long getSHMSize(String name) {
            int shmFd = CLibrary.INSTANCE.shm_open(name, Shms.O_RDONLY, 448);
            if (shmFd < 0) {
                return -1L;
            }
            return SharedMemoryMacOS.getSHMSize(shmFd);
        }

        private static long getSHMSize(int shmFd) {
            if (shmFd < 0) {
                throw new RuntimeException("Invalid shmFd. It should be bigger than 0.");
            }
            long size = MacosHelpers.INSTANCE.get_shared_memory_size(shmFd);
            if (size == -1L) {
                throw new RuntimeException("Failed to get shared memory segment size. Errno: " + Native.getLastError());
            }
            return size;
        }
    }
}

