/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.java3d.utils.universe;

import org.scijava.java3d.PhysicalBody;
import org.scijava.java3d.Transform3D;
import org.scijava.java3d.utils.universe.ConfigCommand;
import org.scijava.java3d.utils.universe.ConfigObject;
import org.scijava.vecmath.Matrix4d;
import org.scijava.vecmath.Point3d;

class ConfigPhysicalBody
extends ConfigObject {
    Point3d leftEyePosition = new Point3d(-0.033, 0.0, 0.0);
    Point3d rightEyePosition = new Point3d(0.033, 0.0, 0.0);
    double stereoEyeSeparation = Double.MAX_VALUE;
    Point3d leftEarPosition = new Point3d(-0.08, -0.03, 0.09);
    Point3d rightEarPosition = new Point3d(0.08, -0.03, 0.09);
    double nominalEyeHeightFromGround = 1.68;
    double nominalEyeOffsetFromNominalScreen = 0.4572;
    Matrix4d headToHeadTracker = new Matrix4d(1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0);
    PhysicalBody j3dPhysicalBody;

    ConfigPhysicalBody() {
    }

    @Override
    protected void initialize(ConfigCommand command) {
    }

    @Override
    protected void setProperty(ConfigCommand command) {
        int argc = command.argc;
        Object[] argv = command.argv;
        if (argc != 4) {
            this.syntaxError("Incorrect number of arguments to " + command.commandName);
        }
        if (!this.isName(argv[1])) {
            this.syntaxError("The first argument to " + command.commandName + " must be a name");
        }
        if (!this.isName(argv[2])) {
            this.syntaxError("The second argument to " + command.commandName + " must be an property/attribute name");
        }
        String prop = (String)argv[2];
        Object val = argv[3];
        if (prop.equals("StereoEyeSeparation")) {
            if (!(val instanceof Double)) {
                this.syntaxError("StereoEyeSeparation must be a number");
            }
            this.stereoEyeSeparation = (Double)val;
        } else if (prop.equals("LeftEyePosition")) {
            if (!(val instanceof Point3d)) {
                this.syntaxError("LeftEyePosition must be a point");
            }
            this.leftEyePosition = (Point3d)val;
        } else if (prop.equals("RightEyePosition")) {
            if (!(val instanceof Point3d)) {
                this.syntaxError("RightEyePosition must be a point");
            }
            this.rightEyePosition = (Point3d)val;
        } else if (prop.equals("LeftEarPosition")) {
            if (!(val instanceof Point3d)) {
                this.syntaxError("LeftEarPosition must be a point");
            }
            this.leftEarPosition = (Point3d)val;
        } else if (prop.equals("RightEarPosition")) {
            if (!(val instanceof Point3d)) {
                this.syntaxError("RightEarPosition must be a point");
            }
            this.leftEarPosition = (Point3d)val;
        } else if (prop.equals("NominalEyeHeightFromGround")) {
            if (!(val instanceof Double)) {
                this.syntaxError("NominalEyeHeightFromGround must be a number");
            }
            this.nominalEyeHeightFromGround = (Double)val;
        } else if (prop.equals("NominalEyeOffsetFromNominalScreen")) {
            if (!(val instanceof Double)) {
                this.syntaxError("NominalEyeOffsetFromNominalScreen must be a number");
            }
            this.nominalEyeOffsetFromNominalScreen = (Double)val;
        } else if (prop.equals("HeadToHeadTracker")) {
            if (!(val instanceof Matrix4d)) {
                this.syntaxError("HeadToHeadTracker must be a matrix");
            }
            this.headToHeadTracker = (Matrix4d)val;
        } else {
            this.syntaxError("Unknown " + command.commandName + " \"" + prop + "\"");
        }
    }

    PhysicalBody createJ3dPhysicalBody() {
        if (this.stereoEyeSeparation < Double.MAX_VALUE) {
            this.leftEyePosition.set(-this.stereoEyeSeparation / 2.0, 0.0, 0.0);
            this.rightEyePosition.set(this.stereoEyeSeparation / 2.0, 0.0, 0.0);
        }
        this.j3dPhysicalBody = new PhysicalBody(this.leftEyePosition, this.rightEyePosition, this.leftEarPosition, this.rightEarPosition);
        this.j3dPhysicalBody.setHeadToHeadTracker(new Transform3D(this.headToHeadTracker));
        this.j3dPhysicalBody.setNominalEyeHeightFromGround(this.nominalEyeHeightFromGround);
        this.j3dPhysicalBody.setNominalEyeOffsetFromNominalScreen(this.nominalEyeOffsetFromNominalScreen);
        return this.j3dPhysicalBody;
    }
}

