/*
 * Decompiled with CFR 0.152.
 */
package edu.utexas.clm.archipelago;

import edu.utexas.clm.archipelago.FijiArchipelago;
import edu.utexas.clm.archipelago.compute.ProcessManager;
import edu.utexas.clm.archipelago.compute.QuickCallable;
import edu.utexas.clm.archipelago.compute.QuickRunnable;
import edu.utexas.clm.archipelago.compute.Scheduler;
import edu.utexas.clm.archipelago.data.ClusterMessage;
import edu.utexas.clm.archipelago.listen.ClusterStateListener;
import edu.utexas.clm.archipelago.listen.MessageType;
import edu.utexas.clm.archipelago.network.MessageXC;
import edu.utexas.clm.archipelago.network.node.ClusterNode;
import edu.utexas.clm.archipelago.network.node.NodeCoordinator;
import edu.utexas.clm.archipelago.network.node.NodeParameters;
import edu.utexas.clm.archipelago.network.node.NodeParametersFactory;
import edu.utexas.clm.archipelago.network.shell.NodeShell;
import edu.utexas.clm.archipelago.network.shell.SSHNodeShell;
import edu.utexas.clm.archipelago.network.shell.SocketNodeShell;
import edu.utexas.clm.archipelago.network.translation.Bottler;
import edu.utexas.clm.archipelago.network.translation.FileBottler;
import edu.utexas.clm.archipelago.ui.ArchipelagoUI;
import edu.utexas.clm.archipelago.util.XCErrorAdapter;
import ij.Prefs;
import java.io.EOFException;
import java.io.IOException;
import java.io.InvalidClassException;
import java.io.NotSerializableException;
import java.io.StreamCorruptedException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;

public class Cluster {
    private static final HashMap<String, NodeShell> shellMap = new HashMap();
    private static Cluster cluster = null;
    private AtomicInteger state;
    private final Vector<Thread> waitThreads;
    private final Vector<ArchipelagoUI> registeredUIs;
    private final Scheduler scheduler;
    private final NodeCoordinator nodeCoordinator;
    private String localHostName;
    private final Vector<ClusterStateListener> listeners;
    private final XCErrorAdapter xcEListener;
    private final Cluster self = this;
    private final NodeParametersFactory parametersFactory;
    private final long hash;

    public static Cluster getCluster() {
        if (!Cluster.initializedCluster()) {
            cluster = new Cluster();
        }
        return cluster;
    }

    public static Cluster getClusterWithUI() {
        if (!Cluster.initializedCluster()) {
            cluster = new Cluster();
        }
        if (cluster.numRegisteredUIs() <= 0) {
            FijiArchipelago.runClusterGUI(cluster);
        }
        return cluster;
    }

    public static boolean activeCluster() {
        return cluster != null && cluster.getState() == ClusterState.RUNNING;
    }

    public static boolean initializedCluster() {
        ClusterState state = cluster == null ? null : cluster.getState();
        FijiArchipelago.debug("Main cluster state is " + Cluster.stateString(state));
        return cluster != null && state != ClusterState.STOPPING && state != ClusterState.STOPPED;
    }

    private static ClusterState stateIntToEnum(int s) {
        switch (s) {
            case 0: {
                return ClusterState.INSTANTIATED;
            }
            case 1: {
                return ClusterState.INITIALIZED;
            }
            case 2: {
                return ClusterState.STARTED;
            }
            case 3: {
                return ClusterState.RUNNING;
            }
            case 4: {
                return ClusterState.STOPPING;
            }
            case 5: {
                return ClusterState.STOPPED;
            }
        }
        return ClusterState.UNKNOWN;
    }

    private static int stateEnumToInt(ClusterState s) {
        switch (s) {
            case INSTANTIATED: {
                return 0;
            }
            case INITIALIZED: {
                return 1;
            }
            case STARTED: {
                return 2;
            }
            case RUNNING: {
                return 3;
            }
            case STOPPING: {
                return 4;
            }
            case STOPPED: {
                return 5;
            }
        }
        return -1;
    }

    public static String stateString(ClusterState s) {
        if (s == null) {
            return "Nothing";
        }
        switch (s) {
            case INSTANTIATED: {
                return "Instantiated";
            }
            case INITIALIZED: {
                return "Initialized";
            }
            case STARTED: {
                return "Started";
            }
            case RUNNING: {
                return "Running";
            }
            case STOPPING: {
                return "Stopping";
            }
            case STOPPED: {
                return "Stopped";
            }
        }
        return "Unknown";
    }

    public static void registerNodeShell(NodeShell shell) {
        shellMap.put(shell.name(), shell);
    }

    public static NodeShell getNodeShell(String description) {
        return shellMap.get(description);
    }

    public static Collection<NodeShell> registeredShells() {
        return shellMap.values();
    }

    public static boolean configureCluster(Cluster cluster, String execRootRemote, String fileRootRemote, String execRoot, String fileRoot, String userName) {
        String prefRoot = "FijiArchipelago";
        cluster.getParametersFactory().setDefaultUser(userName);
        cluster.getParametersFactory().setDefaultExecRoot(execRootRemote);
        cluster.getParametersFactory().setDefaultFileRoot(fileRootRemote);
        FijiArchipelago.setExecRoot(execRoot);
        FijiArchipelago.setFileRoot(fileRoot);
        Prefs.set((String)"FijiArchipelago.username", (String)userName);
        Prefs.set((String)"FijiArchipelago.execRoot", (String)execRoot);
        Prefs.set((String)"FijiArchipelago.fileRoot", (String)fileRoot);
        Prefs.set((String)"FijiArchipelago.execRootRemote", (String)execRootRemote);
        Prefs.set((String)"FijiArchipelago.fileRootRemote", (String)fileRootRemote);
        Prefs.savePreferences();
        return cluster.init();
    }

    private Cluster() {
        this.state = new AtomicInteger(0);
        this.waitThreads = new Vector();
        this.registeredUIs = new Vector();
        this.xcEListener = new XCErrorAdapter(){

            @Override
            public boolean handleCustom(Throwable t, MessageXC mxc, ClusterMessage message) {
                if (message.type == MessageType.PROCESS) {
                    ProcessManager pm = (ProcessManager)message.o;
                    pm.setException(t);
                    Cluster.this.scheduler.error(pm.getID(), t);
                }
                if (t instanceof StreamCorruptedException || t instanceof EOFException) {
                    FijiArchipelago.debug("", t);
                    mxc.close();
                    return false;
                }
                return true;
            }

            @Override
            public boolean handleCustomRX(Throwable t, MessageXC xc, ClusterMessage message) {
                long lastID = xc.getLastProcessID();
                if (message.type == MessageType.ERROR) {
                    Cluster.this.errorFuture(lastID, (Throwable)message.o);
                }
                if (t instanceof ClassNotFoundException) {
                    this.reportRX(t, "Check that your jars are all correctly synchronized. " + t, xc);
                    return false;
                }
                if (t instanceof NotSerializableException) {
                    this.reportRX(t, "Your Callable returned a value that was not Serializable. " + t, xc);
                    return false;
                }
                if (t instanceof InvalidClassException) {
                    this.reportRX(t, "Caught remote InvalidClassException.\nThis means you likely have multiple jars for the given class: " + t, xc);
                    this.silence();
                    return false;
                }
                return true;
            }

            @Override
            public boolean handleCustomTX(Throwable t, MessageXC xc, ClusterMessage message) {
                if (t instanceof NotSerializableException) {
                    FijiArchipelago.debug("NSE trace.", t);
                    this.reportTX(t, "Ensure that your class and all member objects are Serializable: " + t, xc);
                    return false;
                }
                if (t instanceof ConcurrentModificationException) {
                    this.reportTX(t, "Take care not to modify member objects as your Callable is being Serialized: " + t, xc);
                    return false;
                }
                if (t instanceof IOException) {
                    this.reportTX(t, "Stream closed, closing node. ", xc);
                    xc.close();
                    return false;
                }
                return true;
            }
        };
        this.scheduler = new Scheduler(this);
        this.listeners = new Vector();
        this.hash = new Long(System.currentTimeMillis()).hashCode();
        this.parametersFactory = new NodeParametersFactory();
        try {
            this.localHostName = InetAddress.getLocalHost().getCanonicalHostName();
        }
        catch (UnknownHostException uhe) {
            this.localHostName = "localhost";
            FijiArchipelago.err("Could not get canonical host name for local machine. Using localhost instead");
        }
        this.nodeCoordinator = new NodeCoordinator(this);
        this.addBottler(new FileBottler());
    }

    public boolean equals(Object o) {
        return o instanceof Cluster && o == this;
    }

    private void setState(ClusterState state) {
        if (Cluster.stateIntToEnum(this.state.get()) == ClusterState.STOPPED) {
            FijiArchipelago.debug("Attempted to change state on a STOPPED cluster.");
            return;
        }
        FijiArchipelago.debug("Cluster: State changed from " + Cluster.stateString(this.getState()) + " to " + Cluster.stateString(state));
        this.state.set(Cluster.stateEnumToInt(state));
        if (this.getState() == ClusterState.RUNNING) {
            this.scheduler.start();
        }
        this.triggerListeners();
    }

    public ClusterState getState() {
        return Cluster.stateIntToEnum(this.state.get());
    }

    public boolean init() {
        if (this.getState() == ClusterState.INSTANTIATED) {
            this.scheduler.close();
            this.nodeCoordinator.reset();
            this.setState(ClusterState.INITIALIZED);
            return true;
        }
        return false;
    }

    public void setLocalHostName(String host) {
        this.localHostName = host;
    }

    public ClusterNode getNode(long id) {
        return this.nodeCoordinator.getNode(id);
    }

    public void startNode(ClusterNode node) {
        this.nodeCoordinator.startNode(node);
    }

    public void startNode(NodeParameters params) {
        this.nodeCoordinator.startNode(params);
    }

    public boolean hasNode(long id) {
        return this.nodeCoordinator.getNode(id) != null;
    }

    public boolean hasNode(ClusterNode node) {
        return this.hasNode(node.getID());
    }

    public void addStateListener(ClusterStateListener listener) {
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    public synchronized void removeStateListener(ClusterStateListener listener) {
        this.listeners.remove(listener);
    }

    public void triggerListeners() {
        Vector<ClusterStateListener> listenersLocal = new Vector<ClusterStateListener>(this.listeners);
        for (ClusterStateListener listener : listenersLocal) {
            listener.stateChanged(this);
        }
    }

    public boolean acceptingNodes() {
        ClusterState state = this.getState();
        return state == ClusterState.RUNNING || state == ClusterState.STARTED;
    }

    private boolean nodesWaiting() {
        return this.nodeCoordinator.numWaitingNodes() > 0;
    }

    public void waitForAllNodes(long timeout) throws InterruptedException, TimeoutException {
        if (timeout <= 0L) {
            return;
        }
        boolean wait = true;
        long sTime = System.currentTimeMillis();
        while (wait) {
            long wTime = System.currentTimeMillis() - sTime;
            if (this.nodesWaiting()) {
                if (wTime > timeout) {
                    throw new TimeoutException();
                }
                Thread.sleep(1000L);
                continue;
            }
            wait = false;
        }
    }

    public void waitUntilReady() {
        this.waitUntilReady(Long.MAX_VALUE);
    }

    public void waitUntilReady(long timeout) {
        boolean wait = !this.isReady();
        long sTime = System.currentTimeMillis();
        FijiArchipelago.debug("Cluster: Waiting for ready nodes");
        while (wait) {
            try {
                Thread.sleep(1000L);
                if (System.currentTimeMillis() - sTime > timeout) {
                    if (this.getState() != ClusterState.RUNNING) {
                        FijiArchipelago.err("Cluster timed out while waiting for nodes to be ready");
                    }
                    wait = false;
                    continue;
                }
                wait = this.getState() != ClusterState.RUNNING;
            }
            catch (InterruptedException ie) {
                wait = false;
            }
        }
        FijiArchipelago.log("Cluster is ready");
    }

    public int countReadyNodes() {
        return this.nodeCoordinator.numRunningNodes();
    }

    public boolean isReady() {
        return this.getState() == ClusterState.RUNNING;
    }

    public synchronized void jobFinished() {
        int nJobs = this.scheduler.numRunningJobs();
        this.triggerListeners();
        if (nJobs == 0 && this.isShutdown() && !this.isTerminated()) {
            this.haltFinished();
        }
    }

    private void errorFuture(long id, Throwable e) {
        this.scheduler.error(id, e);
    }

    public Set<ClusterNode> getNodes() {
        return this.nodeCoordinator.getNodes();
    }

    public ArrayList<NodeParameters> getNodeParameters() {
        return this.nodeCoordinator.getParameters();
    }

    public NodeCoordinator getNodeCoordinator() {
        return this.nodeCoordinator;
    }

    public NodeParametersFactory getParametersFactory() {
        return this.parametersFactory;
    }

    public void addBottler(Bottler bottler) {
        FijiArchipelago.debug("Registered bottler " + bottler.getClass().getName());
        this.nodeCoordinator.addBottler(bottler);
    }

    public List<Bottler> getBottlers() {
        return this.nodeCoordinator.getBottlers();
    }

    public void start() {
        FijiArchipelago.debug("Cluster: start called");
        if (this.getState() == ClusterState.INITIALIZED) {
            FijiArchipelago.debug("Scheduler alive? :" + this.scheduler.isAlive());
            if (this.nodeCoordinator.numRunningNodes() > 0) {
                this.setState(ClusterState.RUNNING);
            } else {
                this.setState(ClusterState.STARTED);
            }
        }
    }

    public int getRunningJobCount() {
        return this.scheduler.numRunningJobs();
    }

    public int getQueuedJobCount() {
        return this.scheduler.numQueuedJobs();
    }

    protected synchronized void haltFinished() {
        this.nodeCoordinator.reset();
        this.triggerListeners();
        FijiArchipelago.debug("Cluster: Halt has finished");
    }

    protected synchronized void terminateFinished() {
        ArrayList<Thread> waitThreadsCP = new ArrayList<Thread>(this.waitThreads);
        this.setState(ClusterState.STOPPED);
        this.scheduler.close();
        for (Thread t : waitThreadsCP) {
            t.interrupt();
        }
    }

    public ArrayList<Callable<?>> remainingCallables() {
        ArrayList<ProcessManager<?>> remainingJobs = this.scheduler.getRemainingJobs();
        ArrayList callables = new ArrayList(remainingJobs.size());
        for (ProcessManager<?> pm : remainingJobs) {
            callables.add(pm.getCallable());
        }
        return callables;
    }

    public ArrayList<Runnable> remainingRunnables() {
        ArrayList<ProcessManager<?>> remainingJobs = this.scheduler.getRemainingJobs();
        ArrayList<Runnable> runnables = new ArrayList<Runnable>(remainingJobs);
        for (ProcessManager<?> pm : remainingJobs) {
            runnables.add(new QuickRunnable(pm.getCallable()));
        }
        return runnables;
    }

    public void nodeStopped(ClusterNode node, int nRunningNodes) {
        for (ProcessManager pm : node.getRunningProcesses()) {
            if (this.isShutdown()) {
                FijiArchipelago.debug("Cancelling running job " + pm.getID());
                this.scheduler.cancelJob(pm.getID(), true);
                continue;
            }
            FijiArchipelago.debug("Rescheduling job " + pm.getID());
            if (this.scheduler.reschedule(pm)) continue;
            FijiArchipelago.err("Could not reschedule job " + pm.getID());
            this.scheduler.error(pm.getID(), new Exception("Could not reschedule job"));
        }
        if (nRunningNodes < 1) {
            FijiArchipelago.debug("Node more running nodes");
            if (this.getState() == ClusterState.STOPPING) {
                this.terminateFinished();
            } else {
                this.setState(ClusterState.STARTED);
            }
        }
        FijiArchipelago.debug("There are now " + nRunningNodes + " running nodes");
    }

    public void nodeStarted() {
        if (this.getState() == ClusterState.STARTED) {
            this.setState(ClusterState.RUNNING);
        }
    }

    public boolean isShutdown() {
        ClusterState state = this.getState();
        return state == ClusterState.STOPPING || state == ClusterState.STOPPED;
    }

    public boolean isTerminated() {
        return this.getState() == ClusterState.STOPPED;
    }

    public synchronized List<Runnable> shutdownNow() {
        ArrayList<ClusterNode> nodescp = new ArrayList<ClusterNode>(this.nodeCoordinator.getNodes());
        this.setState(ClusterState.STOPPING);
        for (ClusterNode node : nodescp) {
            node.close();
        }
        return this.remainingRunnables();
    }

    public synchronized void shutdown() {
        this.setState(ClusterState.STOPPING);
        this.scheduler.close();
        for (ClusterNode node : this.nodeCoordinator.getNodes()) {
            node.setActive(false);
        }
        if (this.scheduler.numRunningJobs() <= 0) {
            this.haltFinished();
        }
    }

    public int getMaxThreads() {
        int maxThreads = -1;
        for (ClusterNode node : this.nodeCoordinator.getNodes()) {
            int ncpu = node.getThreadLimit();
            maxThreads = maxThreads < node.getThreadLimit() ? ncpu : maxThreads;
        }
        return maxThreads < 1 ? 1 : maxThreads;
    }

    public ExecutorService getService(int nThreads) {
        int nt;
        int maxThreads = this.getMaxThreads();
        if (nThreads > maxThreads) {
            FijiArchipelago.debug("Requested " + nThreads + " but there are only " + maxThreads + " available. Using " + maxThreads + " threads");
            nt = maxThreads;
        } else {
            nt = nThreads;
        }
        return new ClusterExecutorService(nt);
    }

    public ExecutorService getService(float fractionThreads) {
        return new ClusterExecutorService(fractionThreads);
    }

    public String getLocalHostName() {
        return this.localHostName;
    }

    public synchronized void registerUI(ArchipelagoUI ui) {
        this.registeredUIs.add(ui);
    }

    public synchronized void deRegisterUI(ArchipelagoUI ui) {
        this.registeredUIs.remove(ui);
    }

    public int numRegisteredUIs() {
        return this.registeredUIs.size();
    }

    public String toString() {
        if (this == cluster) {
            return "THE cluster";
        }
        return "a cluster";
    }

    public static boolean isClusterService(ExecutorService es) {
        return es instanceof ClusterExecutorService;
    }

    static {
        Cluster.registerNodeShell(SSHNodeShell.getShell());
        Cluster.registerNodeShell(SocketNodeShell.getShell());
    }

    private class ClusterExecutorService
    implements ExecutorService {
        private final boolean isFractional;
        private final float numCores;

        public ClusterExecutorService(float ft) {
            this.isFractional = true;
            this.numCores = ft;
        }

        public ClusterExecutorService(int nc) {
            this.isFractional = false;
            this.numCores = nc;
        }

        @Override
        public synchronized void shutdown() {
            Cluster.this.self.shutdown();
        }

        @Override
        public synchronized List<Runnable> shutdownNow() {
            return Cluster.this.self.shutdownNow();
        }

        @Override
        public boolean isShutdown() {
            return Cluster.this.self.isShutdown();
        }

        @Override
        public boolean isTerminated() {
            return Cluster.this.self.isTerminated();
        }

        @Override
        public boolean awaitTermination(long l, TimeUnit timeUnit) throws InterruptedException {
            Thread t = Thread.currentThread();
            Cluster.this.waitThreads.add(t);
            try {
                Thread.sleep(timeUnit.convert(l, TimeUnit.MILLISECONDS));
                Cluster.this.waitThreads.remove(t);
                return this.isTerminated();
            }
            catch (InterruptedException ie) {
                Cluster.this.waitThreads.remove(t);
                if (this.isTerminated()) {
                    return true;
                }
                throw ie;
            }
        }

        @Override
        public <T> Future<T> submit(Callable<T> tCallable) {
            return Cluster.this.scheduler.queueNormal(tCallable, this.numCores, this.isFractional);
        }

        @Override
        public <T> Future<T> submit(Runnable runnable, T t) {
            QuickCallable tCallable = new QuickCallable(runnable);
            return Cluster.this.scheduler.queueNormal(tCallable, this.numCores, this.isFractional);
        }

        @Override
        public Future<?> submit(Runnable runnable) {
            return this.submit(runnable, null);
        }

        @Override
        public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> callables) throws InterruptedException {
            return this.invokeAll(callables, Long.MAX_VALUE, TimeUnit.MILLISECONDS);
        }

        @Override
        public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> callables, final long l, final TimeUnit timeUnit) throws InterruptedException {
            ArrayList<Future<T>> waitFutures = new ArrayList<Future<T>>();
            ArrayList<Future<T>> remainingFutures = new ArrayList<Future<T>>();
            final AtomicBoolean timeOut = new AtomicBoolean(false);
            final AtomicBoolean done = new AtomicBoolean(false);
            final Thread t = Thread.currentThread();
            Thread timeOutThread = new Thread(){

                @Override
                public void run() {
                    block2: {
                        try {
                            FijiArchipelago.debug("Invoke All: Waiting for at most " + timeUnit.convert(l, TimeUnit.MILLISECONDS) + "ms ");
                            Thread.sleep(timeUnit.convert(l, TimeUnit.MILLISECONDS));
                            FijiArchipelago.debug("Invoke All: Timed Out after " + timeUnit.convert(l, TimeUnit.MILLISECONDS) + "ms");
                            timeOut.set(true);
                            t.interrupt();
                        }
                        catch (InterruptedException ie) {
                            if (done.get()) break block2;
                            t.interrupt();
                        }
                    }
                }
            };
            timeOutThread.start();
            try {
                for (Callable<T> callable : callables) {
                    waitFutures.add(this.submit(callable));
                }
                remainingFutures.addAll(waitFutures);
                for (Future future : waitFutures) {
                    try {
                        future.get();
                    }
                    catch (ExecutionException executionException) {
                        // empty catch block
                    }
                    remainingFutures.remove(future);
                }
                done.set(true);
                timeOutThread.interrupt();
                return waitFutures;
            }
            catch (InterruptedException ie) {
                if (timeOut.get()) {
                    FijiArchipelago.debug("Invoke All: Cancelling remaining " + remainingFutures.size() + " futures");
                    for (Future future : remainingFutures) {
                        future.cancel(true);
                    }
                    return waitFutures;
                }
                done.set(true);
                timeOutThread.interrupt();
                throw ie;
            }
        }

        @Override
        public <T> T invokeAny(Collection<? extends Callable<T>> callables) throws InterruptedException, ExecutionException {
            try {
                return this.invokeAny(callables, Long.MAX_VALUE, TimeUnit.MILLISECONDS);
            }
            catch (TimeoutException te) {
                throw new ExecutionException(te);
            }
        }

        @Override
        public <T> T invokeAny(Collection<? extends Callable<T>> callables, final long l, final TimeUnit timeUnit) throws InterruptedException, ExecutionException, TimeoutException {
            ArrayList<Future<T>> waitFutures = new ArrayList<Future<T>>(callables.size());
            ArrayList<Future<T>> remainingFutures = new ArrayList<Future<T>>(callables.size());
            final AtomicBoolean timeOut = new AtomicBoolean(false);
            final AtomicBoolean done = new AtomicBoolean(false);
            final Thread t = Thread.currentThread();
            Thread timeOutThread = new Thread(){

                @Override
                public void run() {
                    block2: {
                        try {
                            Thread.sleep(timeUnit.convert(l, TimeUnit.MILLISECONDS));
                            timeOut.set(true);
                            t.interrupt();
                        }
                        catch (InterruptedException ie) {
                            if (done.get()) break block2;
                            t.interrupt();
                        }
                    }
                }
            };
            ExecutionException lastException = null;
            timeOutThread.start();
            try {
                boolean stillGoing = true;
                Future okFuture = null;
                for (Callable<T> callable : callables) {
                    waitFutures.add(this.submit(callable));
                }
                remainingFutures.addAll(waitFutures);
                for (int i = 0; stillGoing && i < waitFutures.size(); ++i) {
                    okFuture = (Future)waitFutures.get(i);
                    try {
                        okFuture.get();
                        stillGoing = false;
                    }
                    catch (ExecutionException executionException) {
                        lastException = executionException;
                    }
                    remainingFutures.remove(okFuture);
                }
                for (Future future : remainingFutures) {
                    future.cancel(true);
                }
                if (stillGoing) {
                    throw lastException == null ? new ExecutionException(new Exception("No completed callables")) : lastException;
                }
                done.set(true);
                timeOutThread.interrupt();
                return (T)okFuture.get();
            }
            catch (InterruptedException ie) {
                if (timeOut.get()) {
                    throw new TimeoutException();
                }
                done.set(true);
                timeOutThread.interrupt();
                throw ie;
            }
        }

        @Override
        public void execute(Runnable runnable) {
            this.submit(runnable);
        }
    }

    public static enum ClusterState {
        INSTANTIATED,
        INITIALIZED,
        STARTED,
        RUNNING,
        STOPPING,
        STOPPED,
        UNKNOWN;

    }
}

