/*
 * Decompiled with CFR 0.152.
 */
package ini.trakem2.display.d3d;

import ij3d.Content;
import ij3d.DefaultUniverse;
import ij3d.Image3DUniverse;
import ij3d.ImageWindow3D;
import ij3d.UniverseListener;
import ini.trakem2.display.Display;
import ini.trakem2.display.Display3D;
import ini.trakem2.display.Displayable;
import ini.trakem2.display.LayerSet;
import ini.trakem2.persistence.DBObject;
import ini.trakem2.utils.IntegerField;
import ini.trakem2.utils.Utils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumn;
import org.jogamp.java3d.Canvas3D;
import org.jogamp.java3d.View;
import org.jogamp.vecmath.Color3f;

public class Display3DGUI {
    private final Image3DUniverse univ;
    private static final float[][] colors = new float[][]{{255.0f, 255.0f, 0.0f}, {255.0f, 0.0f, 0.0f}, {255.0f, 0.0f, 255.0f}, {0.0f, 255.0f, 0.0f}, {0.0f, 255.0f, 255.0f}, {0.0f, 255.0f, 0.0f}, {255.0f, 255.0f, 255.0f}, {255.0f, 128.0f, 0.0f}, {255.0f, 0.0f, 128.0f}, {128.0f, 255.0f, 0.0f}, {128.0f, 0.0f, 255.0f}, {0.0f, 255.0f, 128.0f}, {0.0f, 128.0f, 255.0f}, {128.0f, 128.0f, 128.0f}};

    public Display3DGUI(Image3DUniverse univ) {
        this.univ = univ;
    }

    public Image3DUniverse getUniverse() {
        return this.univ;
    }

    public ImageWindow3D init() {
        ImageWindow3D frame = new ImageWindow3D("TrakEM2 3D Display", (DefaultUniverse)this.univ);
        frame.getContentPane().removeAll();
        JPanel all = new JPanel();
        all.setBackground(Color.white);
        all.setPreferredSize(new Dimension(768, 512));
        GridBagConstraints c = new GridBagConstraints();
        GridBagLayout gb = new GridBagLayout();
        all.setLayout(gb);
        Canvas3D canvas = this.univ.getCanvas();
        c.anchor = 18;
        c.fill = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.gridheight = 4;
        gb.setConstraints((Component)canvas, c);
        all.add((Component)canvas);
        c.fill = 2;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.gridheight = 1;
        c.gridx = 1;
        JPanel p1 = Display3DGUI.newPanelColors(this.univ);
        gb.setConstraints(p1, c);
        all.add(p1);
        c.gridy = 1;
        c.insets = new Insets(10, 0, 0, 0);
        JPanel p2 = Display3DGUI.newPanelRemoveContents(this.univ);
        gb.setConstraints(p2, c);
        all.add(p2);
        c.gridy = 2;
        c.weighty = 1.0;
        c.fill = 1;
        JPanel p3 = Display3DGUI.newPanelFilterableTable(this.univ);
        gb.setConstraints(p3, c);
        all.add(p3);
        frame.getContentPane().add(all);
        return frame;
    }

    private static final List<Content> getOrderedContents(Image3DUniverse univ) {
        ArrayList<Content> cs = new ArrayList<Content>();
        Iterator seq = univ.getScene().getAllChildren();
        while (seq.hasNext()) {
            Object o = seq.next();
            if (!(o instanceof Content)) continue;
            cs.add((Content)o);
        }
        return cs;
    }

    private static final void addTitledLineBorder(JPanel p, String title) {
        p.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.black, 1), title));
    }

    private static final JPanel newPanelColors(final Image3DUniverse univ) {
        JPanel p = new JPanel();
        p.setBackground(Color.white);
        GridBagLayout gb = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 18;
        c.fill = 2;
        p.setLayout(gb);
        String[] labels = new String[]{"Red", "Green", "Blue"};
        final JScrollBar[] sliders = new JScrollBar[3];
        final JTextField[] typers = new JTextField[3];
        int i = 0;
        while (i < 3) {
            JScrollBar slider;
            sliders[i] = slider = new JScrollBar(0, 255, 1, 0, 256);
            final IntegerField typer = new IntegerField(255, 3);
            typers[i] = typer;
            final int k = i;
            slider.addAdjustmentListener(new AdjustmentListener(){

                @Override
                public void adjustmentValueChanged(AdjustmentEvent e) {
                    Content content = univ.getSelected();
                    if (null == content) {
                        Utils.log("Nothing selected!");
                        return;
                    }
                    Color3f color = content.getColor();
                    if (null == color) {
                        color = new Color3f(1.0f, 1.0f, 0.0f);
                    }
                    float[] co = new float[3];
                    color.get(co);
                    co[k] = (float)e.getValue() / 255.0f;
                    content.setColor(new Color3f(co));
                    typer.setText(Integer.toString(e.getValue()));
                }
            });
            typer.addKeyListener(new SliderTyperLink(univ, slider, typer));
            JLabel l = new JLabel(labels[i]);
            c.gridx = 0;
            c.gridy = i++;
            gb.setConstraints(l, c);
            p.add(l);
            c.gridx = 1;
            c.weightx = 1.0;
            c.fill = 2;
            gb.setConstraints(slider, c);
            p.add(slider);
            c.gridx = 2;
            c.weightx = 0.0;
            c.fill = 0;
            gb.setConstraints(typer, c);
            p.add(typer);
        }
        c.gridx = 0;
        ++c.gridy;
        JLabel aL = new JLabel("Alpha:");
        gb.setConstraints(aL, c);
        p.add(aL);
        c.gridx = 1;
        c.fill = 2;
        c.weightx = 1.0;
        final JScrollBar alphaSlider = new JScrollBar(0, 255, 1, 0, 256);
        gb.setConstraints(alphaSlider, c);
        p.add(alphaSlider);
        c.gridx = 2;
        c.fill = 0;
        c.weightx = 0.0;
        final IntegerField alphaTyper = new IntegerField(255, 3);
        gb.setConstraints(alphaTyper, c);
        p.add(alphaTyper);
        alphaSlider.addAdjustmentListener(new AdjustmentListener(){

            @Override
            public void adjustmentValueChanged(AdjustmentEvent e) {
                Content content = univ.getSelected();
                if (null == content) {
                    Utils.log("Nothing selected!");
                    return;
                }
                float alpha = (float)e.getValue() / 255.0f;
                content.setTransparency(1.0f - alpha);
                alphaTyper.setText(Integer.toString(e.getValue()));
            }
        });
        alphaTyper.addKeyListener(new SliderTyperLink(univ, alphaSlider, alphaTyper));
        c.gridx = 0;
        ++c.gridy;
        c.gridwidth = 3;
        c.weightx = 1.0;
        c.insets = new Insets(15, 4, 4, 4);
        JButton r = new JButton("Assign random colors to all");
        r.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Display3DGUI.randomizeColors(univ);
            }
        });
        gb.setConstraints(r, c);
        p.add(r);
        Display3DGUI.addTitledLineBorder(p, "Colors");
        univ.addUniverseListener(new UniverseListener(){

            public void universeClosed() {
            }

            public void transformationUpdated(View arg0) {
            }

            public void transformationStarted(View arg0) {
            }

            public void transformationFinished(View arg0) {
            }

            public void contentSelected(Content arg0) {
                int i;
                if (null == arg0) {
                    return;
                }
                Color3f color = arg0.getColor();
                if (null == color) {
                    color = new Color3f(1.0f, 1.0f, 0.0f);
                }
                float[] co = new float[3];
                color.get(co);
                for (i = 0; i < 3; ++i) {
                    sliders[i].setValueIsAdjusting(true);
                    int val = (int)(co[i] * 255.0f);
                    typers[i].setText(Integer.toString(val));
                    sliders[i].setValue(val);
                }
                for (i = 0; i < 3; ++i) {
                    sliders[i].setValueIsAdjusting(false);
                }
                alphaSlider.setValueIsAdjusting(true);
                int alpha = (int)((1.0f - arg0.getTransparency()) * 255.0f);
                alphaTyper.setText(Integer.toString(alpha));
                alphaSlider.setValue(alpha);
                alphaSlider.setValueIsAdjusting(false);
            }

            public void contentRemoved(Content arg0) {
            }

            public void contentChanged(Content arg0) {
                if (arg0 == univ.getSelected()) {
                    this.contentSelected(arg0);
                }
            }

            public void contentAdded(Content arg0) {
            }

            public void canvasResized() {
            }
        });
        return p;
    }

    public static final void randomizeColors(Image3DUniverse univ) {
        ArrayList<Content> cs = new ArrayList<Content>(Display3DGUI.getOrderedContents(univ));
        for (int i = 0; i < cs.size(); ++i) {
            if (i < colors.length) {
                cs.get(i).setColor(new Color3f(colors[i]));
                continue;
            }
            cs.get(i).setColor(new Color3f((float)Math.random(), (float)Math.random(), (float)Math.random()));
        }
        Content content = univ.getSelected();
        if (null != content) {
            univ.fireContentChanged(content);
        }
    }

    private static final JPanel newPanelRemoveContents(final Image3DUniverse univ) {
        JPanel p = new JPanel();
        p.setBackground(Color.white);
        GridBagLayout gb = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 16;
        c.fill = 2;
        p.setLayout(gb);
        JLabel label = new JLabel("RegEx:");
        final JTextField regex = new JTextField();
        JButton remove = new JButton("X");
        ActionListener a = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String s = regex.getText();
                if (0 == s.length()) {
                    return;
                }
                if (!s.startsWith("^")) {
                    s = "^.*" + s;
                }
                if (!s.endsWith("$")) {
                    s = s + ".*$";
                }
                Pattern pattern = null;
                try {
                    pattern = Pattern.compile(s);
                }
                catch (PatternSyntaxException pse) {
                    JOptionPane.showMessageDialog((Component)univ.getWindow(), "Error parsing the regular expression:\n" + pse.getMessage());
                    return;
                }
                for (Content c : new ArrayList(Display3DGUI.getOrderedContents(univ))) {
                    if (!pattern.matcher(c.getName()).matches()) continue;
                    univ.removeContent(c.getName());
                    Utils.log("Removed " + c.getName());
                }
            }
        };
        remove.addActionListener(a);
        regex.addActionListener(a);
        gb.setConstraints(label, c);
        p.add(label);
        c.gridx = 1;
        c.weightx = 1.0;
        c.fill = 1;
        gb.setConstraints(regex, c);
        p.add(regex);
        c.gridx = 2;
        c.weightx = 0.0;
        c.fill = 0;
        gb.setConstraints(remove, c);
        p.add(remove);
        Display3DGUI.addTitledLineBorder(p, "Remove content");
        return p;
    }

    private static final JPanel newPanelFilterableTable(Image3DUniverse univ) {
        JPanel p = new JPanel();
        p.setBackground(Color.white);
        GridBagConstraints c = new GridBagConstraints();
        GridBagLayout gb = new GridBagLayout();
        p.setLayout(gb);
        c.anchor = 18;
        c.fill = 2;
        JLabel label = new JLabel("RegEx: ");
        JTextField regexField = new JTextField();
        final ContentTable table = new ContentTable(univ);
        final ContentTableModel ctm = new ContentTableModel(univ, regexField);
        table.setModel(ctm);
        univ.addUniverseListener((UniverseListener)new TableUniverseListener(table));
        regexField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ctm.update(table);
            }
        });
        gb.setConstraints(label, c);
        p.add(label);
        c.gridx = 1;
        c.weightx = 1.0;
        gb.setConstraints(regexField, c);
        p.add(regexField);
        c.gridx = 0;
        c.gridy = 1;
        c.gridwidth = 2;
        c.weighty = 1.0;
        c.fill = 1;
        JScrollPane jsp = new JScrollPane(table);
        gb.setConstraints(jsp, c);
        p.add(jsp);
        Display3DGUI.addTitledLineBorder(p, "Contents");
        return p;
    }

    private static final class RegExFilter {
        final Pattern pattern;

        RegExFilter(String regex) {
            if (0 == regex.length()) {
                this.pattern = null;
                return;
            }
            if (!regex.startsWith("^")) {
                regex = "^.*" + regex;
            }
            if (!regex.endsWith("$")) {
                regex = regex + ".*$";
            }
            this.pattern = Pattern.compile(regex);
        }

        final boolean accept(String s) {
            if (null == this.pattern) {
                return true;
            }
            return this.pattern.matcher(s).matches();
        }
    }

    private static final class TableUniverseListener
    implements UniverseListener {
        private final ContentTable table;

        TableUniverseListener(ContentTable table) {
            this.table = table;
        }

        public void universeClosed() {
        }

        public void transformationUpdated(View arg0) {
        }

        public void transformationStarted(View arg0) {
        }

        public void transformationFinished(View arg0) {
        }

        public void contentSelected(final Content c) {
            Utils.invokeLater(new Runnable(){

                @Override
                public void run() {
                    int i = ((ContentTableModel)table.getModel()).contents.indexOf(c);
                    table.getSelectionModel().setSelectionInterval(i, i);
                }
            });
        }

        public void contentRemoved(Content arg0) {
            ((ContentTableModel)this.table.getModel()).update(this.table);
        }

        public void contentChanged(Content arg0) {
            ((ContentTableModel)this.table.getModel()).update(this.table);
        }

        public void contentAdded(Content arg0) {
            ((ContentTableModel)this.table.getModel()).update(this.table);
        }

        public void canvasResized() {
        }
    }

    private static class ContentTable
    extends JTable {
        private static final long serialVersionUID = 1L;

        ContentTable(final Image3DUniverse univ) {
            this.getTableHeader().addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent me) {
                    if (2 != me.getClickCount()) {
                        return;
                    }
                    int viewColumn = this.getColumnModel().getColumnIndexAtX(me.getX());
                    int column = this.convertColumnIndexToModel(viewColumn);
                    if (-1 == column) {
                        return;
                    }
                    if (1 == column) {
                        ((ContentTableModel)this.getModel()).sortByName();
                    }
                }
            });
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent me) {
                    final int row = this.rowAtPoint(me.getPoint());
                    if (2 == me.getClickCount()) {
                        univ.select((Content)((ContentTableModel)this.getModel()).contents.get(row));
                    } else if (Utils.isPopupTrigger(me)) {
                        List data = ((ContentTableModel)this.getModel()).contents;
                        final ArrayList cs = new ArrayList();
                        for (int i : this.getSelectedRows()) {
                            cs.add(data.get(i));
                        }
                        JPopupMenu jp = new JPopupMenu();
                        JMenuItem item = new JMenuItem("Select in 3D view");
                        jp.add(item);
                        item.addActionListener(new ActionListener(){

                            @Override
                            public void actionPerformed(ActionEvent e) {
                                univ.select((Content)((ContentTableModel)this.getModel()).contents.get(row));
                            }
                        });
                        item = new JMenuItem("Select in TrakEM2");
                        jp.add(item);
                        item.addActionListener(new ActionListener(){

                            @Override
                            public void actionPerformed(ActionEvent e) {
                                Utils.log("Selecting in TrakEM2:");
                                Hashtable<LayerSet, Display3D> ht = Display3D.getMasterTable();
                                LayerSet ls = null;
                                for (Map.Entry<LayerSet, Display3D> entry : ht.entrySet()) {
                                    if (entry.getValue().getUniverse() != univ) continue;
                                    ls = entry.getKey();
                                    break;
                                }
                                if (null == ls) {
                                    Utils.log("Could not find an appropriate TrakEM2 project!");
                                    return;
                                }
                                Display front = Display.getFront();
                                if (front.getLayerSet() != ls) {
                                    for (Display display : Display.getDisplays()) {
                                        if (display.getLayerSet() != ls) continue;
                                        front = display;
                                        break;
                                    }
                                    if (front.getLayerSet() != ls) {
                                        Utils.log("Could not find an open display for the appropriate TrakEM2 project!");
                                        return;
                                    }
                                }
                                for (Content c : cs) {
                                    char ch;
                                    String name = c.getName();
                                    int start = name.lastIndexOf(35);
                                    if (-1 == start) {
                                        Utils.log("..skipped " + name);
                                        continue;
                                    }
                                    StringBuilder sb = new StringBuilder(10);
                                    ++start;
                                    while (start < name.length() && Character.isDigit(ch = name.charAt(start))) {
                                        sb.append(ch);
                                        ++start;
                                    }
                                    if (sb.length() > 0) {
                                        long id = Long.parseLong(sb.toString());
                                        DBObject dbo = ls.findById(id);
                                        if (null == dbo || !(dbo instanceof Displayable)) {
                                            Utils.log("Could not find an object with id #" + id);
                                            continue;
                                        }
                                        front.getSelection().add((Displayable)dbo);
                                        Utils.log("Selected: #" + id);
                                        continue;
                                    }
                                    Utils.log("..skipped " + name);
                                }
                            }
                        });
                        item = new JMenuItem("Remove from 3D view");
                        jp.add(item);
                        item.addActionListener(new ActionListener(){

                            @Override
                            public void actionPerformed(ActionEvent e) {
                                for (Content c : cs) {
                                    univ.removeContent(c.getName());
                                }
                            }
                        });
                        jp.show(this, me.getX(), me.getY());
                    }
                }
            });
        }

        @Override
        public String getToolTipText(MouseEvent me) {
            return ((Content)((ContentTableModel)this.getModel()).contents.get(this.rowAtPoint(me.getPoint()))).getName();
        }
    }

    private static final class ContentTableModel
    extends AbstractTableModel {
        private List<Content> contents;
        private final Image3DUniverse univ;
        private final JTextField regexField;

        public ContentTableModel(Image3DUniverse univ, JTextField regexField) {
            this.univ = univ;
            this.regexField = regexField;
            this.contents = new ArrayList<Content>(Display3DGUI.getOrderedContents(univ));
        }

        @Override
        public int getRowCount() {
            return this.contents.size();
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public String getColumnName(int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return "nth";
                }
                case 1: {
                    return "Name";
                }
            }
            return null;
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return false;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return rowIndex + 1;
                }
                case 1: {
                    return this.contents.get(rowIndex).getName();
                }
            }
            return null;
        }

        @Override
        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        }

        private void sortByName() {
            TreeMap<String, Content> m = new TreeMap<String, Content>();
            for (Content c : this.contents) {
                m.put(c.getName(), c);
            }
            this.contents = new ArrayList(m.values());
            this.fireTableDataChanged();
        }

        private void update(final ContentTable table) {
            Utils.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ArrayList<Content> cs = new ArrayList<Content>();
                    try {
                        RegExFilter f = new RegExFilter(regexField.getText());
                        for (Object ob : Display3DGUI.getOrderedContents(univ)) {
                            Content c = (Content)ob;
                            if (!f.accept(c.getName())) continue;
                            cs.add(c);
                        }
                    }
                    catch (PatternSyntaxException pse) {
                        JOptionPane.showMessageDialog((Component)univ.getWindow(), "Error parsing the regular expression:\n" + pse.getMessage());
                        cs.addAll(Display3DGUI.getOrderedContents(univ));
                    }
                    contents = cs;
                    this.fireTableDataChanged();
                    TableColumn tc = table.getColumnModel().getColumn(0);
                    Component label = table.getDefaultRenderer(this.getColumnClass(0)).getTableCellRendererComponent(table, cs.size() - 1, false, false, cs.size() - 1, 0);
                    tc.setMaxWidth(label.getBounds().width + 10);
                }
            });
        }
    }

    private static final class SliderTyperLink
    extends KeyAdapter {
        private final Image3DUniverse univ;
        private final JScrollBar slider;
        private final JTextField typer;

        SliderTyperLink(Image3DUniverse univ, JScrollBar slider, JTextField typer) {
            this.slider = slider;
            this.typer = typer;
            this.univ = univ;
        }

        @Override
        public void keyPressed(KeyEvent ke) {
            String txt = this.typer.getText();
            if (txt.length() > 0) {
                int val = Integer.parseInt(txt);
                this.slider.setValue(val);
                Content content = this.univ.getSelected();
                if (null != content) {
                    this.slider.setValue(val);
                }
            }
        }
    }
}

