/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.spim.registration.segmentation;

import mpicbg.spim.io.IOFunctions;
import mpicbg.spim.registration.ViewDataBeads;
import mpicbg.spim.registration.detection.AbstractDetection;
import mpicbg.spim.registration.detection.DetectionIdentification;
import mpicbg.spim.registration.segmentation.Nucleus;

public class NucleusIdentification
extends DetectionIdentification<NucleusIdentification, Nucleus> {
    public NucleusIdentification(Nucleus nucleus) {
        super(nucleus);
    }

    public NucleusIdentification(int detectionID, ViewDataBeads view) {
        super(detectionID, view);
    }

    public long getNucleusID() {
        return this.detectionID;
    }

    @Override
    public String toString() {
        return "NucleusIdentification of " + this.getDetection().toString();
    }

    public Nucleus getNucleus() {
        return this.getDetection();
    }

    @Override
    public Nucleus getDetection() {
        return this.getDetection(false);
    }

    public Nucleus getDetection(boolean silent) {
        AbstractDetection nucleus = null;
        if (this.detectionID < (long)this.view.getNucleiStructure().getDetectionList().size()) {
            nucleus = (Nucleus)((Object)this.view.getNucleiStructure().getDetectionList().get((int)this.detectionID));
        }
        if (nucleus == null || nucleus.getID() != this.detectionID) {
            nucleus = null;
            for (Nucleus n : this.view.getNucleiStructure().getDetectionList()) {
                if (n.getID() != this.detectionID) continue;
                nucleus = n;
            }
            if (nucleus == null && !silent) {
                IOFunctions.printErr("NucleusIdentification.getNucleus(): Cannot find a nucleus for nucleusID=" + this.detectionID + " in view=" + this.view.getID());
                return null;
            }
        }
        return nucleus;
    }
}

