/*
 * Decompiled with CFR 0.152.
 */
package spim.process.fusion.weightedavg;

import java.util.concurrent.Callable;
import net.imglib2.Cursor;
import net.imglib2.EuclideanSpace;
import net.imglib2.RandomAccessible;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.RealRandomAccess;
import net.imglib2.img.Img;
import net.imglib2.interpolation.InterpolatorFactory;
import net.imglib2.realtransform.AffineTransform3D;
import net.imglib2.type.numeric.RealType;
import net.imglib2.view.Views;
import spim.process.fusion.FusionHelper;
import spim.process.fusion.ImagePortion;
import spim.process.fusion.boundingbox.BoundingBoxGUI;

public class ProcessIndependentPortion<T extends RealType<T>>
implements Callable<String> {
    final ImagePortion portion;
    final RandomAccessibleInterval<T> img;
    final InterpolatorFactory<T, RandomAccessible<T>> interpolatorFactory;
    final AffineTransform3D transform;
    final Img<T> fusedImg;
    final BoundingBoxGUI bb;
    final boolean doDownSampling;
    final int downSampling;

    public ProcessIndependentPortion(ImagePortion portion, RandomAccessibleInterval<T> img, InterpolatorFactory<T, RandomAccessible<T>> interpolatorFactory, AffineTransform3D transform, Img<T> fusedImg, BoundingBoxGUI bb) {
        this.portion = portion;
        this.img = img;
        this.interpolatorFactory = interpolatorFactory;
        this.transform = transform;
        this.fusedImg = fusedImg;
        this.bb = bb;
        this.downSampling = bb.getDownSampling();
        this.doDownSampling = this.downSampling != 1;
    }

    @Override
    public String call() throws Exception {
        RealRandomAccess r = Views.interpolate((EuclideanSpace)Views.extendMirrorSingle(this.img), this.interpolatorFactory).realRandomAccess();
        int[] imgSize = new int[]{(int)this.img.dimension(0), (int)this.img.dimension(1), (int)this.img.dimension(2)};
        Cursor cursor = this.fusedImg.localizingCursor();
        float[] s = new float[3];
        float[] t = new float[3];
        cursor.jumpFwd(this.portion.getStartPosition());
        int j = 0;
        while ((long)j < this.portion.getLoopSize()) {
            RealType v = (RealType)cursor.next();
            cursor.localize(s);
            if (this.doDownSampling) {
                s[0] = s[0] * (float)this.downSampling;
                s[1] = s[1] * (float)this.downSampling;
                s[2] = s[2] * (float)this.downSampling;
            }
            s[0] = s[0] + (float)this.bb.min(0);
            s[1] = s[1] + (float)this.bb.min(1);
            s[2] = s[2] + (float)this.bb.min(2);
            this.transform.applyInverse(t, s);
            if (FusionHelper.intersects(t[0], t[1], t[2], imgSize[0], imgSize[1], imgSize[2])) {
                r.setPosition(t);
                v.setReal(((RealType)r.get()).getRealFloat());
            }
            ++j;
        }
        return this.portion + " finished successfully (individual fusion, no weights).";
    }
}

