/*
 * Decompiled with CFR 0.152.
 */
package util;

import amira.AmiraParameters;
import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.Macro;
import ij.plugin.PlugIn;
import java.io.File;
import java.io.FilenameFilter;
import util.BatchOpener;
import util.LabelFilenameFilter;

public class Count_Labels
implements PlugIn {
    public void run(String ignore) {
        String macroOptions = Macro.getOptions();
        String sourceDirectory = null;
        if (macroOptions == null) {
            IJ.error((String)"Currently this can only be called as macro with options.");
            return;
        }
        sourceDirectory = Macro.getValue((String)macroOptions, (String)"source", null);
        if (sourceDirectory == null) {
            IJ.error((String)"No source directory specified. (Macro option 'source'.)");
            return;
        }
        File sourceDirectoryAsFile = new File(sourceDirectory);
        if (!sourceDirectoryAsFile.exists() || !sourceDirectoryAsFile.isDirectory()) {
            IJ.error((String)("The source (" + sourceDirectory + ") must both exist and be a directory. "));
            return;
        }
        LabelFilenameFilter filter = new LabelFilenameFilter(null);
        File[] possibleSourceFiles = sourceDirectoryAsFile.listFiles((FilenameFilter)filter);
        for (int i = 0; i < possibleSourceFiles.length; ++i) {
            boolean[] someOfThisRegion = new boolean[256];
            File currentFile = possibleSourceFiles[i];
            String path = currentFile.getAbsolutePath();
            String leafName = currentFile.getName();
            ImagePlus[] channels = BatchOpener.open((String)path);
            if (channels == null) {
                IJ.error((String)("Opening '" + path + "' failed."));
                return;
            }
            if (channels.length != 1) {
                IJ.error((String)("The labels file must only have one channel: there are " + channels.length + " in '" + path));
                return;
            }
            ImagePlus labelsImagePlus = channels[0];
            int type = labelsImagePlus.getType();
            if (type != 0 && type != 3) {
                IJ.error((String)("Something's wrong: '" + path + "' doesn't seem to be an 8 bit file."));
                return;
            }
            if (!AmiraParameters.isAmiraLabelfield((ImagePlus)labelsImagePlus)) {
                IJ.error((String)("The file '" + path + "' isn't an Amira labelfield!"));
                return;
            }
            int width = labelsImagePlus.getWidth();
            int height = labelsImagePlus.getHeight();
            int depth = labelsImagePlus.getStackSize();
            ImageStack stack = labelsImagePlus.getStack();
            for (int z = 0; z < depth; ++z) {
                byte[] pixels = (byte[])stack.getPixels(z + 1);
                for (int p = 0; p < width * height; ++p) {
                    int value = pixels[p] & 0xFF;
                    someOfThisRegion[value] = true;
                }
            }
            int count = 0;
            for (int m = 0; m < 256; ++m) {
                if (!someOfThisRegion[m]) continue;
                ++count;
            }
            System.out.println("" + count + " - " + leafName);
            labelsImagePlus.close();
        }
    }
}

