/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.ij.integral;

import ij.process.ByteProcessor;
import ij.process.ColorProcessor;
import ij.process.FloatProcessor;
import ij.process.ImageProcessor;
import ij.process.ShortProcessor;
import mpicbg.ij.integral.DoubleIntegralImage;
import mpicbg.ij.integral.IntegralImage;
import mpicbg.ij.integral.LongIntegralImage;
import mpicbg.ij.integral.LongRGBIntegralImage;

public final class Scale {
    private final IntegralImage integral;
    private final ImageProcessor ip;

    public Scale(ColorProcessor ip) {
        this.ip = ip;
        this.integral = new LongRGBIntegralImage(ip);
    }

    public Scale(ByteProcessor ip) {
        this.ip = ip;
        this.integral = new LongIntegralImage((ImageProcessor)ip);
    }

    public Scale(ShortProcessor ip) {
        this.ip = ip;
        this.integral = new LongIntegralImage((ImageProcessor)ip);
    }

    public Scale(FloatProcessor ip) {
        this.ip = ip;
        this.integral = new DoubleIntegralImage(ip);
    }

    private static final int round(double a) {
        return (int)(a + Math.signum(a) * 0.5);
    }

    public final ImageProcessor scale(int width, int height) {
        int w = width - 1;
        int h = height - 1;
        int ww = this.ip.getWidth() - 1;
        int hh = this.ip.getHeight() - 1;
        ImageProcessor target = this.ip.createProcessor(width, height);
        double pixelWidth = (double)this.ip.getWidth() / (double)width;
        double pixelHeight = (double)this.ip.getHeight() / (double)height;
        for (int y = 0; y < height; ++y) {
            int yi = width * Math.min(h, Math.max(0, y));
            double yMinDouble = (double)y * pixelHeight;
            int yMin = Math.min(hh, Math.max(-1, Scale.round(yMinDouble) - 1));
            int yMax = Math.max(-1, Math.min(hh, Scale.round(yMinDouble + pixelHeight - 1.0)));
            int bh = yMax - yMin;
            for (int x = 0; x < width; ++x) {
                int xi = Math.min(w, Math.max(0, x));
                double xMinDouble = (double)x * pixelWidth;
                int xMin = Math.min(ww, Math.max(-1, Scale.round(xMinDouble) - 1));
                int xMax = Math.min(ww, Math.max(-1, Scale.round(xMinDouble + pixelWidth - 1.0)));
                float scale = 1.0f / (float)(xMax - xMin) / (float)bh;
                target.set(yi + xi, this.integral.getScaledSum(xMin, yMin, xMax, yMax, scale));
            }
        }
        return target;
    }

    public final ImageProcessor scale(double scale) {
        int width = Scale.round((double)this.ip.getWidth() * scale);
        int height = Scale.round((double)this.ip.getHeight() * scale);
        return this.scale(width, height);
    }

    public static final Scale create(ImageProcessor ip) {
        if (FloatProcessor.class.isInstance(ip)) {
            return new Scale((FloatProcessor)ip);
        }
        if (ByteProcessor.class.isInstance(ip)) {
            return new Scale((ByteProcessor)ip);
        }
        if (ShortProcessor.class.isInstance(ip)) {
            return new Scale((ShortProcessor)ip);
        }
        if (ColorProcessor.class.isInstance(ip)) {
            return new Scale((ColorProcessor)ip);
        }
        return null;
    }
}

