/*
 * Decompiled with CFR 0.152.
 */
package stitching.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Random;
import stitching.model.CoordinateTransform;
import stitching.model.ErrorStatistic;
import stitching.model.NotEnoughDataPointsException;
import stitching.model.PointMatch;
import stitching.utils.Log;

public abstract class Model
implements CoordinateTransform {
    protected static final Random rnd = new Random(69997L);
    protected double cost = Double.MAX_VALUE;

    public abstract int getMinSetSize();

    public final double getCost() {
        return this.cost;
    }

    public final void setCost(double c) {
        this.cost = c;
    }

    @Deprecated
    public final double getError() {
        return this.getCost();
    }

    @Deprecated
    public final void setError(double e) {
        this.setCost(e);
    }

    public boolean betterThan(Model m) {
        if (this.cost < 0.0) {
            return false;
        }
        return this.cost < m.cost;
    }

    public abstract void shake(Collection<PointMatch> var1, float var2, float[] var3);

    public abstract void fit(Collection<PointMatch> var1) throws NotEnoughDataPointsException;

    public static final boolean test(Model model, Collection<PointMatch> candidates, Collection<PointMatch> inliers, double epsilon, double min_inlier_ratio) {
        inliers.clear();
        for (PointMatch m : candidates) {
            m.apply(model);
            if (!((double)m.getDistance() < epsilon)) continue;
            inliers.add(m);
        }
        float ir = (float)inliers.size() / (float)candidates.size();
        model.cost = Math.max(0.0, Math.min(1.0, 1.0 - (double)ir));
        return (double)ir > min_inlier_ratio;
    }

    public static final <M extends Model> M filter(Class<M> modelClass, Collection<PointMatch> candidates, Collection<PointMatch> inliers) throws NotEnoughDataPointsException {
        int num_inliers;
        Model model;
        try {
            model = (Model)modelClass.newInstance();
        }
        catch (Exception e) {
            Log.error(e);
            return null;
        }
        inliers.clear();
        inliers.addAll(candidates);
        ArrayList<PointMatch> temp = new ArrayList<PointMatch>();
        do {
            temp.clear();
            temp.addAll(inliers);
            num_inliers = inliers.size();
            model.fit(inliers);
            ErrorStatistic observer = new ErrorStatistic();
            for (PointMatch m : temp) {
                m.apply(model);
                observer.add(m.getDistance());
            }
            inliers.clear();
            double t = observer.median * 4.0;
            for (PointMatch m : temp) {
                if (!((double)m.getDistance() < t)) continue;
                inliers.add(m);
            }
            model.cost = observer.mean;
        } while (num_inliers > inliers.size());
        if (num_inliers < model.getMinSetSize()) {
            return null;
        }
        return (M)model;
    }

    public static final <M extends Model> M ransac(Class<M> modelClass, List<PointMatch> candidates, Collection<PointMatch> inliers, int iterations, double epsilon, double min_inlier_ratio) throws NotEnoughDataPointsException {
        Model model;
        try {
            model = (Model)modelClass.newInstance();
        }
        catch (Exception e) {
            Log.error(e);
            return null;
        }
        int MIN_SET_SIZE = model.getMinSetSize();
        inliers.clear();
        if (candidates.size() < MIN_SET_SIZE) {
            throw new NotEnoughDataPointsException(candidates.size() + " correspondences are not enough to estimate a model, at least " + MIN_SET_SIZE + " correspondences required.");
        }
        ArrayList<PointMatch> min_matches = new ArrayList<PointMatch>();
        for (int i = 0; i < iterations; ++i) {
            Model m;
            min_matches.clear();
            for (int j = 0; j < MIN_SET_SIZE; ++j) {
                PointMatch p;
                while (min_matches.contains(p = candidates.get((int)(rnd.nextDouble() * (double)candidates.size())))) {
                }
                min_matches.add(p);
            }
            try {
                m = (Model)modelClass.newInstance();
            }
            catch (Exception e) {
                Log.error(e);
                return null;
            }
            ArrayList<PointMatch> temp_inliers = new ArrayList<PointMatch>();
            m.fit(min_matches);
            int num_inliers = 0;
            boolean is_good = Model.test(m, candidates, temp_inliers, epsilon, min_inlier_ratio);
            while (is_good && num_inliers < temp_inliers.size()) {
                num_inliers = temp_inliers.size();
                m.fit(temp_inliers);
                is_good = Model.test(m, candidates, temp_inliers, epsilon, min_inlier_ratio);
            }
            if (!is_good || !m.betterThan(model) || temp_inliers.size() < 3 * MIN_SET_SIZE) continue;
            model = m;
            inliers.clear();
            inliers.addAll(temp_inliers);
        }
        if (inliers.size() == 0) {
            return null;
        }
        return (M)model;
    }

    public static <M extends Model> M filterRansac(Class<M> modelType, List<PointMatch> candidates, Collection<PointMatch> inliers, int iterations, float max_epsilon, float min_inlier_ratio) throws NotEnoughDataPointsException {
        ArrayList<PointMatch> temp = new ArrayList<PointMatch>();
        Model.ransac(modelType, candidates, temp, iterations, max_epsilon, min_inlier_ratio);
        return Model.filter(modelType, temp, inliers);
    }

    public abstract String toString();

    public abstract Model clone();
}

