/*
 * Decompiled with CFR 0.152.
 */
package org.janelia.saalfeldlab.n5.universe.metadata.transforms;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import org.janelia.saalfeldlab.n5.N5Reader;
import org.janelia.saalfeldlab.n5.universe.metadata.transforms.AffineSpatialTransform;
import org.janelia.saalfeldlab.n5.universe.metadata.transforms.IdentitySpatialTransform;
import org.janelia.saalfeldlab.n5.universe.metadata.transforms.ParametrizedTransform;
import org.janelia.saalfeldlab.n5.universe.metadata.transforms.ScaleOffsetSpatialTransform;
import org.janelia.saalfeldlab.n5.universe.metadata.transforms.ScaleSpatialTransform;
import org.janelia.saalfeldlab.n5.universe.metadata.transforms.SequenceSpatialTransform;
import org.janelia.saalfeldlab.n5.universe.metadata.transforms.SpatialTransform;
import org.janelia.saalfeldlab.n5.universe.metadata.transforms.TranslationSpatialTransform;

public class SpatialTransformAdapter
implements JsonDeserializer<SpatialTransform>,
JsonSerializer<SpatialTransform> {
    final N5Reader n5;

    public SpatialTransformAdapter(N5Reader n5) {
        this.n5 = n5;
    }

    public SpatialTransform deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        if (!json.isJsonObject()) {
            return null;
        }
        JsonObject jobj = json.getAsJsonObject();
        if (!jobj.has("type")) {
            return null;
        }
        SpatialTransform out = null;
        switch (jobj.get("type").getAsString()) {
            case "identity": {
                out = (SpatialTransform)context.deserialize((JsonElement)jobj, IdentitySpatialTransform.class);
                break;
            }
            case "scale": {
                out = (SpatialTransform)context.deserialize((JsonElement)jobj, ScaleSpatialTransform.class);
                break;
            }
            case "translation": {
                out = (SpatialTransform)context.deserialize((JsonElement)jobj, TranslationSpatialTransform.class);
                break;
            }
            case "scale_offset": {
                out = (SpatialTransform)context.deserialize((JsonElement)jobj, ScaleOffsetSpatialTransform.class);
                break;
            }
            case "affine": {
                out = (SpatialTransform)context.deserialize((JsonElement)jobj, AffineSpatialTransform.class);
                break;
            }
            case "sequence": {
                out = (SpatialTransform)context.deserialize((JsonElement)jobj, SequenceSpatialTransform.class);
            }
        }
        return out;
    }

    private final SpatialTransform readTransformParameters(SpatialTransform transform) {
        ParametrizedTransform pt;
        if (transform instanceof ParametrizedTransform && (pt = (ParametrizedTransform)((Object)transform)).getParameterPath() != null) {
            pt.buildTransform(pt.getParameters(this.n5));
        }
        return transform;
    }

    public JsonElement serialize(SpatialTransform src, Type typeOfSrc, JsonSerializationContext context) {
        return context.serialize((Object)src);
    }

    public static void main(String[] args) {
        String affineString = "{\"type\": \"affine\",\"affine\" : [ 11.0, 0.0, 0.1, 0.0, 12.0, 0.2 ]}";
        String scaleString = "{\"type\": \"scale\",\"scale\" : [ 11.0, -8.0 ]}";
        String translationString = "{\"type\": \"translation\",\"translation\" : [ -0.9, 2.1 ]}";
        String idString = "{\"type\": \"identity\"}";
        String seqString = "{\"type\": \"sequence\",\"transformations\": [{\"type\": \"scale\",\"scale\" : [ 11.0, -8.0 ]},{\"type\": \"translation\",\"translation\" : [ -0.9, 2.1 ]}]}";
        SpatialTransformAdapter adapter = new SpatialTransformAdapter(null);
        GsonBuilder gsonBuilder = new GsonBuilder();
        gsonBuilder.registerTypeAdapter(SpatialTransform.class, (Object)adapter);
        gsonBuilder.disableHtmlEscaping();
        Gson gson = gsonBuilder.create();
        SpatialTransform parsedAffine = (SpatialTransform)gson.fromJson("{\"type\": \"affine\",\"affine\" : [ 11.0, 0.0, 0.1, 0.0, 12.0, 0.2 ]}", SpatialTransform.class);
        System.out.println("{\"type\": \"affine\",\"affine\" : [ 11.0, 0.0, 0.1, 0.0, 12.0, 0.2 ]}");
        System.out.println(parsedAffine);
        System.out.println(gson.toJson((Object)parsedAffine));
        System.out.println(" ");
        SpatialTransform parsedScale = (SpatialTransform)gson.fromJson("{\"type\": \"scale\",\"scale\" : [ 11.0, -8.0 ]}", SpatialTransform.class);
        System.out.println("{\"type\": \"scale\",\"scale\" : [ 11.0, -8.0 ]}");
        System.out.println(parsedScale);
        System.out.println(gson.toJson((Object)parsedScale));
        System.out.println(" ");
        SpatialTransform parsedTranslation = (SpatialTransform)gson.fromJson("{\"type\": \"translation\",\"translation\" : [ -0.9, 2.1 ]}", SpatialTransform.class);
        System.out.println("{\"type\": \"translation\",\"translation\" : [ -0.9, 2.1 ]}");
        System.out.println(parsedTranslation);
        System.out.println(gson.toJson((Object)parsedTranslation));
        System.out.println(" ");
        SpatialTransform parsedId = (SpatialTransform)gson.fromJson("{\"type\": \"identity\"}", SpatialTransform.class);
        System.out.println("{\"type\": \"identity\"}");
        System.out.println(parsedId);
        System.out.println(gson.toJson((Object)parsedId));
        System.out.println(" ");
        SpatialTransform parsedSeq = (SpatialTransform)gson.fromJson("{\"type\": \"sequence\",\"transformations\": [{\"type\": \"scale\",\"scale\" : [ 11.0, -8.0 ]},{\"type\": \"translation\",\"translation\" : [ -0.9, 2.1 ]}]}", SpatialTransform.class);
        System.out.println("{\"type\": \"sequence\",\"transformations\": [{\"type\": \"scale\",\"scale\" : [ 11.0, -8.0 ]},{\"type\": \"translation\",\"translation\" : [ -0.9, 2.1 ]}]}");
        System.out.println(parsedSeq);
        System.out.println(gson.toJson((Object)parsedSeq));
        System.out.println(" ");
        ScaleSpatialTransform s = new ScaleSpatialTransform(new double[]{1.0, 2.0});
        TranslationSpatialTransform t = new TranslationSpatialTransform(new double[]{3.0, 4.0});
        SequenceSpatialTransform seq = new SequenceSpatialTransform(new SpatialTransform[]{s, t});
        System.out.println(gson.toJson((Object)seq));
    }
}

