/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.plugins.commands.assign;

import net.imagej.Dataset;
import net.imagej.Position;
import net.imagej.axis.Axes;
import net.imagej.display.DatasetView;
import net.imagej.display.ImageDisplay;
import net.imagej.display.ImageDisplayService;
import net.imagej.display.OverlayService;
import net.imagej.overlay.Overlay;
import net.imagej.plugins.commands.assign.InplaceUnaryTransform;
import net.imglib2.RandomAccess;
import net.imglib2.img.Img;
import net.imglib2.img.array.ArrayImgFactory;
import net.imglib2.ops.operation.complex.unary.ComplexUnaryOperation;
import net.imglib2.ops.pointset.HyperVolumePointSet;
import net.imglib2.ops.pointset.PointSet;
import net.imglib2.ops.pointset.PointSetIterator;
import net.imglib2.type.NativeType;
import net.imglib2.type.numeric.ComplexType;
import net.imglib2.type.numeric.RealType;
import net.imglib2.type.numeric.real.DoubleType;
import org.scijava.ItemIO;
import org.scijava.command.ContextCommand;
import org.scijava.command.Previewable;
import org.scijava.plugin.Parameter;

public abstract class MathCommand<I extends ComplexType<I>, O extends ComplexType<O>>
extends ContextCommand
implements Previewable {
    @Parameter
    protected ImageDisplayService displayService;
    @Parameter
    protected OverlayService overlayService;
    @Parameter(type=ItemIO.BOTH)
    protected ImageDisplay display;
    @Parameter(label="Preview")
    protected boolean preview;
    @Parameter(label="Apply to all planes")
    protected boolean allPlanes;
    private O outType;
    private Img<DoubleType> dataBackup;
    private PointSetIterator iter;
    private RandomAccess<? extends RealType<?>> dataAccess;
    private RandomAccess<? extends RealType<?>> backupAccess;
    private Dataset dataset;
    private Overlay overlay;
    private Position planePos;

    public MathCommand(O outType) {
        this.outType = outType;
    }

    public void run() {
        if (this.dataset == null) {
            this.initialize();
        } else if (this.preview) {
            this.restorePreviewRegion();
        }
        this.transformFullRegion();
    }

    public void preview() {
        if (this.dataset == null) {
            this.initialize();
            this.savePreviewRegion();
        } else {
            this.restorePreviewRegion();
        }
        if (this.preview) {
            this.transformPreviewRegion();
        }
    }

    public void cancel() {
        if (this.preview) {
            this.restorePreviewRegion();
        }
    }

    public ImageDisplay getDisplay() {
        return this.display;
    }

    public void setDisplay(ImageDisplay display) {
        this.display = display;
    }

    public boolean getPreview() {
        return this.preview;
    }

    public void setPreview(boolean preview) {
        this.preview = preview;
    }

    public abstract ComplexUnaryOperation<O, O> getOperation();

    private void initialize() {
        long h;
        this.dataset = this.displayService.getActiveDataset(this.display);
        this.overlay = this.overlayService.getActiveOverlay(this.display);
        DatasetView view = this.displayService.getActiveDatasetView(this.display);
        this.planePos = view.getPlanePosition();
        InplaceUnaryTransform<I, O> xform = this.getPreviewTransform(this.dataset, this.overlay);
        PointSet region = this.determineRegion(this.dataset, xform.getRegionOrigin(), xform.getRegionSpan());
        this.iter = region.iterator();
        ArrayImgFactory factory = new ArrayImgFactory();
        this.dataBackup = factory.create(new long[]{region.size()}, (NativeType)new DoubleType());
        this.backupAccess = this.dataBackup.randomAccess();
        this.dataAccess = this.dataset.getImgPlus().randomAccess();
        long w = xform.getRegionSpan()[0];
        if (w * (h = xform.getRegionSpan()[1]) > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("preview region too large to copy into memory");
        }
    }

    private InplaceUnaryTransform<I, O> getPreviewTransform(Dataset ds, Overlay ov) {
        return new InplaceUnaryTransform(this.getOperation(), this.outType, ds, ov, this.planePos);
    }

    private InplaceUnaryTransform<I, O> getFinalTransform(Dataset ds, Overlay ov) {
        if (this.allPlanes) {
            return new InplaceUnaryTransform(this.getOperation(), this.outType, ds, ov);
        }
        return this.getPreviewTransform(ds, ov);
    }

    private PointSet determineRegion(Dataset ds, long[] planeOrigin, long[] planeSpan) {
        long[] origin = (long[])planeOrigin.clone();
        long[] offsets = (long[])planeSpan.clone();
        if (ds.isRGBMerged()) {
            int chIndex = ds.dimensionIndex(Axes.CHANNEL);
            origin[chIndex] = 0L;
            offsets[chIndex] = 3L;
        }
        int i = 0;
        while (i < offsets.length) {
            int n = i++;
            offsets[n] = offsets[n] - 1L;
        }
        return new HyperVolumePointSet(origin, new long[origin.length], offsets);
    }

    private void savePreviewRegion() {
        this.iter.reset();
        long pos = 0L;
        while (this.iter.hasNext()) {
            this.dataAccess.setPosition((long[])this.iter.next());
            double value = ((RealType)this.dataAccess.get()).getRealDouble();
            this.backupAccess.setPosition(pos++, 0);
            ((RealType)this.backupAccess.get()).setReal(value);
        }
    }

    private void restorePreviewRegion() {
        this.iter.reset();
        long pos = 0L;
        while (this.iter.hasNext()) {
            this.backupAccess.setPosition(pos++, 0);
            double value = ((RealType)this.backupAccess.get()).getRealDouble();
            this.dataAccess.setPosition((long[])this.iter.next());
            ((RealType)this.dataAccess.get()).setReal(value);
        }
        this.dataset.update();
    }

    private void transformFullRegion() {
        this.getFinalTransform(this.dataset, this.overlay).run();
    }

    private void transformPreviewRegion() {
        this.getPreviewTransform(this.dataset, this.overlay).run();
    }
}

