/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.io;

import java.io.IOException;
import java.net.URISyntaxException;
import org.scijava.io.location.Location;
import org.scijava.io.location.LocationService;
import org.scijava.plugin.HandlerPlugin;

public interface IOPlugin<D>
extends HandlerPlugin<Location> {
    public Class<D> getDataType();

    default public boolean supportsOpen(String source) {
        try {
            return this.supportsOpen(this.context().service(LocationService.class).resolve(source));
        }
        catch (URISyntaxException exc) {
            return false;
        }
    }

    default public boolean supportsOpen(Location source) {
        return false;
    }

    default public boolean supportsSave(String destination) {
        try {
            return this.supportsSave(this.context().service(LocationService.class).resolve(destination));
        }
        catch (URISyntaxException exc) {
            return false;
        }
    }

    default public boolean supportsSave(Location destination) {
        return false;
    }

    default public boolean supportsSave(Object data, String destination) {
        return this.supportsSave(destination) && this.getDataType().isInstance(data);
    }

    default public boolean supportsSave(Object data, Location destination) {
        return this.supportsSave(destination) && this.getDataType().isInstance(data);
    }

    default public D open(String source) throws IOException {
        throw new UnsupportedOperationException();
    }

    default public D open(Location source) throws IOException {
        throw new UnsupportedOperationException();
    }

    default public void save(D data, String destination) throws IOException {
        try {
            this.save(data, this.context().service(LocationService.class).resolve(destination));
        }
        catch (URISyntaxException exc) {
            throw new UnsupportedOperationException(exc);
        }
    }

    default public void save(D data, Location destination) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    default public boolean supports(String descriptor) {
        return this.supportsOpen(descriptor) || this.supportsSave(descriptor);
    }

    @Override
    default public Class<Location> getType() {
        return Location.class;
    }
}

