/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.io.handle;

import java.io.EOFException;
import java.io.IOException;
import org.scijava.io.handle.AbstractHigherOrderHandle;
import org.scijava.io.handle.DataHandle;
import org.scijava.io.handle.DataHandles;
import org.scijava.io.location.Location;

public class WriteBufferDataHandle
extends AbstractHigherOrderHandle<Location> {
    private static final int DEFAULT_BUFFERSIZE = 10000;
    private long offset = 0L;
    private int nextPos = 0;
    private byte[] buffer;
    private final int bufferSize;

    public WriteBufferDataHandle(DataHandle<Location> handle) {
        this(handle, 10000);
    }

    public WriteBufferDataHandle(DataHandle<Location> handle, int bufferSize) {
        super(handle);
        this.bufferSize = bufferSize;
    }

    @Override
    public void write(int b) throws IOException {
        this.ensureOpen();
        if (this.nextPos >= this.buffer.length) {
            this.flush();
        }
        this.buffer[this.nextPos] = (byte)b;
        ++this.nextPos;
        ++this.offset;
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.ensureOpen();
        if (off < 0 || off > b.length || len < 0 || off + len > b.length || off + len < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return;
        }
        if (len > this.buffer.length) {
            this.flush();
            this.handle().write(b, off, len);
            this.offset += (long)len;
            return;
        }
        int start = off;
        int total = off + len;
        while (start < total) {
            int numItems = Math.min(this.buffer.length - this.nextPos, total - start);
            System.arraycopy(b, start, this.buffer, this.nextPos, numItems);
            start += numItems;
            this.nextPos += numItems;
            if (this.nextPos < this.buffer.length) continue;
            this.flush();
        }
    }

    private void flush() throws IOException {
        this.ensureOpen();
        if (this.nextPos == 0) {
            return;
        }
        this.handle().write(this.buffer, 0, this.nextPos);
        this.nextPos = 0;
    }

    @Override
    public long length() throws IOException {
        return this.handle().length() + (long)this.nextPos - 1L;
    }

    @Override
    public void setLength(long length) throws IOException {
        this.ensureOpen();
        this.handle().setLength(length);
    }

    @Override
    public boolean isReadable() {
        return false;
    }

    @Override
    protected void ensureOpen() throws IOException {
        super.ensureOpen();
        if (this.buffer == null) {
            this.buffer = new byte[this.bufferSize];
        }
    }

    @Override
    public long offset() throws IOException {
        return this.offset;
    }

    @Override
    public void seek(long pos) throws IOException {
        this.ensureOpen();
        if (pos >= this.length()) {
            throw new EOFException();
        }
        this.flush();
        this.offset = pos;
        this.handle().seek(this.offset);
    }

    @Override
    public long skip(long n) throws IOException {
        throw new IOException("Operation 'skip' is not supported!");
    }

    @Override
    public byte readByte() throws IOException {
        throw DataHandles.writeOnlyException();
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        throw DataHandles.writeOnlyException();
    }

    @Override
    protected void cleanup() throws IOException {
        this.flush();
        this.buffer = null;
    }
}

