/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ui.swing.mdi;

import java.util.HashMap;
import java.util.Map;
import javax.swing.JInternalFrame;
import javax.swing.JOptionPane;
import org.scijava.ui.DialogPrompt;
import org.scijava.ui.UserInterface;
import org.scijava.ui.swing.SwingApplicationFrame;
import org.scijava.ui.swing.mdi.JMDIDesktopPane;
import org.scijava.ui.swing.mdi.ModalInternalFrame;

public class SwingMdiDialogPrompt
implements DialogPrompt {
    JInternalFrame dialog;
    JOptionPane pane;
    static final Map<DialogPrompt.MessageType, Integer> msgMap = new HashMap<DialogPrompt.MessageType, Integer>();
    static final Map<DialogPrompt.OptionType, Integer> optionMap = new HashMap<DialogPrompt.OptionType, Integer>();
    static final Map<Integer, DialogPrompt.Result> resultMap = new HashMap<Integer, DialogPrompt.Result>();

    public SwingMdiDialogPrompt(UserInterface ui, String message, String title, DialogPrompt.MessageType messageType, DialogPrompt.OptionType optionType) {
        SwingApplicationFrame appFrame = (SwingApplicationFrame)ui.getApplicationFrame();
        JMDIDesktopPane desk = (JMDIDesktopPane)ui.getDesktop();
        this.pane = new JOptionPane(message, msgMap.get(messageType), optionMap.get(optionType));
        this.dialog = new ModalInternalFrame(title, appFrame.getRootPane(), desk, this.pane);
    }

    public DialogPrompt.Result prompt() {
        this.dialog.setVisible(true);
        Object value = this.pane.getValue();
        this.dialog.dispose();
        return resultMap.get(value);
    }

    static {
        msgMap.put(DialogPrompt.MessageType.ERROR_MESSAGE, 0);
        msgMap.put(DialogPrompt.MessageType.INFORMATION_MESSAGE, 1);
        msgMap.put(DialogPrompt.MessageType.PLAIN_MESSAGE, -1);
        msgMap.put(DialogPrompt.MessageType.WARNING_MESSAGE, 2);
        msgMap.put(DialogPrompt.MessageType.QUESTION_MESSAGE, 3);
        optionMap.put(DialogPrompt.OptionType.DEFAULT_OPTION, -1);
        optionMap.put(DialogPrompt.OptionType.OK_CANCEL_OPTION, 2);
        optionMap.put(DialogPrompt.OptionType.YES_NO_CANCEL_OPTION, 1);
        optionMap.put(DialogPrompt.OptionType.YES_NO_OPTION, 0);
        resultMap.put(2, DialogPrompt.Result.CANCEL_OPTION);
        resultMap.put(-1, DialogPrompt.Result.CLOSED_OPTION);
        resultMap.put(1, DialogPrompt.Result.NO_OPTION);
        resultMap.put(0, DialogPrompt.Result.OK_OPTION);
        resultMap.put(0, DialogPrompt.Result.YES_OPTION);
    }
}

