/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.algorithm.stats;

import net.imglib2.algorithm.stats.HistogramBinMapper;
import net.imglib2.type.numeric.RealType;

public class RealBinMapper<T extends RealType<T>>
implements HistogramBinMapper<T> {
    private final int numBins;
    private final T minBin;
    private final T maxBin;
    private final double binWidth;
    private final double halfBinWidth;
    private final double minVal;

    public RealBinMapper(T minBin, T maxBin, int numBins) {
        this.numBins = numBins;
        this.minBin = minBin;
        this.maxBin = maxBin;
        this.binWidth = (1.0 + maxBin.getRealDouble() - minBin.getRealDouble()) / (double)numBins;
        this.halfBinWidth = this.binWidth / 2.0;
        this.minVal = minBin.getRealDouble();
    }

    @Override
    public T getMaxBin() {
        return this.maxBin;
    }

    @Override
    public T getMinBin() {
        return this.minBin;
    }

    @Override
    public int getNumBins() {
        return this.numBins;
    }

    @Override
    public T invMap(int i) {
        RealType out = (RealType)this.minBin.createVariable();
        double t = i;
        t *= this.binWidth;
        out.setReal(t += this.minVal);
        return (T)out;
    }

    @Override
    public int map(T type) {
        double tVal = type.getRealDouble();
        tVal -= this.minVal;
        tVal += this.halfBinWidth;
        return (int)(tVal /= this.binWidth);
    }

    public double getBinWidth() {
        return this.binWidth;
    }
}

