/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.algorithm.util.unionfind;

import java.util.function.LongUnaryOperator;
import java.util.function.ToLongBiFunction;
import net.imglib2.Localizable;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.RealCursor;
import net.imglib2.type.BooleanType;
import net.imglib2.type.numeric.IntegerType;
import net.imglib2.view.Views;

public interface UnionFind {
    public long findRoot(long var1);

    public long join(long var1, long var3);

    public long size();

    public long setCount();

    public static <B extends BooleanType<B>, L extends IntegerType<L>> void relabel(RandomAccessibleInterval<B> mask, RandomAccessibleInterval<L> labeling, UnionFind unionFind, ToLongBiFunction<Localizable, L> idForPixel, LongUnaryOperator idForSet) {
        RealCursor label = Views.flatIterable(labeling).localizingCursor();
        RealCursor maskCursor = Views.flatIterable(Views.interval(mask, labeling)).cursor();
        while (label.hasNext()) {
            BooleanType m = (BooleanType)maskCursor.next();
            label.fwd();
            if (!m.get()) continue;
            IntegerType l = (IntegerType)label.get();
            long root = unionFind.findRoot(idForPixel.applyAsLong((Localizable)((Object)label), l));
            l.setInteger(idForSet.applyAsLong(root));
        }
    }

    default public <B extends BooleanType<B>, L extends IntegerType<L>> void relabel(RandomAccessibleInterval<L> labeling, ToLongBiFunction<Localizable, L> idForPixel, LongUnaryOperator idForSet) {
        RealCursor label = Views.flatIterable(labeling).localizingCursor();
        while (label.hasNext()) {
            IntegerType l = (IntegerType)label.next();
            long root = this.findRoot(idForPixel.applyAsLong((Localizable)((Object)label), l));
            l.setInteger(idForSet.applyAsLong(root));
        }
    }

    default public <L extends IntegerType<L>> void relabel(RandomAccessibleInterval<L> labeling) {
        RealCursor label = Views.flatIterable(labeling).localizingCursor();
        while (label.hasNext()) {
            IntegerType l = (IntegerType)label.next();
            long root = this.findRoot(l.getIntegerLong());
            l.setInteger(root);
        }
    }
}

