/*
 * Decompiled with CFR 0.152.
 */
package sc.fiji.io;

import ij.IJ;
import ij.ImagePlus;
import ij.WindowManager;
import ij.io.FileInfo;
import ij.io.SaveDialog;
import ij.plugin.PlugIn;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import sc.fiji.io.DeflateExtendedFileSaver;

public final class MetaImage_CWriter
implements PlugIn {
    public void run(String arg) {
        ImagePlus imp = WindowManager.getCurrentImage();
        if (imp == null) {
            IJ.noImage();
            return;
        }
        if (imp.getCalibration().isSigned16Bit() && IJ.versionLessThan((String)"1.34e")) {
            IJ.error((String)"MetaImage Reader: Please upgrade to ImageJ v1.34e or later.");
            return;
        }
        String dir = "";
        String baseName = "";
        if (arg == null || arg.length() == 0) {
            SaveDialog sd = new SaveDialog("Save as compressed MetaImage", imp.getTitle(), "");
            dir = sd.getDirectory();
            baseName = sd.getFileName();
        } else {
            File file = new File(arg);
            if (file.isDirectory()) {
                dir = arg;
                baseName = imp.getTitle();
            } else {
                dir = file.getParent();
                baseName = file.getName();
            }
        }
        if (baseName == null || baseName.length() == 0) {
            return;
        }
        this.save(imp, dir, baseName);
        IJ.showStatus((String)(baseName + " saved"));
    }

    private void save(ImagePlus imp, String dir, String baseName) {
        String dataName;
        String headerName;
        String lowerBaseName = baseName.toLowerCase();
        if (lowerBaseName.endsWith(".mha")) {
            headerName = baseName;
            dataName = baseName;
        } else if (lowerBaseName.endsWith(".mhd")) {
            baseName = baseName.substring(0, baseName.length() - 4);
            headerName = baseName + ".mhd";
            dataName = baseName + ".raw";
        } else {
            headerName = baseName + ".mha";
            dataName = baseName + ".mha";
        }
        if (!dir.endsWith(File.separator) && dir.length() > 0) {
            dir = dir + File.separator;
        }
        try {
            IJ.showStatus((String)("Saving " + headerName + "..."));
            if (this.writeHeader(imp, dir + headerName, dataName)) {
                IJ.showStatus((String)("Writing " + dataName + "..."));
                if (imp.getStackSize() > 1) {
                    new DeflateExtendedFileSaver(imp).saveAsRawStack(dir + dataName);
                } else {
                    new DeflateExtendedFileSaver(imp).saveAsRaw(dir + dataName);
                }
            }
        }
        catch (IOException e) {
            IJ.error((String)("MetaImage_Writer: " + e.getMessage()));
        }
    }

    private boolean writeHeader(ImagePlus imp, String path, String dataFile) throws IOException {
        FileInfo fi = imp.getFileInfo();
        String numChannels = "1";
        String type = "MET_NONE";
        switch (fi.fileType) {
            case 5: {
                type = "MET_UCHAR";
                break;
            }
            case 0: {
                type = "MET_UCHAR";
                break;
            }
            case 1: {
                type = "MET_SHORT";
                break;
            }
            case 2: {
                type = "MET_USHORT";
                break;
            }
            case 3: {
                type = "MET_INT";
                break;
            }
            case 11: {
                type = "MET_UINT";
                break;
            }
            case 4: {
                type = "MET_FLOAT";
                break;
            }
            case 6: {
                type = "MET_UCHAR_ARRAY";
                numChannels = "3";
                break;
            }
            case 12: {
                type = "MET_USHORT_ARRAY";
                numChannels = "3";
                break;
            }
            default: {
                throw new IOException("Unsupported data format.");
            }
        }
        FileOutputStream file = new FileOutputStream(path);
        PrintStream stream = new PrintStream(file);
        int ndims = imp.getStackSize() > 1 ? 3 : 2;
        stream.println("ObjectType = Image");
        if (ndims == 3) {
            stream.println("NDims = 3");
        } else {
            stream.println("NDims = 2");
        }
        stream.println("BinaryData = True");
        if (fi.intelByteOrder) {
            stream.println("BinaryDataByteOrderMSB = False");
        } else {
            stream.println("BinaryDataByteOrderMSB = True");
        }
        stream.println("CompressedData = True");
        stream.println("CompressedDataSize = 9999999999999");
        if (ndims == 3) {
            stream.println("DimSize = " + fi.width + " " + fi.height + " " + fi.nImages);
            stream.println("ElementSize = " + fi.pixelWidth + " " + fi.pixelHeight + " " + fi.pixelDepth);
        } else {
            stream.println("DimSize = " + fi.width + " " + fi.height);
            stream.println("ElementSize = " + fi.pixelWidth + " " + fi.pixelHeight);
        }
        if (numChannels != "1") {
            stream.println("ElementNumberOfChannels = " + numChannels);
        }
        stream.println("ElementType = " + type);
        if (dataFile.endsWith(".mha")) {
            stream.println("ElementDataFile = LOCAL");
        } else {
            stream.println("ElementDataFile = " + dataFile);
        }
        stream.close();
        file.close();
        return true;
    }
}

