/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchart;

import de.erichseifert.vectorgraphics2d.Document;
import de.erichseifert.vectorgraphics2d.VectorGraphics2D;
import de.erichseifert.vectorgraphics2d.eps.EPSProcessor;
import de.erichseifert.vectorgraphics2d.intermediate.CommandSequence;
import de.erichseifert.vectorgraphics2d.pdf.PDFProcessor;
import de.erichseifert.vectorgraphics2d.svg.SVGProcessor;
import de.erichseifert.vectorgraphics2d.util.PageSize;
import java.awt.Graphics2D;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.knowm.xchart.internal.chartpart.Chart;

public final class VectorGraphicsEncoder {
    private VectorGraphicsEncoder() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveVectorGraphic(Chart chart, String fileName, VectorGraphicsFormat vectorGraphicsFormat) throws IOException {
        EPSProcessor p = null;
        switch (vectorGraphicsFormat) {
            case EPS: {
                p = new EPSProcessor();
                break;
            }
            case PDF: {
                p = new PDFProcessor(true);
                break;
            }
            case SVG: {
                p = new SVGProcessor();
                break;
            }
        }
        VectorGraphics2D vg2d = new VectorGraphics2D();
        CommandSequence commands = vg2d.getCommands();
        chart.paint((Graphics2D)vg2d, chart.getWidth(), chart.getHeight());
        FileOutputStream file = new FileOutputStream(VectorGraphicsEncoder.addFileExtension(fileName, vectorGraphicsFormat));
        try {
            PageSize pageSize = new PageSize(0.0, 0.0, (double)chart.getWidth(), (double)chart.getHeight());
            Document doc = p.getDocument(commands, pageSize);
            doc.writeTo((OutputStream)file);
        }
        finally {
            file.close();
        }
    }

    public static String addFileExtension(String fileName, VectorGraphicsFormat vectorGraphicsFormat) {
        String fileNameWithFileExtension = fileName;
        String newFileExtension = "." + vectorGraphicsFormat.toString().toLowerCase();
        if (fileName.length() <= newFileExtension.length() || !fileName.substring(fileName.length() - newFileExtension.length(), fileName.length()).equalsIgnoreCase(newFileExtension)) {
            fileNameWithFileExtension = fileName + newFileExtension;
        }
        return fileNameWithFileExtension;
    }

    public static enum VectorGraphicsFormat {
        EPS,
        PDF,
        SVG;

    }
}

