/*
 * Decompiled with CFR 0.152.
 */
package sc.fiji.i5d.plugin;

import ij.IJ;
import ij.ImagePlus;
import ij.WindowManager;
import ij.gui.GenericDialog;
import ij.gui.ImageWindow;
import ij.plugin.PlugIn;
import sc.fiji.i5d.Image5D;

public class Stack_to_Image5D
implements PlugIn {
    private static final int CH = 0;
    private static final int Z = 1;
    private static final int T = 2;

    public void run(String arg) {
        boolean assignColor;
        if (IJ.versionLessThan((String)"1.34p")) {
            return;
        }
        ImagePlus imp = WindowManager.getCurrentImage();
        if (imp == null) {
            IJ.noImage();
            return;
        }
        if (imp instanceof Image5D) {
            IJ.error((String)"Image is already an Image5D");
            return;
        }
        int width = imp.getWidth();
        int height = imp.getHeight();
        int nChannels = imp.getNChannels();
        int nSlices = imp.getNSlices();
        int nFrames = imp.getNFrames();
        int stackSize = imp.getStackSize();
        String title = imp.getTitle();
        int type = imp.getType();
        if (type != 0 && type != 1 && type != 2) {
            IJ.error((String)"Wrong data type");
            return;
        }
        int first = 0;
        int middle = 1;
        int last = 2;
        int nFirst = nChannels;
        int nMiddle = nSlices;
        int nLast = nFrames;
        if (nChannels <= 1 && nSlices <= 1 && nFrames > 1) {
            first = 2;
            middle = 1;
            last = 0;
            nFirst = stackSize;
            nMiddle = 1;
            nLast = 1;
        } else if (nChannels <= 1 && nFrames <= 1 && nSlices > 1) {
            first = 1;
            middle = 0;
            last = 2;
            nFirst = stackSize;
            nMiddle = 1;
            nLast = 1;
        }
        String[] dimensions = new String[]{"ch", "z", "t"};
        boolean goOn = true;
        do {
            double dLast;
            goOn = true;
            GenericDialog gd = new GenericDialog("Convert stack to Image5D");
            gd.addMessage("Stack has " + stackSize + " slices.");
            gd.addChoice("3rd dimension", dimensions, dimensions[first]);
            gd.addChoice("4th dimension", dimensions, dimensions[middle]);
            gd.addNumericField("3rd_dimension_size", (double)nFirst, 0, 8, "");
            gd.addNumericField("4th_dimension_size", (double)nMiddle, 0, 8, "");
            gd.addCheckbox("Assign default color", true);
            gd.showDialog();
            if (gd.wasCanceled()) {
                return;
            }
            first = gd.getNextChoiceIndex();
            middle = gd.getNextChoiceIndex();
            nFirst = (int)gd.getNextNumber();
            nMiddle = (int)gd.getNextNumber();
            assignColor = gd.getNextBoolean();
            if (first == middle) {
                IJ.error((String)"Please do not select two dimensions equal!");
                goOn = false;
                continue;
            }
            boolean[] thirdChoice = new boolean[]{true, true, true};
            thirdChoice[first] = false;
            thirdChoice[middle] = false;
            for (int i = 0; i < 3; ++i) {
                if (!thirdChoice[i]) continue;
                last = i;
                break;
            }
            if ((double)(nLast = (int)(dLast = (double)stackSize / (double)nFirst / (double)nMiddle)) == dLast) continue;
            IJ.error((String)"channels*slices*frames!=stackSize");
            goOn = false;
        } while (!goOn);
        nChannels = 1;
        nSlices = 1;
        nFrames = 1;
        switch (first) {
            case 0: {
                nChannels = nFirst;
                break;
            }
            case 1: {
                nSlices = nFirst;
                break;
            }
            case 2: {
                nFrames = nFirst;
            }
        }
        switch (middle) {
            case 0: {
                nChannels = nMiddle;
                break;
            }
            case 1: {
                nSlices = nMiddle;
                break;
            }
            case 2: {
                nFrames = nMiddle;
            }
        }
        switch (last) {
            case 0: {
                nChannels = nLast;
                break;
            }
            case 1: {
                nSlices = nLast;
                break;
            }
            case 2: {
                nFrames = nLast;
            }
        }
        Image5D img5d = new Image5D(title, type, width, height, nChannels, nSlices, nFrames, false);
        int[] index = new int[3];
        index[2] = 0;
        while (index[2] < nFrames) {
            index[1] = 0;
            while (index[1] < nSlices) {
                index[0] = 0;
                while (index[0] < nChannels) {
                    img5d.setCurrentPosition(0, 0, index[0], index[1], index[2]);
                    int stackPosition = 1 + index[first] + index[middle] * nFirst + index[last] * nFirst * nMiddle;
                    img5d.setPixels(imp.getStack().getPixels(stackPosition));
                    index[0] = index[0] + 1;
                }
                index[1] = index[1] + 1;
            }
            index[2] = index[2] + 1;
        }
        img5d.setDefaultChannelNames();
        if (assignColor) {
            img5d.setDefaultColors();
        }
        img5d.setCurrentPosition(0, 0, 0, 0, 0);
        img5d.setCalibration(imp.getCalibration().copy());
        img5d.show();
        imp.changes = false;
        if (imp.getWindow() != null) {
            imp.getWindow().close();
        }
        if (img5d.getWindow() != null) {
            WindowManager.setCurrentWindow((ImageWindow)img5d.getWindow());
        }
    }
}

