/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.realtransform.interval;

import net.imglib2.RealInterval;
import net.imglib2.RealLocalizable;
import net.imglib2.RealPoint;
import net.imglib2.RealPositionable;
import net.imglib2.iterator.LocalizingRealIntervalIterator;
import net.imglib2.realtransform.RealTransform;
import net.imglib2.realtransform.interval.Corners;

public interface IntervalSamplingMethod {
    public static final Corners CORNERS;

    public static void transformedCoordinateBounds(RealTransform transform, LocalizingRealIntervalIterator it, double[] min, double[] max) {
        if (!(1.$assertionsDisabled || transform.numTargetDimensions() <= min.length && transform.numTargetDimensions() <= max.length)) {
            throw new AssertionError((Object)"Transformation target dimensionality too large for min and max vectors.");
        }
        if (!1.$assertionsDisabled && transform.numSourceDimensions() > it.numDimensions()) {
            throw new AssertionError((Object)"Transformation target dimensionality too large for min and max vectors.");
        }
        int nTarget = transform.numTargetDimensions();
        RealPoint targetPoint = new RealPoint(nTarget);
        while (it.hasNext()) {
            it.fwd();
            transform.apply((RealLocalizable)it, (RealPositionable)targetPoint);
            for (int d = 0; d < nTarget; ++d) {
                double p = targetPoint.getDoublePosition(d);
                if (p < min[d]) {
                    min[d] = p;
                }
                if (!(p > max[d])) continue;
                max[d] = p;
            }
        }
    }

    public RealInterval bounds(RealInterval var1, RealTransform var2);

    static {
        if (1.$assertionsDisabled) {
            // empty if block
        }
        CORNERS = new Corners();
    }
}

