/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ui.behaviour.util;

import java.util.HashMap;
import java.util.Map;
import org.scijava.ui.behaviour.Behaviour;
import org.scijava.ui.behaviour.BehaviourMap;

public class WrappedBehaviourMap
extends BehaviourMap {
    private final BehaviourMap behaviourMap;
    private BehaviourMap parent;
    private int expectedParentModCount;

    public WrappedBehaviourMap(BehaviourMap behaviourMap) {
        this.behaviourMap = behaviourMap;
        this.parent = null;
        this.expectedParentModCount = 0;
    }

    @Override
    public void setParent(BehaviourMap map) {
        this.parent = map;
        if (map != null) {
            this.expectedParentModCount = this.parent.modCount();
        }
    }

    @Override
    public BehaviourMap getParent() {
        return this.parent;
    }

    @Override
    public synchronized void put(String key, Behaviour behaviour) {
        throw new UnsupportedOperationException(this.getClass().getSimpleName() + " cannot be modified.");
    }

    @Override
    public synchronized Behaviour get(String key) {
        Behaviour behaviour = this.behaviourMap.get(key);
        if (behaviour == null && this.parent != null) {
            return this.parent.get(key);
        }
        return behaviour;
    }

    @Override
    public synchronized void remove(String key) {
        throw new UnsupportedOperationException(this.getClass().getSimpleName() + " cannot be modified.");
    }

    @Override
    public synchronized void clear() {
        throw new UnsupportedOperationException(this.getClass().getSimpleName() + " cannot be modified.");
    }

    @Override
    public synchronized Map<String, Behaviour> getAllBindings() {
        HashMap<String, Behaviour> allBindings = this.parent == null ? new HashMap() : this.parent.getAllBindings();
        for (Map.Entry<String, Behaviour> entry : this.behaviourMap.getAllBindings().entrySet()) {
            allBindings.put(entry.getKey(), entry.getValue());
        }
        return allBindings;
    }

    @Override
    public int modCount() {
        int m;
        if (this.parent != null && (m = this.parent.modCount()) != this.expectedParentModCount) {
            this.expectedParentModCount = m;
            this.behaviourMap.remove(null);
        }
        return this.behaviourMap.modCount();
    }
}

