/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.fonts.tt;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.GeneralPath;
import java.awt.geom.PathIterator;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.ObjectOutput;
import java.io.Serializable;
import org.jpedal.color.PdfPaint;
import org.jpedal.fonts.glyph.PdfGlyph;
import org.jpedal.fonts.tt.FirstPoint;
import org.jpedal.fonts.tt.FontFile2;
import org.jpedal.fonts.tt.Glyf;
import org.jpedal.fonts.tt.Hmtx;
import org.jpedal.gui.ShowGUIMessage;
import org.jpedal.io.PathSerializer;
import org.jpedal.utils.repositories.Vector_Double;
import org.jpedal.utils.repositories.Vector_Int;
import org.jpedal.utils.repositories.Vector_Object;
import org.jpedal.utils.repositories.Vector_Path;
import org.jpedal.utils.repositories.Vector_Short;

public class TTGlyph
implements PdfGlyph,
Serializable {
    private short minX;
    private short minY;
    private short maxX;
    private short maxY;
    private Vector_Int xtranslateValues = new Vector_Int(5);
    private Vector_Int ytranslateValues = new Vector_Int(5);
    private Vector_Double xscaleValues = new Vector_Double(5);
    private Vector_Double yscaleValues = new Vector_Double(5);
    private Vector_Double scale01Values = new Vector_Double(5);
    private Vector_Double scale10Values = new Vector_Double(5);
    private int xtranslate;
    private int ytranslate;
    private double xscale = 1.0;
    private double yscale = 1.0;
    private double scale01 = 0.0;
    private double scale10 = 0.0;
    private Vector_Object glyfX = new Vector_Object(5);
    private Vector_Object glyfY = new Vector_Object(5);
    private Vector_Object curves = new Vector_Object(5);
    private Vector_Object contours = new Vector_Object(5);
    private int contourCount = 0;
    private float unitsPerEm = 64.0f;
    public boolean debug = false;
    private transient Vector_Path paths = new Vector_Path(10);
    private int compCount = 1;
    private boolean isComposite = false;
    String glyfName = "";
    private int idx = 0;
    Area glyphShape = null;

    public void setPaths(Vector_Path vector_Path) {
        this.paths = vector_Path;
    }

    public void writePathsToStream(ObjectOutput objectOutput) throws IOException {
        if (this.paths != null) {
            int n;
            GeneralPath[] generalPathArray = this.paths.get();
            int n2 = 0;
            for (n = 0; n < generalPathArray.length; ++n) {
                if (generalPathArray[n] != null) continue;
                n2 = n;
                break;
            }
            objectOutput.writeObject(new Integer(n2));
            for (n = 0; n < n2; ++n) {
                PathIterator pathIterator = generalPathArray[n].getPathIterator(new AffineTransform());
                PathSerializer.serializePath(objectOutput, pathIterator);
            }
        }
    }

    public TTGlyph() {
    }

    public TTGlyph(String string, boolean bl, Glyf glyf, FontFile2 fontFile2, Hmtx hmtx, int n, float f) {
        this.debug = bl;
        this.idx = n;
        this.glyfName = string;
        this.unitsPerEm = f;
        this.readGlyph(glyf, fontFile2, null);
        for (int i = 0; i < this.compCount; ++i) {
            int[] nArray = (int[])this.glyfX.elementAt(i);
            int[] nArray2 = (int[])this.glyfY.elementAt(i);
            boolean[] blArray = (boolean[])this.curves.elementAt(i);
            boolean[] blArray2 = (boolean[])this.contours.elementAt(i);
            if (this.isComposite) {
                this.xtranslate = this.xtranslateValues.elementAt(i);
                this.ytranslate = this.ytranslateValues.elementAt(i);
                this.xscale = this.xscaleValues.elementAt(i);
                this.yscale = this.yscaleValues.elementAt(i);
                this.scale01 = this.scale01Values.elementAt(i);
                this.scale10 = this.scale10Values.elementAt(i);
            }
            this.drawGlyf(nArray, nArray2, blArray, blArray2, bl);
            if (!bl) continue;
            try {
                System.out.println("debugging" + n);
                BufferedImage bufferedImage = new BufferedImage(1200, 1200, 2);
                Graphics2D graphics2D = bufferedImage.createGraphics();
                for (int j = 0; j < this.paths.size() - 1; ++j) {
                    if (j == 1) {
                        graphics2D.setColor(Color.red);
                    }
                    graphics2D.fill(this.paths.elementAt(j));
                    System.out.println(j + " " + this.paths.elementAt(j).getBounds2D());
                    graphics2D.draw(this.paths.elementAt(j).getBounds());
                }
                ShowGUIMessage.showGUIMessage("glyf /" + this.paths.size(), bufferedImage, "glyf /" + this.paths.size() + "/" + this.compCount);
                continue;
            }
            catch (Exception exception) {
                exception.printStackTrace();
                System.exit(1);
            }
        }
    }

    private final void readGlyph(Glyf glyf, FontFile2 fontFile2, FirstPoint firstPoint) {
        this.contourCount = fontFile2.getNextUint16();
        this.minX = (short)fontFile2.getNextUint16();
        this.minY = (short)fontFile2.getNextUint16();
        this.maxX = (short)fontFile2.getNextUint16();
        this.maxY = (short)fontFile2.getNextUint16();
        if (this.debug) {
            System.out.println("------------------------------------------------------------");
            System.out.println("minX=" + this.minX + " " + this.minY + " " + this.minY + " maxX=" + this.maxX + " maxY=" + this.maxY + " contourCount=" + this.contourCount);
        }
        if (this.contourCount != 65535) {
            this.readSimpleGlyph(fontFile2, firstPoint);
        } else {
            this.readComplexGlyph(glyf, fontFile2);
        }
    }

    private final void readComplexGlyph(Glyf glyf, FontFile2 fontFile2) {
        this.isComposite = true;
        FirstPoint firstPoint = null;
        while (true) {
            int n;
            int n2;
            boolean bl;
            short s = fontFile2.getShort();
            short s2 = fontFile2.getNextInt16();
            if (this.debug) {
                System.out.println("Index=" + s2 + " flag=" + s);
            }
            boolean bl2 = (s & 1) == 1;
            boolean bl3 = (s & 2) == 2;
            boolean bl4 = (s & 8) == 8;
            boolean bl5 = (s & 0x40) == 64;
            boolean bl6 = bl = (s & 0x80) == 128;
            if (bl2 && bl3) {
                this.xtranslate = fontFile2.getNextInt16();
                this.ytranslate = fontFile2.getNextInt16();
            } else if (!bl2 && bl3) {
                this.xtranslate = fontFile2.getNextint8();
                this.ytranslate = fontFile2.getNextint8();
            } else if (bl2 && !bl3) {
                n2 = fontFile2.getNextInt16();
                n = fontFile2.getNextInt16();
                this.xtranslate = 0;
                this.ytranslate = 0;
                firstPoint = new FirstPoint(n2, n);
            } else if (!bl2 && !bl3) {
                n2 = fontFile2.getNextint8();
                n = fontFile2.getNextint8();
                this.xtranslate = 0;
                this.ytranslate = 0;
            }
            this.xscale = 1.0;
            this.scale01 = 0.0;
            this.yscale = 1.0;
            this.scale10 = 0.0;
            if (bl4 || bl5 || bl) {
                if (bl4 && !bl5 && !bl) {
                    this.xscale = fontFile2.getF2Dot14();
                    this.scale01 = 0.0;
                    this.yscale = this.xscale;
                    this.scale10 = 0.0;
                } else if (!bl4 && bl5 && !bl) {
                    this.xscale = fontFile2.getF2Dot14();
                    this.scale01 = 0.0;
                    this.yscale = fontFile2.getF2Dot14();
                    this.scale10 = 0.0;
                } else if (!bl4 && !bl5 && bl) {
                    this.xscale = fontFile2.getF2Dot14();
                    this.scale01 = fontFile2.getF2Dot14();
                    this.yscale = fontFile2.getF2Dot14();
                    this.scale10 = fontFile2.getF2Dot14();
                }
            }
            this.xtranslateValues.addElement(this.xtranslate);
            this.ytranslateValues.addElement(this.ytranslate);
            this.xscaleValues.addElement(this.xscale);
            this.yscaleValues.addElement(this.yscale);
            this.scale01Values.addElement(this.scale01);
            this.scale10Values.addElement(this.scale10);
            int n3 = fontFile2.getPointer();
            int n4 = glyf.getCharString(s2);
            if (n4 != -1) {
                if (n4 < 0) {
                    n4 = -n4;
                }
                fontFile2.setPointer(n4);
                this.readGlyph(glyf, fontFile2, firstPoint);
            } else {
                System.err.println("Wrong value in complex");
            }
            fontFile2.setPointer(n3);
            if ((s & 0x20) == 0) break;
            ++this.compCount;
        }
    }

    private final void readSimpleGlyph(FontFile2 fontFile2, FirstPoint firstPoint) {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7 = 1;
        short s = 0;
        Vector_Int vector_Int = new Vector_Int(50);
        Vector_Int vector_Int2 = new Vector_Int(50);
        Vector_Short vector_Short = new Vector_Short(50);
        Vector_Short vector_Short2 = new Vector_Short(50);
        boolean bl = false;
        if (firstPoint != null) {
            vector_Int.addElement(1);
            vector_Short.addElement((short)firstPoint.x);
            vector_Short2.addElement((short)firstPoint.y);
        }
        if (this.debug) {
            System.out.println("endPoints");
            System.out.println("---------");
        }
        int n8 = 0;
        for (n6 = 0; n6 < this.contourCount; ++n6) {
            n8 = fontFile2.getNextUint16();
            if (this.debug) {
                System.out.println(n6 + " " + n8);
            }
            if (bl) {
                ++n8;
            }
            vector_Int2.addElement(n8);
        }
        n6 = fontFile2.getNextUint16();
        int[] nArray = new int[n6];
        for (n5 = 0; n5 < n6; ++n5) {
            nArray[n5] = fontFile2.getNextUint8();
        }
        if (this.debug) {
            System.out.println("Instructions");
            System.out.println("------------");
            System.out.println("count=" + n6);
        }
        n5 = n8 + 1;
        for (n4 = 0; n4 < n5; ++n4) {
            n3 = fontFile2.getNextUint8();
            vector_Int.addElement(n3);
            ++n7;
            if ((n3 & 8) != 8) continue;
            n2 = fontFile2.getNextUint8();
            for (n = 1; n <= n2; ++n) {
                vector_Int.addElement(n3);
                ++n7;
            }
            n4 += n2;
        }
        for (n4 = 0; n4 < n5; ++n4) {
            n3 = vector_Int.elementAt(n4);
            int n9 = n2 = (n3 & 2) == 0 ? 1 : 0;
            if ((n3 & 0x10) != 0) {
                if ((n3 & 2) != 0) {
                    s = (short)fontFile2.getNextUint8();
                    vector_Short.addElement(s);
                    continue;
                }
                vector_Short.addElement((short)0);
                continue;
            }
            if ((n3 & 2) != 0) {
                s = (short)(-fontFile2.getNextUint8());
                vector_Short.addElement(s);
                continue;
            }
            s = fontFile2.getNextSignedInt16();
            vector_Short.addElement(s);
        }
        for (n4 = 0; n4 < n5; ++n4) {
            n3 = vector_Int.elementAt(n4);
            if ((n3 & 0x20) != 0) {
                if ((n3 & 4) != 0) {
                    vector_Short2.addElement((short)fontFile2.getNextUint8());
                    continue;
                }
                vector_Short2.addElement((short)0);
                continue;
            }
            if ((n3 & 4) != 0) {
                vector_Short2.addElement((short)(-fontFile2.getNextUint8()));
                continue;
            }
            n2 = fontFile2.getNextSignedInt16();
            vector_Short2.addElement((short)n2);
        }
        n4 = 0;
        n2 = 0;
        n = 0;
        int[] nArray2 = vector_Int.get();
        int[] nArray3 = vector_Int2.get();
        short[] sArray = vector_Short.get();
        short[] sArray2 = vector_Short2.get();
        n5 = sArray.length;
        int[] nArray4 = new int[n5 + 2];
        int[] nArray5 = new int[n5 + 2];
        boolean[] blArray = new boolean[n5 + 2];
        boolean[] blArray2 = new boolean[n5 + 2];
        if (this.debug) {
            System.out.println("Points");
            System.out.println("------");
        }
        for (int i = 0; i < n5; ++i) {
            boolean bl2;
            boolean bl3 = bl2 = nArray3[n4] == i;
            if (bl2) {
                ++n4;
            }
            nArray4[i] = n2 += sArray[i];
            nArray5[i] = n += sArray2[i];
            blArray[i] = i < n7 ? (nArray2[i] & 1) != 0 : false;
            if (this.debug) {
                System.out.println(i + " " + nArray4[i] + " " + nArray5[i] + " " + blArray[i]);
            }
            blArray2[i] = bl2;
        }
        this.glyfX.addElement(nArray4);
        this.glyfY.addElement(nArray5);
        this.curves.addElement(blArray);
        this.contours.addElement(blArray2);
    }

    public void render(int n, Graphics2D graphics2D, boolean bl, float f) {
        for (int i = 0; i < this.paths.size() - 1; ++i) {
            if ((n & 2) == 2) {
                graphics2D.fill(this.paths.elementAt(i));
            }
            if ((n & 1) != 1) continue;
            graphics2D.draw(this.paths.elementAt(i));
        }
    }

    public Area getShape() {
        if (this.glyphShape == null) {
            GeneralPath generalPath = this.paths.elementAt(0);
            for (int i = 1; i < this.paths.size() - 1; ++i) {
                generalPath.append(this.paths.elementAt(i), false);
            }
            this.glyphShape = new Area(generalPath);
        }
        return this.glyphShape;
    }

    public String getGlyphName() {
        return null;
    }

    public void drawGlyf(int[] nArray, int[] nArray2, boolean[] blArray, boolean[] blArray2, boolean bl) {
        int n;
        int n2;
        GeneralPath generalPath = new GeneralPath(1);
        int n3 = nArray.length;
        int n4 = -1;
        for (n2 = 0; n2 < n3; ++n2) {
            if (!blArray2[n2]) continue;
            n4 = n2 + 1;
            n2 = n3;
        }
        n2 = 0;
        boolean bl2 = false;
        int n5 = this.convertX(nArray[0], nArray2[0]);
        int n6 = this.convertY(nArray[0], nArray2[0]);
        int n7 = 0;
        int n8 = 0;
        int n9 = 0;
        int n10 = 0;
        generalPath.moveTo(n5, n6);
        if (bl) {
            System.out.println("first contour=" + n4 + "====================================" + nArray[0] + " " + nArray2[0]);
            System.out.println("start=" + n5 + " " + n6 + " unitsPerEm=" + this.unitsPerEm);
            for (n = 0; n < n3 - 2; ++n) {
                System.out.println(n + " " + this.convertX(nArray[n], nArray2[n]) + " " + this.convertY(nArray[n], nArray2[n]) + " " + blArray[n] + " " + blArray2[n] + " raw=" + nArray[n] + " " + nArray2[n]);
            }
            System.out.println("Move to " + n5 + " " + n6);
        }
        n = 0;
        int n11 = 0;
        int n12 = 0;
        boolean bl3 = false;
        for (int i = 0; i < n3 - 2; ++i) {
            int n13;
            int n14 = i % n4;
            int n15 = (i + 1) % n4;
            int n16 = (i + 2) % n4;
            int n17 = (i - 1) % n4;
            if (i == 0) {
                n17 = n4 - 1;
            }
            if (n15 < n12) {
                n15 += n12;
            }
            if (n16 < n12) {
                n16 += n12;
            }
            if (bl) {
                System.out.println("points=" + n12 + "/" + n4 + " " + n17 + " " + n14 + " " + n15 + " " + n16);
            }
            if (blArray2[i]) {
                bl3 = true;
                n = this.convertX(nArray[n4], nArray2[n4]);
                n11 = this.convertY(nArray[n4], nArray2[n4]);
                n12 = n4;
                for (n13 = i + 1; n13 < n3; ++n13) {
                    if (!blArray2[n13]) continue;
                    n4 = n13 + 1;
                    n13 = n3;
                }
                if (bl) {
                    System.out.println("End of contour. next=" + i + " " + n4 + " " + n12);
                }
            }
            if (bl) {
                if (i > 0) {
                    System.out.println(blArray2[i - 1] + " " + blArray2[i] + " " + blArray2[i + 1]);
                } else {
                    System.out.println(blArray2[i] + " " + blArray2[i + 1]);
                }
                System.out.println("curves=" + blArray[n14] + " " + blArray[n15] + " " + blArray[n16]);
            }
            if (n12 == n4 && blArray[n14]) {
                i = n3;
                if (!bl) continue;
                System.out.println("last 2 match");
                continue;
            }
            if (bl) {
                System.out.println(n4 + " " + n17 + " " + n14 + " " + n15 + " " + n16);
            }
            if (blArray[n14] && blArray[n15]) {
                n9 = this.convertX(nArray[n15], nArray2[n15]);
                n10 = this.convertY(nArray[n15], nArray2[n15]);
                generalPath.lineTo(n9, n10);
                if (bl) {
                    System.out.println(n14 + " pt,pt " + n9 + " " + n10);
                }
            } else if (i < n3 - 3 && n4 - n12 > 1 | n4 == n12) {
                n13 = 0;
                if (blArray[n14] && !blArray[n15] && blArray[n16]) {
                    n5 = this.convertX(nArray[n14], nArray2[n14]);
                    n6 = this.convertY(nArray[n14], nArray2[n14]);
                    n7 = this.convertX(nArray[n15], nArray2[n15]);
                    n8 = this.convertY(nArray[n15], nArray2[n15]);
                    n9 = this.convertX(nArray[n16], nArray2[n16]);
                    n10 = this.convertY(nArray[n16], nArray2[n16]);
                    ++i;
                    n13 = 1;
                    if (bl) {
                        System.out.println(n14 + " pt,cv,pt " + n5 + " " + n6 + " " + n7 + " " + n8 + " " + n9 + " " + n10);
                    }
                } else if (blArray[n14] && !blArray[n15] && !blArray[n16]) {
                    n5 = this.convertX(nArray[n14], nArray2[n14]);
                    n6 = this.convertY(nArray[n14], nArray2[n14]);
                    n7 = this.convertX(nArray[n15], nArray2[n15]);
                    n8 = this.convertY(nArray[n15], nArray2[n15]);
                    n9 = this.convertX(this.midPt(nArray[n15], nArray[n16]), this.midPt(nArray2[n15], nArray2[n16]));
                    n10 = this.convertY(this.midPt(nArray[n15], nArray[n16]), this.midPt(nArray2[n15], nArray2[n16]));
                    ++i;
                    if (bl) {
                        System.out.println(n14 + " pt,cv,cv " + n5 + " " + n6 + " " + n7 + " " + n8 + " " + n9 + " " + n10);
                    }
                } else if (!(blArray[n14] || blArray[n15] || blArray2[n16])) {
                    n5 = this.convertX(this.midPt(nArray[n17], nArray[n14]), this.midPt(nArray2[n17], nArray2[n14]));
                    n6 = this.convertY(this.midPt(nArray[n17], nArray[n14]), this.midPt(nArray2[n17], nArray2[n14]));
                    n7 = this.convertX(nArray[n14], nArray2[n14]);
                    n8 = this.convertY(nArray2[n14], nArray2[n14]);
                    n9 = this.convertX(this.midPt(nArray[n14], nArray[n15]), this.midPt(nArray2[n14], nArray2[n15]));
                    n10 = this.convertY(this.midPt(nArray[n14], nArray[n15]), this.midPt(nArray2[n14], nArray2[n15]));
                    if (bl) {
                        System.out.println(n14 + " cv,cv " + n5 + " " + n6 + " " + n7 + " " + n8 + " " + n9 + " " + n10);
                    }
                } else if (!blArray[n14] && blArray[n15]) {
                    n5 = this.convertX(this.midPt(nArray[n17], nArray[n14]), this.midPt(nArray2[n17], nArray2[n14]));
                    n6 = this.convertY(this.midPt(nArray[n17], nArray[n14]), this.midPt(nArray2[n17], nArray2[n14]));
                    n7 = this.convertX(nArray[n14], nArray2[n14]);
                    n8 = this.convertY(nArray[n14], nArray2[n14]);
                    n9 = this.convertX(nArray[n15], nArray2[n15]);
                    n10 = this.convertY(nArray[n15], nArray2[n15]);
                    if (bl) {
                        System.out.println(n14 + " cv,pt " + n5 + " " + n6 + " " + n7 + " " + n8 + " " + n9 + " " + n10);
                    }
                }
                generalPath.curveTo(n5, n6, n7, n8, n9, n10);
                if (n13 != 0 && blArray2[i]) {
                    bl3 = true;
                    n = this.convertX(nArray[n4], nArray2[n4]);
                    n11 = this.convertY(nArray[n4], nArray2[n4]);
                    n12 = n4;
                    for (int j = i + 1; j < n3; ++j) {
                        if (!blArray2[j]) continue;
                        n4 = j + 1;
                        j = n3;
                    }
                    if (bl) {
                        System.out.println("Curve");
                    }
                }
            }
            if (bl) {
                System.out.println("x2 " + n + " " + n11 + " " + bl3);
            }
            if (bl3) {
                generalPath.moveTo(n, n11);
                bl3 = false;
                if (bl) {
                    System.out.println("Move to " + n5 + " " + n6);
                }
            }
            if (!bl) continue;
        }
        this.paths.addElement(generalPath);
        if (bl) {
            System.out.println("Ends at " + n5 + " " + n6);
        }
    }

    private final int midPt(int n, int n2) {
        return n + (n2 - n) / 2;
    }

    private final int convertX(int n, int n2) {
        if (!this.isComposite) {
            return (int)((float)n / this.unitsPerEm);
        }
        return (int)(((double)n * this.xscale + (double)n2 * this.scale10 + (double)this.xtranslate) / (double)this.unitsPerEm);
    }

    private final int convertY(int n, int n2) {
        if (!this.isComposite) {
            return (int)((float)n2 / this.unitsPerEm);
        }
        return (int)(((double)n * this.scale01 + (double)n2 * this.yscale + (double)this.ytranslate) / (double)this.unitsPerEm) + 30;
    }

    public int getmaxWidth() {
        return 0;
    }

    public int getmaxHeight() {
        return 0;
    }

    public void lockColors(PdfPaint pdfPaint, PdfPaint pdfPaint2) {
    }

    public boolean ignoreColors() {
        return false;
    }

    public void flushArea() {
        this.glyphShape = null;
    }
}

