/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.trakem2.align;

import ij.IJ;
import ij.gui.GenericDialog;
import ij.process.ByteProcessor;
import ij.process.FloatProcessor;
import ij.process.ImageProcessor;
import ini.trakem2.Project;
import ini.trakem2.display.Display;
import ini.trakem2.display.Patch;
import ini.trakem2.utils.Utils;
import java.awt.Rectangle;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicInteger;
import mpicbg.ij.SIFT;
import mpicbg.ij.blockmatching.BlockMatching;
import mpicbg.imagefeatures.Feature;
import mpicbg.imagefeatures.FloatArray2DSIFT;
import mpicbg.models.AbstractModel;
import mpicbg.models.Affine2D;
import mpicbg.models.AffineModel2D;
import mpicbg.models.CoordinateTransform;
import mpicbg.models.ErrorStatistic;
import mpicbg.models.InvertibleCoordinateTransform;
import mpicbg.models.NotEnoughDataPointsException;
import mpicbg.models.Point;
import mpicbg.models.PointMatch;
import mpicbg.models.RigidModel2D;
import mpicbg.models.SimilarityModel2D;
import mpicbg.models.Spring;
import mpicbg.models.SpringMesh;
import mpicbg.models.TranslationModel2D;
import mpicbg.models.Vertex;
import mpicbg.trakem2.align.AbstractAffineTile2D;
import mpicbg.trakem2.align.Align;
import mpicbg.trakem2.align.ElasticLayerAlignment;
import mpicbg.trakem2.align.Util;
import mpicbg.trakem2.transform.ThinPlateSplineTransform;
import mpicbg.trakem2.util.Triple;

public class ElasticMontage {
    static final Param p = new Param();

    public static final Param setup() {
        return p.setup() ? p.clone() : null;
    }

    private static final String patchName(Patch patch) {
        return new StringBuffer("patch `").append(patch.getTitle()).append("'").toString();
    }

    protected static final void extractAndSaveFeatures(final List<AbstractAffineTile2D<?>> tiles, final FloatArray2DSIFT.Param siftParam, final boolean clearCache) throws Exception {
        ExecutorService exec = Executors.newFixedThreadPool(ElasticMontage.p.maxNumThreads);
        final AtomicInteger counter = new AtomicInteger(0);
        ArrayList<Future<ArrayList<Feature>>> siftTasks = new ArrayList<Future<ArrayList<Feature>>>();
        int i = 0;
        while (i < tiles.size()) {
            final int n = i++;
            siftTasks.add(exec.submit(new Callable<ArrayList<Feature>>(){

                @Override
                public ArrayList<Feature> call() {
                    AbstractAffineTile2D tile = (AbstractAffineTile2D)((Object)tiles.get(n));
                    String patchName = ElasticMontage.patchName(tile.getPatch());
                    IJ.showProgress((int)counter.getAndIncrement(), (int)(tiles.size() - 1));
                    ArrayList<Object> fs = null;
                    if (!clearCache) {
                        fs = Util.deserializeFeatures(tile.getPatch().getProject(), siftParam, null, tile.getPatch().getId());
                    }
                    if (null == fs) {
                        FloatArray2DSIFT sift = new FloatArray2DSIFT(siftParam);
                        SIFT ijSIFT = new SIFT(sift);
                        fs = new ArrayList();
                        ByteProcessor ip = tile.createMaskedByteImage();
                        ijSIFT.extractFeatures((ImageProcessor)ip, fs);
                        Utils.log(fs.size() + " features extracted for " + patchName);
                        if (!Util.serializeFeatures(tile.getPatch().getProject(), siftParam, null, tile.getPatch().getId(), fs)) {
                            Utils.log("FAILED to store serialized features for " + patchName);
                        }
                    } else {
                        Utils.log(fs.size() + " features loaded for " + patchName);
                    }
                    return fs;
                }
            }));
        }
        for (Future future : siftTasks) {
            future.get();
        }
        siftTasks.clear();
        exec.shutdown();
    }

    protected static final FloatProcessor scaleByte(ByteProcessor bp) {
        FloatProcessor fp = new FloatProcessor(bp.getWidth(), bp.getHeight());
        byte[] bytes = (byte[])bp.getPixels();
        float[] floats = (float[])fp.getPixels();
        for (int i = 0; i < bytes.length; ++i) {
            floats[i] = (float)(bytes[i] & 0xFF) / 255.0f;
        }
        return fp;
    }

    public final void exec(List<Patch> patches, Set<Patch> fixedPatches) throws Exception {
        if (patches.size() < 2) {
            Utils.log("Elastic montage requires at least 2 patches to be montaged.  You passed me " + patches.size());
            return;
        }
        Project project = patches.get(0).getProject();
        for (Patch patch : patches) {
            if (patch.getProject() == project) continue;
            Utils.log("Elastic montage requires all patches to be member of a single project.  You passed me patches from several projects.");
            return;
        }
        for (Patch patch : fixedPatches) {
            if (patch.getProject() == project) continue;
            Utils.log("Elastic montage requires all fixed patches to be member of a single project.  You passed me fixed patches from several projects.");
            return;
        }
        Param param = ElasticMontage.setup();
        if (param == null) {
            return;
        }
        this.exec(param, patches, fixedPatches);
    }

    public final void exec(Param param, List<Patch> patches, Set<Patch> fixedPatches) throws Exception {
        patches.get(0).getProject().getLoader().releaseAll();
        ArrayList tiles = new ArrayList();
        ArrayList fixedTiles = new ArrayList();
        Align.tilesFromPatches(param.po, patches, fixedPatches, tiles, fixedTiles);
        if (!param.isAligned) {
            Align.alignTiles(param.po, tiles, fixedTiles, param.tilesAreInPlace, param.maxNumThreads);
            for (AbstractAffineTile2D<?> t : tiles) {
                t.getPatch().setAffineTransform(t.createAffine());
            }
            Display.update();
        }
        ArrayList<AbstractAffineTile2D<?>[]> tilePairs = new ArrayList<AbstractAffineTile2D<?>[]>();
        AbstractAffineTile2D.pairOverlappingTiles(tiles, tilePairs);
        if (tilePairs.size() == 0) {
            Utils.log("Elastic montage could not find any overlapping patches after pre-montaging.");
            return;
        }
        Utils.log(tilePairs.size() + " pairs of patches will be block-matched...");
        ArrayList<Triple> pairs = new ArrayList<Triple>();
        for (AbstractAffineTile2D<?>[] pair : tilePairs) {
            TranslationModel2D m;
            switch (param.po.desiredModelIndex) {
                case 0: {
                    TranslationModel2D t = (TranslationModel2D)((Affine2D)pair[1].getModel()).createInverse();
                    t.concatenate((TranslationModel2D)pair[0].getModel());
                    m = t;
                    break;
                }
                case 1: {
                    RigidModel2D r = (RigidModel2D)((Affine2D)pair[1].getModel()).createInverse();
                    r.concatenate((RigidModel2D)pair[0].getModel());
                    m = r;
                    break;
                }
                case 2: {
                    SimilarityModel2D similarityModel2D = (SimilarityModel2D)((Affine2D)pair[1].getModel()).createInverse();
                    similarityModel2D.concatenate((SimilarityModel2D)pair[0].getModel());
                    m = similarityModel2D;
                    break;
                }
                case 3: {
                    AffineModel2D a = (AffineModel2D)((Affine2D)pair[1].getModel()).createInverse();
                    a.concatenate((AffineModel2D)pair[0].getModel());
                    m = a;
                    break;
                }
                default: {
                    m = null;
                }
            }
            pairs.add(new Triple(pair[0], pair[1], m));
        }
        double springTriangleHeightTwice = 2.0 * Math.sqrt(0.75 * param.springLengthSpringMesh * param.springLengthSpringMesh);
        ArrayList<SpringMesh> meshes = new ArrayList<SpringMesh>(tiles.size());
        HashMap<AbstractAffineTile2D, SpringMesh> tileMeshMap = new HashMap<AbstractAffineTile2D, SpringMesh>();
        for (AbstractAffineTile2D abstractAffineTile2D : tiles) {
            double w = abstractAffineTile2D.getWidth();
            double d = abstractAffineTile2D.getHeight();
            int numX = Math.max(2, (int)Math.ceil(w / param.springLengthSpringMesh) + 1);
            int numY = Math.max(2, (int)Math.ceil(d / springTriangleHeightTwice) + 1);
            double wMesh = (double)(numX - 1) * param.springLengthSpringMesh;
            double hMesh = (double)(numY - 1) * springTriangleHeightTwice;
            SpringMesh mesh = new SpringMesh(numX, numY, wMesh, hMesh, param.stiffnessSpringMesh, param.maxStretchSpringMesh * param.bmScale, param.dampSpringMesh);
            meshes.add(mesh);
            tileMeshMap.put(abstractAffineTile2D, mesh);
        }
        int blockRadius = Math.max(mpicbg.util.Util.roundPos((double)(16.0 / param.bmScale)), param.bmBlockRadius);
        int n = param.bmSearchRadius;
        AbstractModel<?> localSmoothnessFilterModel = Util.createModel(param.bmLocalModelIndex);
        for (Triple triple : pairs) {
            Vertex p2;
            Vertex p1;
            FloatProcessor fpMask2;
            AbstractAffineTile2D t1 = (AbstractAffineTile2D)((Object)triple.a);
            AbstractAffineTile2D t2 = (AbstractAffineTile2D)((Object)triple.b);
            SpringMesh m1 = (SpringMesh)tileMeshMap.get((Object)t1);
            SpringMesh m2 = (SpringMesh)tileMeshMap.get((Object)t2);
            ArrayList pm12 = new ArrayList();
            ArrayList pm21 = new ArrayList();
            ArrayList v1 = m1.getVertices();
            ArrayList v2 = m2.getVertices();
            String patchName1 = ElasticMontage.patchName(t1.getPatch());
            String patchName2 = ElasticMontage.patchName(t2.getPatch());
            Patch.PatchImage pi1 = t1.getPatch().createTransformedImage();
            if (pi1 == null) {
                Utils.log("Patch `" + patchName1 + "' failed generating a transformed image.  Skipping...");
                continue;
            }
            Patch.PatchImage pi2 = t2.getPatch().createTransformedImage();
            if (pi2 == null) {
                Utils.log("Patch `" + patchName2 + "' failed generating a transformed image.  Skipping...");
                continue;
            }
            FloatProcessor fp1 = (FloatProcessor)pi1.target.convertToFloat();
            ByteProcessor mask1 = pi1.getMask();
            FloatProcessor fpMask1 = mask1 == null ? null : ElasticMontage.scaleByte(mask1);
            FloatProcessor fp2 = (FloatProcessor)pi2.target.convertToFloat();
            ByteProcessor mask2 = pi2.getMask();
            FloatProcessor floatProcessor = fpMask2 = mask2 == null ? null : ElasticMontage.scaleByte(mask2);
            if (!fixedTiles.contains((Object)t1)) {
                BlockMatching.matchByMaximalPMCC((FloatProcessor)fp1, (FloatProcessor)fp2, (FloatProcessor)fpMask1, (FloatProcessor)fpMask2, (double)param.bmScale, (CoordinateTransform)((CoordinateTransform)triple.c), (int)blockRadius, (int)blockRadius, (int)n, (int)n, (float)param.bmMinR, (float)param.bmRodR, (float)param.bmMaxCurvatureR, (Collection)v1, pm12, (ErrorStatistic)new ErrorStatistic(1));
                if (param.bmUseLocalSmoothnessFilter) {
                    Utils.log("`" + patchName1 + "' > `" + patchName2 + "': found " + pm12.size() + " correspondence candidates.");
                    localSmoothnessFilterModel.localSmoothnessFilter(pm12, pm12, (double)param.bmLocalRegionSigma, (double)param.bmMaxLocalEpsilon, (double)param.bmMaxLocalTrust);
                    Utils.log("`" + patchName1 + "' > `" + patchName2 + "': " + pm12.size() + " candidates passed local smoothness filter.");
                } else {
                    Utils.log("`" + patchName1 + "' > `" + patchName2 + "': found " + pm12.size() + " correspondences.");
                }
            } else {
                Utils.log("Skipping fixed patch `" + patchName1 + "'.");
            }
            if (!fixedTiles.contains((Object)t2)) {
                BlockMatching.matchByMaximalPMCC((FloatProcessor)fp2, (FloatProcessor)fp1, (FloatProcessor)fpMask2, (FloatProcessor)fpMask1, (double)param.bmScale, (CoordinateTransform)((InvertibleCoordinateTransform)triple.c).createInverse(), (int)blockRadius, (int)blockRadius, (int)n, (int)n, (float)param.bmMinR, (float)param.bmRodR, (float)param.bmMaxCurvatureR, (Collection)v2, pm21, (ErrorStatistic)new ErrorStatistic(1));
                if (param.bmUseLocalSmoothnessFilter) {
                    Utils.log("`" + patchName1 + "' < `" + patchName2 + "': found " + pm21.size() + " correspondence candidates.");
                    localSmoothnessFilterModel.localSmoothnessFilter(pm21, pm21, (double)param.bmLocalRegionSigma, (double)param.bmMaxLocalEpsilon, (double)param.bmMaxLocalTrust);
                    Utils.log("`" + patchName1 + "' < `" + patchName2 + "': " + pm21.size() + " candidates passed local smoothness filter.");
                } else {
                    Utils.log("`" + patchName1 + "' < `" + patchName2 + "': found " + pm21.size() + " correspondences.");
                }
            } else {
                Utils.log("Skipping fixed patch `" + patchName2 + "'.");
            }
            for (PointMatch pm : pm12) {
                p1 = (Vertex)pm.getP1();
                p2 = new Vertex(pm.getP2());
                p1.addSpring(p2, new Spring(0.0, 1.0));
                m2.addPassiveVertex(p2);
            }
            for (PointMatch pm : pm21) {
                p1 = (Vertex)pm.getP1();
                p2 = new Vertex(pm.getP2());
                p1.addSpring(p2, new Spring(0.0, 1.0));
                m1.addPassiveVertex(p2);
            }
        }
        for (Map.Entry entry : tileMeshMap.entrySet()) {
            ((SpringMesh)entry.getValue()).init((CoordinateTransform)((AbstractAffineTile2D)((Object)entry.getKey())).getModel());
        }
        try {
            long t0 = System.currentTimeMillis();
            IJ.log((String)"Optimizing spring meshes...");
            if (param.useLegacyOptimizer) {
                Utils.log("  ...using legacy optimizer...");
                SpringMesh.optimizeMeshes2(meshes, (double)param.po.maxEpsilon, (int)param.maxIterationsSpringMesh, (int)param.maxPlateauwidthSpringMesh, (boolean)param.visualize);
            } else {
                SpringMesh.optimizeMeshes(meshes, (double)param.po.maxEpsilon, (int)param.maxIterationsSpringMesh, (int)param.maxPlateauwidthSpringMesh, (boolean)param.visualize);
            }
            IJ.log((String)("Done optimizing spring meshes. Took " + (System.currentTimeMillis() - t0) + " ms"));
        }
        catch (NotEnoughDataPointsException e) {
            Utils.log("There were not enough data points to get the spring mesh optimizing.");
            e.printStackTrace();
            return;
        }
        for (Map.Entry entry : tileMeshMap.entrySet()) {
            AbstractAffineTile2D tile = (AbstractAffineTile2D)((Object)entry.getKey());
            if (fixedTiles.contains((Object)tile)) continue;
            Patch patch = tile.getPatch();
            SpringMesh mesh = (SpringMesh)entry.getValue();
            Set<PointMatch> matches = mesh.getVA().keySet();
            Rectangle box = patch.getCoordinateTransformBoundingBox();
            for (PointMatch pm : matches) {
                Point p1 = pm.getP1();
                double[] l = p1.getL();
                l[0] = l[0] + (double)box.x;
                l[1] = l[1] + (double)box.y;
            }
            ThinPlateSplineTransform mlt = ElasticLayerAlignment.makeTPS(matches);
            patch.appendCoordinateTransform((mpicbg.trakem2.transform.CoordinateTransform)mlt);
            box = patch.getCoordinateTransformBoundingBox();
            patch.getAffineTransform().setToTranslation(box.x, box.y);
            patch.updateInDatabase("transform");
            patch.updateBucket();
            patch.updateMipMaps();
        }
        Utils.log("Done.");
    }

    public static final class Param
    implements Serializable {
        private static final long serialVersionUID = 8017492269521223930L;
        public Align.ParamOptimize po = new Align.ParamOptimize();
        public boolean isAligned;
        public boolean tilesAreInPlace;
        public double bmScale;
        public float bmMinR;
        public float bmMaxCurvatureR;
        public float bmRodR;
        public int bmSearchRadius;
        public int bmBlockRadius;
        public boolean bmUseLocalSmoothnessFilter;
        public int bmLocalModelIndex;
        public float bmLocalRegionSigma;
        public float bmMaxLocalEpsilon;
        public float bmMaxLocalTrust;
        public double springLengthSpringMesh;
        public double stiffnessSpringMesh;
        public double dampSpringMesh;
        public double maxStretchSpringMesh;
        public int maxIterationsSpringMesh;
        public int maxPlateauwidthSpringMesh;
        public boolean useLegacyOptimizer;
        public boolean visualize;
        public int maxNumThreads;

        public Param() {
            this.po.maxEpsilon = 25.0f;
            this.po.minInlierRatio = 0.0f;
            this.po.minNumInliers = 12;
            this.po.expectedModelIndex = 0;
            this.po.desiredModelIndex = 0;
            this.po.rejectIdentity = true;
            this.po.identityTolerance = 5.0f;
            this.isAligned = false;
            this.tilesAreInPlace = true;
            this.bmScale = 0.5;
            this.bmMinR = 0.5f;
            this.bmMaxCurvatureR = 10.0f;
            this.bmRodR = 0.9f;
            this.bmSearchRadius = 25;
            this.bmBlockRadius = -1;
            this.bmUseLocalSmoothnessFilter = false;
            this.bmLocalModelIndex = 1;
            this.bmLocalRegionSigma = this.bmSearchRadius;
            this.bmMaxLocalEpsilon = this.bmSearchRadius / 2;
            this.bmMaxLocalTrust = 3.0f;
            this.springLengthSpringMesh = 100.0;
            this.stiffnessSpringMesh = 0.1f;
            this.dampSpringMesh = 0.9f;
            this.maxStretchSpringMesh = 2000.0;
            this.maxIterationsSpringMesh = 1000;
            this.maxPlateauwidthSpringMesh = 200;
            this.useLegacyOptimizer = true;
            this.visualize = false;
            this.maxNumThreads = Runtime.getRuntime().availableProcessors();
        }

        public boolean setup() {
            if (this.bmBlockRadius < 0) {
                this.bmBlockRadius = mpicbg.util.Util.roundPos((double)(this.springLengthSpringMesh / 2.0));
            }
            GenericDialog gdBlockMatching = new GenericDialog("Elastic montage: Block Matching and Spring Meshes");
            gdBlockMatching.addMessage("Block Matching:");
            gdBlockMatching.addNumericField("patch_scale :", this.bmScale, 2);
            gdBlockMatching.addNumericField("search_radius :", (double)this.bmSearchRadius, 0, 6, "px");
            gdBlockMatching.addNumericField("block_radius :", (double)this.bmBlockRadius, 0, 6, "px");
            gdBlockMatching.addMessage("Correlation Filters:");
            gdBlockMatching.addNumericField("minimal_PMCC_r :", (double)this.bmMinR, 2);
            gdBlockMatching.addNumericField("maximal_curvature_ratio :", (double)this.bmMaxCurvatureR, 2);
            gdBlockMatching.addNumericField("maximal_second_best_r/best_r :", (double)this.bmRodR, 2);
            gdBlockMatching.addMessage("Local Smoothness Filter:");
            gdBlockMatching.addCheckbox("use_local_smoothness_filter", this.bmUseLocalSmoothnessFilter);
            gdBlockMatching.addChoice("approximate_local_transformation :", Align.ParamOptimize.modelStrings, Align.ParamOptimize.modelStrings[this.bmLocalModelIndex]);
            gdBlockMatching.addNumericField("local_region_sigma:", (double)this.bmLocalRegionSigma, 2, 6, "px");
            gdBlockMatching.addNumericField("maximal_local_displacement (absolute):", (double)this.bmMaxLocalEpsilon, 2, 6, "px");
            gdBlockMatching.addNumericField("maximal_local_displacement (relative):", (double)this.bmMaxLocalTrust, 2);
            gdBlockMatching.addMessage("Montage :");
            gdBlockMatching.addCheckbox("tiles_are_pre-montaged", this.isAligned);
            gdBlockMatching.showDialog();
            if (gdBlockMatching.wasCanceled()) {
                return false;
            }
            this.bmScale = gdBlockMatching.getNextNumber();
            this.bmSearchRadius = (int)gdBlockMatching.getNextNumber();
            this.bmBlockRadius = (int)gdBlockMatching.getNextNumber();
            this.bmMinR = (float)gdBlockMatching.getNextNumber();
            this.bmMaxCurvatureR = (float)gdBlockMatching.getNextNumber();
            this.bmRodR = (float)gdBlockMatching.getNextNumber();
            this.bmUseLocalSmoothnessFilter = gdBlockMatching.getNextBoolean();
            this.bmLocalModelIndex = gdBlockMatching.getNextChoiceIndex();
            this.bmLocalRegionSigma = (float)gdBlockMatching.getNextNumber();
            this.bmMaxLocalEpsilon = (float)gdBlockMatching.getNextNumber();
            this.bmMaxLocalTrust = (float)gdBlockMatching.getNextNumber();
            this.isAligned = gdBlockMatching.getNextBoolean();
            GenericDialog gdSpringMesh = new GenericDialog("Elastic montage: Spring Meshes");
            gdSpringMesh.addNumericField("spring_length :", this.springLengthSpringMesh, 2, 6, "px");
            gdSpringMesh.addNumericField("stiffness :", this.stiffnessSpringMesh, 2);
            gdSpringMesh.addNumericField("maximal_stretch :", this.maxStretchSpringMesh, 2, 6, "px");
            gdSpringMesh.addNumericField("maximal_iterations :", (double)this.maxIterationsSpringMesh, 0);
            gdSpringMesh.addNumericField("maximal_plateauwidth :", (double)this.maxPlateauwidthSpringMesh, 0);
            gdSpringMesh.addCheckbox("use_legacy_optimizer :", this.useLegacyOptimizer);
            gdSpringMesh.showDialog();
            if (gdSpringMesh.wasCanceled()) {
                return false;
            }
            this.springLengthSpringMesh = gdSpringMesh.getNextNumber();
            this.stiffnessSpringMesh = gdSpringMesh.getNextNumber();
            this.maxStretchSpringMesh = gdSpringMesh.getNextNumber();
            this.maxIterationsSpringMesh = (int)gdSpringMesh.getNextNumber();
            this.maxPlateauwidthSpringMesh = (int)gdSpringMesh.getNextNumber();
            this.useLegacyOptimizer = gdSpringMesh.getNextBoolean();
            if (this.isAligned) {
                this.po.desiredModelIndex = 3;
            } else {
                if (!this.po.setup("Elastic montage : SIFT based pre-montage")) {
                    return false;
                }
                GenericDialog gdSIFT = new GenericDialog("Elastic montage : SIFT based pre-montage: Miscellaneous");
                gdSIFT.addCheckbox("tiles_are_roughly_in_place", this.tilesAreInPlace);
                gdSIFT.showDialog();
                if (gdSIFT.wasCanceled()) {
                    return false;
                }
                this.tilesAreInPlace = gdSIFT.getNextBoolean();
            }
            return true;
        }

        public Param clone() {
            Param clone = new Param();
            clone.po = this.po.clone();
            clone.tilesAreInPlace = this.tilesAreInPlace;
            clone.isAligned = this.isAligned;
            clone.bmScale = this.bmScale;
            clone.bmMinR = this.bmMinR;
            clone.bmMaxCurvatureR = this.bmMaxCurvatureR;
            clone.bmRodR = this.bmRodR;
            clone.bmUseLocalSmoothnessFilter = this.bmUseLocalSmoothnessFilter;
            clone.bmLocalModelIndex = this.bmLocalModelIndex;
            clone.bmLocalRegionSigma = this.bmLocalRegionSigma;
            clone.bmMaxLocalEpsilon = this.bmMaxLocalEpsilon;
            clone.bmMaxLocalTrust = this.bmMaxLocalTrust;
            clone.springLengthSpringMesh = this.springLengthSpringMesh;
            clone.stiffnessSpringMesh = this.stiffnessSpringMesh;
            clone.dampSpringMesh = this.dampSpringMesh;
            clone.maxStretchSpringMesh = this.maxStretchSpringMesh;
            clone.maxIterationsSpringMesh = this.maxIterationsSpringMesh;
            clone.maxPlateauwidthSpringMesh = this.maxPlateauwidthSpringMesh;
            clone.useLegacyOptimizer = this.useLegacyOptimizer;
            clone.visualize = this.visualize;
            clone.maxNumThreads = this.maxNumThreads;
            return clone;
        }
    }
}

