/*
 * Decompiled with CFR 0.152.
 */
package bigwarp.source;

import net.imglib2.AbstractRealInterval;
import net.imglib2.AbstractRealLocalizable;
import net.imglib2.Interval;
import net.imglib2.Localizable;
import net.imglib2.RealInterval;
import net.imglib2.RealLocalizable;
import net.imglib2.RealRandomAccess;
import net.imglib2.RealRandomAccessibleRealInterval;
import net.imglib2.realtransform.AffineTransform;
import net.imglib2.realtransform.inverse.DifferentiableRealTransform;
import net.imglib2.type.numeric.RealType;
import org.ejml.data.DMatrixRMaj;
import org.ejml.dense.row.CommonOps_DDRM;

public class JacobianDeterminantRandomAccess<T extends RealType<T>>
extends AbstractRealLocalizable
implements RealRandomAccess<T> {
    protected DifferentiableRealTransform transform;
    private final T value;
    private final double[] x;
    private final double[] x3;

    protected JacobianDeterminantRandomAccess(double[] dimensions) {
        this(dimensions, null, null);
    }

    protected JacobianDeterminantRandomAccess(double[] dimensions, T value, DifferentiableRealTransform transform) {
        super(3);
        this.setTransform(transform);
        this.value = (RealType)value.copy();
        this.x = new double[dimensions.length];
        this.x3 = new double[3];
    }

    public void setTransform(DifferentiableRealTransform transform) {
        if (transform != null) {
            this.transform = transform.copy();
        }
    }

    public T get() {
        if (this.transform == null) {
            this.value.setOne();
            return this.value;
        }
        this.localize(this.x3);
        System.arraycopy(this.x3, 0, this.x, 0, this.x.length);
        AffineTransform jacobian = this.transform.jacobian(this.x);
        DMatrixRMaj jacMtx = new DMatrixRMaj();
        jacMtx.data = jacobian.getRowPackedCopy();
        this.value.setReal(CommonOps_DDRM.det((DMatrixRMaj)jacMtx));
        return this.value;
    }

    public RealRandomAccess<T> copy() {
        return new JacobianDeterminantRandomAccess<RealType>(new double[this.x.length], (RealType)this.value.copy(), this.transform);
    }

    public RealRandomAccess<T> copyRandomAccess() {
        return this.copy();
    }

    public RealRandomAccess<T> copyRealRandomAccess() {
        return this.copy();
    }

    public void fwd(int d) {
        int n = d;
        this.position[n] = this.position[n] + 1.0;
    }

    public void bck(int d) {
        int n = d;
        this.position[n] = this.position[n] - 1.0;
    }

    public void move(int distance, int d) {
        int n = d;
        this.position[n] = this.position[n] + (double)distance;
    }

    public void move(long distance, int d) {
        int n = d;
        this.position[n] = this.position[n] + (double)distance;
    }

    public void move(Localizable localizable) {
        int d = 0;
        while (d < this.n) {
            int distance = localizable.getIntPosition(d);
            int n = d++;
            this.position[n] = this.position[n] + (double)distance;
        }
    }

    public void move(int[] distance) {
        for (int d = 0; d < this.n; ++d) {
            int n = d;
            this.position[n] = this.position[n] + (double)distance[d];
        }
    }

    public void move(long[] distance) {
        for (int d = 0; d < this.n; ++d) {
            int n = d;
            this.position[n] = this.position[n] + (double)distance[d];
        }
    }

    public void setPosition(Localizable localizable) {
        localizable.localize(this.position);
    }

    public void setPosition(int[] pos) {
        for (int d = 0; d < this.n; ++d) {
            this.position[d] = pos[d];
        }
    }

    public void setPosition(long[] pos) {
        for (int d = 0; d < this.n; ++d) {
            int p = (int)pos[d];
            this.position[d] = p;
        }
    }

    public void setPosition(int pos, int d) {
        this.position[d] = pos;
    }

    public void setPosition(long pos, int d) {
        this.position[d] = (int)pos;
    }

    public void move(float distance, int d) {
        int n = d;
        this.position[n] = this.position[n] + (double)distance;
    }

    public void move(double distance, int d) {
        int n = d;
        this.position[n] = this.position[n] + distance;
    }

    public void move(RealLocalizable localizable) {
        int d = 0;
        while (d < this.n) {
            double distance = localizable.getDoublePosition(d);
            int n = d++;
            this.position[n] = this.position[n] + distance;
        }
    }

    public void move(float[] distance) {
        for (int d = 0; d < this.n; ++d) {
            int n = d;
            this.position[n] = this.position[n] + (double)distance[d];
        }
    }

    public void move(double[] distance) {
        for (int d = 0; d < this.n; ++d) {
            int n = d;
            this.position[n] = this.position[n] + distance[d];
        }
    }

    public void setPosition(RealLocalizable localizable) {
        for (int d = 0; d < this.n; ++d) {
            double pos;
            this.position[d] = pos = localizable.getDoublePosition(d);
        }
    }

    public void setPosition(float[] p) {
        for (int d = 0; d < this.n; ++d) {
            this.position[d] = p[d];
        }
    }

    public void setPosition(double[] p) {
        for (int d = 0; d < this.n; ++d) {
            this.position[d] = p[d];
        }
    }

    public void setPosition(float p, int d) {
        this.position[d] = p;
    }

    public void setPosition(double p, int d) {
        this.position[d] = p;
    }

    public static class JacobianDeterminantRandomAccessibleInterval<T extends RealType<T>>
    extends AbstractRealInterval
    implements RealRandomAccessibleRealInterval<T> {
        protected final JacobianDeterminantRandomAccess<T> ra;

        public JacobianDeterminantRandomAccessibleInterval(Interval interval, T t, DifferentiableRealTransform transform) {
            super((RealInterval)interval);
            int nd = interval.dimension(2) < 2L ? 2 : 3;
            this.ra = nd == 2 ? new JacobianDeterminantRandomAccess<T>(new double[nd], t, transform) : new JacobianDeterminantRandomAccess<T>(new double[nd], t, transform);
        }

        public RealRandomAccess<T> realRandomAccess() {
            return this.ra.copy();
        }

        public RealRandomAccess<T> realRandomAccess(RealInterval interval) {
            return this.realRandomAccess();
        }

        public T getType() {
            return (T)((RealType)this.ra.getType());
        }

        public void setTransform(DifferentiableRealTransform transform) {
            this.ra.setTransform(transform);
        }
    }
}

