/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.realtransform;

import net.imglib2.RealLocalizable;
import net.imglib2.RealPositionable;
import net.imglib2.RealRandomAccess;
import net.imglib2.RealRandomAccessible;
import net.imglib2.realtransform.AffineInterpolator;
import net.imglib2.realtransform.AffineTransform2D;
import net.imglib2.realtransform.MaskedSimilarityTransform;
import net.imglib2.realtransform.RealTransform;
import net.imglib2.realtransform.RotationTransformInterpolator2D;
import net.imglib2.realtransform.SimilarityTransformInterpolator2D;
import net.imglib2.type.numeric.RealType;

public class MaskedSimilarityTransform2D<T extends RealType<T>>
implements RealTransform {
    private final RealRandomAccessible<T> lambda;
    private RealRandomAccess<T> lambdaAccess;
    private final AffineTransform2D transform;
    private final AffineInterpolator interpolator;
    private final double[] c;
    private final MaskedSimilarityTransform.Interpolators interp;

    public MaskedSimilarityTransform2D(AffineTransform2D transform, RealRandomAccessible<T> lambda) {
        this(transform, lambda, new double[3], MaskedSimilarityTransform.Interpolators.SIMILARITY);
    }

    public MaskedSimilarityTransform2D(AffineTransform2D transform, RealRandomAccessible<T> lambda, boolean flip) {
        this(transform, lambda, new double[3], MaskedSimilarityTransform.Interpolators.SIMILARITY);
    }

    public MaskedSimilarityTransform2D(AffineTransform2D transform, RealRandomAccessible<T> lambda, double[] c) {
        this(transform, lambda, c, MaskedSimilarityTransform.Interpolators.SIMILARITY);
    }

    public MaskedSimilarityTransform2D(AffineTransform2D transform, RealRandomAccessible<T> lambda, MaskedSimilarityTransform.Interpolators interp) {
        this(transform, lambda, new double[3], interp);
    }

    public MaskedSimilarityTransform2D(AffineTransform2D transform, RealRandomAccessible<T> lambda, double[] c, MaskedSimilarityTransform.Interpolators interp) {
        assert (transform.numSourceDimensions() == lambda.numDimensions());
        this.transform = transform;
        this.c = c;
        this.lambda = lambda;
        this.interp = interp;
        this.lambdaAccess = lambda.realRandomAccess();
        this.interpolator = interp == MaskedSimilarityTransform.Interpolators.SIMILARITY ? new SimilarityTransformInterpolator2D(transform, c) : new RotationTransformInterpolator2D(transform, c);
    }

    public int numSourceDimensions() {
        return this.transform.numSourceDimensions();
    }

    public int numTargetDimensions() {
        return this.transform.numTargetDimensions();
    }

    public void apply(double[] source, double[] target) {
        for (int i = 0; i < source.length; ++i) {
            this.lambdaAccess.setPosition(source[i], i);
        }
        double lam = ((RealType)this.lambdaAccess.get()).getRealDouble();
        this.interpolator.get(lam).apply(source, target);
    }

    public void apply(RealLocalizable source, RealPositionable target) {
        this.lambdaAccess.setPosition(source);
        double lam = ((RealType)this.lambdaAccess.get()).getRealDouble();
        this.interpolator.get(lam).apply(source, target);
    }

    public RealTransform copy() {
        return new MaskedSimilarityTransform2D<T>(this.transform.copy(), this.lambda, this.c, this.interp);
    }
}

