/*
 * Decompiled with CFR 0.152.
 */
package landmarks;

import ij.ImagePlus;
import ij.gui.ImageCanvas;
import java.awt.Color;
import java.awt.Graphics;

public class ProgressCanvas
extends ImageCanvas {
    protected ImagePlus imagePlus;
    int fixed_x;
    int fixed_y;
    int fixed_z;
    int transformed_x;
    int transformed_y;
    int transformed_z;
    boolean drawFixed = false;
    boolean drawTransformed = false;

    public ProgressCanvas(ImagePlus imagePlus) {
        super(imagePlus);
        this.imagePlus = imagePlus;
    }

    protected void drawOverlay(Graphics g) {
        int y_pixel_height;
        int x_pixel_width;
        int y;
        int x;
        int sliceZeroIndexed = this.imagePlus.getCurrentSlice() - 1;
        if (this.drawFixed && this.fixed_z == sliceZeroIndexed) {
            x = this.screenX(this.fixed_x);
            y = this.screenY(this.fixed_y);
            x_pixel_width = this.screenX(this.fixed_x + 1) - x;
            y_pixel_height = this.screenY(this.fixed_y + 1) - y;
            this.drawCrosshairs(g, Color.magenta, x + x_pixel_width / 2, y + y_pixel_height / 2);
        }
        if (this.drawTransformed && this.transformed_z == sliceZeroIndexed) {
            x = this.screenX(this.transformed_x);
            y = this.screenY(this.transformed_y);
            x_pixel_width = this.screenX(this.transformed_x + 1) - x;
            y_pixel_height = this.screenY(this.transformed_y + 1) - y;
            this.drawCrosshairs(g, Color.green, x + x_pixel_width / 2, y + y_pixel_height / 2);
        }
    }

    public void paint(Graphics g) {
        super.paint(g);
        this.drawOverlay(g);
    }

    protected void drawCrosshairs(Graphics g, Color c, int x_on_screen, int y_on_screen) {
        g.setColor(c);
        int hairLength = 8;
        g.drawLine(x_on_screen, y_on_screen + 1, x_on_screen, y_on_screen + (hairLength - 1));
        g.drawLine(x_on_screen, y_on_screen - 1, x_on_screen, y_on_screen - (hairLength - 1));
        g.drawLine(x_on_screen + 1, y_on_screen, x_on_screen + (hairLength - 1), y_on_screen);
        g.drawLine(x_on_screen - 1, y_on_screen, x_on_screen - (hairLength - 1), y_on_screen);
    }

    public void setCrosshairs(int x, int y, int z, boolean fixed) {
        System.out.println("Setting crosshairs (fixed: " + fixed + ") to " + x + "," + y + "," + z);
        if (fixed) {
            this.fixed_x = x;
            this.fixed_y = y;
            this.fixed_z = z;
            this.drawFixed = true;
        } else {
            this.transformed_x = x;
            this.transformed_y = y;
            this.transformed_z = z;
            this.drawTransformed = true;
        }
    }
}

