/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.random.process;

import org.ojalgo.access.Access1D;
import org.ojalgo.array.Array1D;
import org.ojalgo.array.Array2D;
import org.ojalgo.random.Distribution;
import org.ojalgo.random.SampleSet;
import org.ojalgo.series.primitive.PrimitiveSeries;

public interface RandomProcess<D extends Distribution> {
    public D getDistribution(double var1);

    public SimulationResults simulate(int var1, int var2, double var3);

    public static final class SimulationResults {
        private final double myInitialValue;
        private final Array2D<Double> myResults;

        public SimulationResults(double initialValue, Array2D<Double> results) {
            this.myInitialValue = initialValue;
            this.myResults = results;
        }

        private SimulationResults() {
            this.myInitialValue = 0.0;
            this.myResults = null;
        }

        public int countSampleSets() {
            return (int)this.myResults.countColumns();
        }

        public int countScenarios() {
            return (int)this.myResults.countRows();
        }

        public double getInitialValue() {
            return this.myInitialValue;
        }

        public SampleSet getSampleSet(int index) {
            return SampleSet.wrap(this.myResults.sliceColumn(0L, index));
        }

        public PrimitiveSeries getScenario(int index) {
            Access1D tmpSlicedRow = this.myResults.sliceRow(index, 0L);
            return new PrimitiveSeries((Array1D)tmpSlicedRow){
                final /* synthetic */ Array1D val$tmpSlicedRow;
                {
                    this.val$tmpSlicedRow = array1D;
                }

                @Override
                public int size() {
                    return this.val$tmpSlicedRow.size() + 1;
                }

                @Override
                public double value(int index) {
                    if (index == 0) {
                        return myInitialValue;
                    }
                    return this.val$tmpSlicedRow.doubleValue(index - 1);
                }
            };
        }
    }
}

