/*
 * Decompiled with CFR 0.152.
 */
package com.mxgraph.swing.handler;

import com.mxgraph.swing.mxGraphComponent;
import com.mxgraph.swing.util.mxMouseAdapter;
import com.mxgraph.util.mxConstants;
import com.mxgraph.util.mxEventObject;
import com.mxgraph.util.mxEventSource;
import com.mxgraph.util.mxRectangle;
import com.mxgraph.util.mxUtils;
import com.mxgraph.view.mxCellState;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;

public class mxRotationHandler
extends mxMouseAdapter {
    public static ImageIcon ROTATE_ICON = null;
    private static double PI4;
    protected mxGraphComponent graphComponent;
    protected boolean enabled = true;
    protected JComponent handle;
    protected mxCellState currentState;
    protected double initialAngle;
    protected double currentAngle;
    protected Point first;

    public mxRotationHandler(mxGraphComponent graphComponent) {
        this.graphComponent = graphComponent;
        graphComponent.addMouseListener(this);
        this.handle = this.createHandle();
        graphComponent.addListener("afterPaint", new mxEventSource.mxIEventListener(){

            @Override
            public void invoke(Object sender, mxEventObject evt) {
                Graphics g = (Graphics)evt.getProperty("g");
                mxRotationHandler.this.paint(g);
            }
        });
        graphComponent.getGraphControl().addMouseListener(this);
        graphComponent.getGraphControl().addMouseMotionListener(this);
        this.handle.addMouseListener(this);
        this.handle.addMouseMotionListener(this);
    }

    public mxGraphComponent getGraphComponent() {
        return this.graphComponent;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean value) {
        this.enabled = value;
    }

    protected JComponent createHandle() {
        JLabel label = new JLabel(ROTATE_ICON);
        label.setSize(ROTATE_ICON.getIconWidth(), ROTATE_ICON.getIconHeight());
        label.setOpaque(false);
        return label;
    }

    public boolean isStateHandled(mxCellState state) {
        return this.graphComponent.getGraph().getModel().isVertex(state.getCell());
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (this.currentState != null && this.handle.getParent() != null && e.getSource() == this.handle) {
            this.start(e);
            e.consume();
        }
    }

    public void start(MouseEvent e) {
        this.currentAngle = this.initialAngle = mxUtils.getDouble(this.currentState.getStyle(), mxConstants.STYLE_ROTATION) * mxConstants.RAD_PER_DEG;
        this.first = SwingUtilities.convertPoint(e.getComponent(), e.getPoint(), this.graphComponent.getGraphControl());
        if (!this.graphComponent.getGraph().isCellSelected(this.currentState.getCell())) {
            this.graphComponent.selectCellForEvent(this.currentState.getCell(), e);
        }
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        if (this.graphComponent.isEnabled() && this.isEnabled()) {
            if (this.handle.getParent() != null && e.getSource() == this.handle) {
                this.graphComponent.getGraphControl().setCursor(new Cursor(12));
                e.consume();
            } else if (this.currentState == null || !this.currentState.getRectangle().contains(e.getPoint())) {
                mxCellState eventState = this.graphComponent.getGraph().getView().getState(this.graphComponent.getCellAt(e.getX(), e.getY(), false));
                mxCellState state = null;
                if (eventState != null && this.isStateHandled(eventState)) {
                    state = eventState;
                }
                if (this.currentState != state) {
                    this.currentState = state;
                    if (this.currentState == null && this.handle.getParent() != null) {
                        this.handle.setVisible(false);
                        this.handle.getParent().remove(this.handle);
                    } else if (this.currentState != null) {
                        if (this.handle.getParent() == null) {
                            this.graphComponent.getGraphControl().add((Component)this.handle, 0);
                            this.handle.setVisible(true);
                        }
                        this.handle.setLocation((int)(this.currentState.getX() + this.currentState.getWidth() - (double)this.handle.getWidth() - 4.0), (int)(this.currentState.getY() + this.currentState.getHeight() - (double)this.handle.getWidth() - 4.0));
                    }
                }
            }
        }
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if (this.graphComponent.isEnabled() && this.isEnabled() && !e.isConsumed() && this.first != null) {
            mxRectangle dirty = mxUtils.getBoundingBox(this.currentState, this.currentAngle * mxConstants.DEG_PER_RAD);
            Point pt = SwingUtilities.convertPoint(e.getComponent(), e.getPoint(), this.graphComponent.getGraphControl());
            double cx = this.currentState.getCenterX();
            double cy = this.currentState.getCenterY();
            double dx = pt.getX() - cx;
            double dy = pt.getY() - cy;
            double c = Math.sqrt(dx * dx + dy * dy);
            this.currentAngle = (double)(pt.getX() > cx ? -1 : 1) * Math.acos(dy / c) + PI4 + this.initialAngle;
            dirty.add(mxUtils.getBoundingBox(this.currentState, this.currentAngle * mxConstants.DEG_PER_RAD));
            dirty.grow(1.0);
            this.graphComponent.getGraphControl().repaint(dirty.getRectangle());
            e.consume();
        } else if (this.handle.getParent() != null) {
            this.handle.getParent().remove(this.handle);
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (this.graphComponent.isEnabled() && this.isEnabled() && !e.isConsumed() && this.first != null) {
            double deg = 0.0;
            Object cell = null;
            if (this.currentState != null) {
                cell = this.currentState.getCell();
            }
            deg += this.currentAngle * mxConstants.DEG_PER_RAD;
            boolean willExecute = cell != null && this.first != null;
            this.reset();
            if (this.graphComponent.isEnabled() && this.isEnabled() && !e.isConsumed() && willExecute) {
                this.graphComponent.getGraph().setCellStyles(mxConstants.STYLE_ROTATION, String.valueOf(deg), new Object[]{cell});
                this.graphComponent.getGraphControl().repaint();
                e.consume();
            }
        }
        this.currentState = null;
    }

    public void reset() {
        if (this.handle.getParent() != null) {
            this.handle.getParent().remove(this.handle);
        }
        mxRectangle dirty = null;
        if (this.currentState != null && this.first != null) {
            dirty = mxUtils.getBoundingBox(this.currentState, this.currentAngle * mxConstants.DEG_PER_RAD);
            dirty.grow(1.0);
        }
        this.currentState = null;
        this.currentAngle = 0.0;
        this.first = null;
        if (dirty != null) {
            this.graphComponent.getGraphControl().repaint(dirty.getRectangle());
        }
    }

    public void paint(Graphics g) {
        if (this.currentState != null && this.first != null) {
            Rectangle rect = this.currentState.getRectangle();
            double deg = this.currentAngle * mxConstants.DEG_PER_RAD;
            if (deg != 0.0) {
                ((Graphics2D)g).rotate(Math.toRadians(deg), this.currentState.getCenterX(), this.currentState.getCenterY());
            }
            mxUtils.setAntiAlias((Graphics2D)g, true, false);
            g.drawRect(rect.x, rect.y, rect.width, rect.height);
        }
    }

    static {
        ROTATE_ICON = new ImageIcon(mxRotationHandler.class.getResource("/com/mxgraph/swing/images/rotate.gif"));
        PI4 = 0.7853981633974483;
    }
}

